/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.industrial.block.generator.tile;

import com.buuz135.industrial.block.generator.mycelial.IMycelialGeneratorType;
import com.buuz135.industrial.block.tile.IndustrialGeneratorTile;
import com.buuz135.industrial.gui.component.GeneratorBackgroundScreenAddon;
import com.buuz135.industrial.worlddata.MycelialDataManager;
import com.hrznstudio.titanium.annotation.Save;
import com.hrznstudio.titanium.api.IFactory;
import com.hrznstudio.titanium.api.client.IScreenAddon;
import com.hrznstudio.titanium.block.tile.GeneratorTile;
import com.hrznstudio.titanium.client.screen.addon.ProgressBarScreenAddon;
import com.hrznstudio.titanium.component.IComponentHarness;
import com.hrznstudio.titanium.component.fluid.FluidTankComponent;
import com.hrznstudio.titanium.component.fluid.SidedFluidTankComponent;
import com.hrznstudio.titanium.component.inventory.InventoryComponent;
import com.hrznstudio.titanium.component.inventory.SidedInventoryComponent;
import com.hrznstudio.titanium.component.progress.ProgressBarComponent;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.registries.RegistryObject;
import org.apache.commons.lang3.tuple.Pair;

public class MycelialGeneratorTile
extends IndustrialGeneratorTile<MycelialGeneratorTile> {
    @Save
    private int powerGeneration;
    private IMycelialGeneratorType type;
    private INBTSerializable<CompoundTag>[] inputs;
    private ProgressBarComponent<MycelialGeneratorTile> bar;
    @Save
    private String owner;

    public MycelialGeneratorTile(Pair<RegistryObject<Block>, RegistryObject<BlockEntityType<?>>> basicTileBlock, IMycelialGeneratorType type, BlockPos blockPos, BlockState blockState) {
        super(basicTileBlock, blockPos, blockState);
        this.type = type;
        this.powerGeneration = 10;
        this.inputs = new INBTSerializable[this.type.getInputs().length];
        for (int i = 0; i < this.type.getInputs().length; ++i) {
            SidedInventoryComponent slot;
            if (this.type.getInputs()[i] == IMycelialGeneratorType.Input.SLOT) {
                slot = (SidedInventoryComponent)new SidedInventoryComponent(this.type.getName() + ".input_" + i, 44 + i * 21, 22, 1, i).setColor(this.type.getInputColors()[i]).setInputFilter(this.type.getSlotInputPredicates().get(i)).setSlotLimit(type.getSlotSize());
                this.addInventory((InventoryComponent)slot);
                this.inputs[i] = slot;
                continue;
            }
            if (this.type.getInputs()[i] != IMycelialGeneratorType.Input.TANK) continue;
            slot = (SidedFluidTankComponent)new SidedFluidTankComponent(this.type.getName() + ".input_" + i, 8000, 44 + i * 21, 20, i).setColor(this.type.getInputColors()[i]).setTankAction(FluidTankComponent.Action.FILL).setValidator(this.type.getTankInputPredicates().get(i));
            this.addTank((FluidTankComponent)slot);
            this.inputs[i] = slot;
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void initClient() {
        super.initClient();
        this.addGuiAddonFactory(() -> new GeneratorBackgroundScreenAddon(128, 39, this.type));
    }

    public int consumeFuel() {
        Pair<Integer, Integer> inputs = this.type.getTimeAndPowerGeneration(this.inputs);
        this.powerGeneration = (Integer)inputs.getRight();
        return (Integer)inputs.getKey();
    }

    public boolean canStart() {
        return this.type.canStart(this.inputs);
    }

    public int getEnergyProducedEveryTick() {
        return this.powerGeneration;
    }

    public ProgressBarComponent<MycelialGeneratorTile> getProgressBar() {
        this.bar = new ProgressBarComponent<MycelialGeneratorTile>(30, 20, 0, 100){

            @OnlyIn(value=Dist.CLIENT)
            public List<IFactory<? extends IScreenAddon>> getScreenAddons() {
                return Collections.singletonList(() -> new ProgressBarScreenAddon(30, 20, MycelialGeneratorTile.this.bar){

                    @OnlyIn(value=Dist.CLIENT)
                    public List<Component> getTooltipLines() {
                        ArrayList<Component> tooltip = new ArrayList<Component>();
                        tooltip.add((Component)new TextComponent(ChatFormatting.GOLD + new TranslatableComponent("tooltip.titanium.progressbar.progress").getString() + ChatFormatting.WHITE + new DecimalFormat().format(MycelialGeneratorTile.this.bar.getProgress()) + ChatFormatting.GOLD + "/" + ChatFormatting.WHITE + new DecimalFormat().format(MycelialGeneratorTile.this.bar.getMaxProgress())));
                        int progress = MycelialGeneratorTile.this.bar.getMaxProgress() - MycelialGeneratorTile.this.bar.getProgress();
                        if (!MycelialGeneratorTile.this.bar.getIncreaseType()) {
                            progress = MycelialGeneratorTile.this.bar.getMaxProgress() - progress;
                        }
                        tooltip.add((Component)new TextComponent(ChatFormatting.GOLD + "ETA: " + ChatFormatting.WHITE + new DecimalFormat().format(Math.ceil((double)(progress * MycelialGeneratorTile.this.bar.getTickingTime()) / 20.0 / (double)MycelialGeneratorTile.this.bar.getProgressIncrease())) + ChatFormatting.DARK_AQUA + "s"));
                        tooltip.add((Component)new TextComponent(ChatFormatting.GOLD + new TranslatableComponent("tooltip.industrialforegoing.generating").getString() + ChatFormatting.WHITE + MycelialGeneratorTile.this.powerGeneration + ChatFormatting.DARK_AQUA + " FE" + ChatFormatting.GOLD + "/" + ChatFormatting.WHITE + ChatFormatting.DARK_AQUA + "t"));
                        return tooltip;
                    }
                });
            }
        }.setComponentHarness((IComponentHarness)this).setBarDirection(ProgressBarComponent.BarDirection.VERTICAL_UP).setColor(DyeColor.CYAN);
        return this.bar;
    }

    public void serverTick(Level level, BlockPos pos, BlockState state, MycelialGeneratorTile blockEntity) {
        if (this.bar.getCanIncrease().test(this) && (this.bar.getProgress() != 0 || this.canStart()) && this.f_58857_.m_46467_() % 5L == 0L) {
            MycelialDataManager.setGeneratorInfo(this.owner, this.f_58857_, this.f_58858_, this.type);
            this.type.onTick(this.f_58857_, this.f_58858_);
        }
        super.serverTick(level, pos, state, (GeneratorTile)blockEntity);
    }

    protected void m_183515_(CompoundTag compoundTag) {
        super.m_183515_(compoundTag);
        for (int i = 0; i < this.inputs.length; ++i) {
            compoundTag.m_128365_("input_" + i, this.inputs[i].serializeNBT());
        }
    }

    public void m_142466_(CompoundTag compound) {
        for (int i = 0; i < this.inputs.length; ++i) {
            this.inputs[i].deserializeNBT((Tag)compound.m_128469_("input_" + i));
        }
        super.m_142466_(compound);
    }

    public int getEnergyCapacity() {
        return 100000;
    }

    public int getExtractingEnergy() {
        return 100000;
    }

    @Nonnull
    public MycelialGeneratorTile getSelf() {
        return this;
    }

    public boolean isSmart() {
        return true;
    }

    public String getOwner() {
        return this.owner;
    }

    public void setOwner(String owner) {
        this.owner = owner;
    }
}

