/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermal.core.config;

import cofh.core.config.IBaseConfig;
import cofh.thermal.core.block.entity.device.DeviceComposterTile;
import cofh.thermal.core.block.entity.device.DeviceFisherTile;
import cofh.thermal.core.block.entity.device.DeviceTreeExtractorTile;
import cofh.thermal.lib.common.ThermalFlags;
import java.util.function.Supplier;
import net.minecraftforge.common.ForgeConfigSpec;

public class ThermalDeviceConfig
implements IBaseConfig {
    private Supplier<Integer> deviceTreeExtractorTimeConstant;
    private Supplier<Integer> deviceComposterTimeConstant;
    private Supplier<Boolean> deviceComposterParticles;
    private Supplier<Integer> deviceFisherTimeConstant;
    private Supplier<Integer> deviceFisherTimeReductionWater;
    private Supplier<Boolean> deviceFisherParticles;

    public void apply(ForgeConfigSpec.Builder builder) {
        builder.push("Devices");
        if (ThermalFlags.getFlag("device_tree_extractor").get().booleanValue()) {
            builder.push("TreeExtractor");
            this.deviceTreeExtractorTimeConstant = builder.comment("This sets the base time constant (in ticks) for the Arboreal Extractor.").defineInRange("Time Constant", 500, 20, 72000);
            builder.pop();
        }
        if (ThermalFlags.getFlag("device_composter").get().booleanValue()) {
            builder.push("Composter");
            this.deviceComposterTimeConstant = builder.comment("This sets the base time constant (in ticks) for the Batch Composter.").defineInRange("Time Constant", 120, 20, 72000);
            this.deviceComposterParticles = builder.comment("If TRUE, the Batch Composter will have particle effects when operating.").define("Particles", true);
            builder.pop();
        }
        if (ThermalFlags.getFlag("device_fisher").get().booleanValue()) {
            builder.push("Fisher");
            this.deviceFisherTimeConstant = builder.comment("This sets the base time constant (in ticks) for the Aquatic Entangler.").defineInRange("Time Constant", 4800, 400, 72000);
            this.deviceFisherTimeReductionWater = builder.comment("This sets the time constant reduction (in ticks) per nearby Water source block for the Aquatic Entangler.").defineInRange("Water Source Time Constant Reduction", 20, 1, 1000);
            this.deviceFisherParticles = builder.comment("If TRUE, the Aquatic Entangler will have particle effects when operating.").define("Particles", true);
            builder.pop();
        }
        builder.pop();
    }

    public void refresh() {
        if (this.deviceTreeExtractorTimeConstant != null) {
            DeviceTreeExtractorTile.setTimeConstant(this.deviceTreeExtractorTimeConstant.get());
        }
        if (this.deviceComposterTimeConstant != null) {
            DeviceComposterTile.setTimeConstant(this.deviceComposterTimeConstant.get());
            DeviceComposterTile.setParticles(this.deviceComposterParticles.get());
        }
        if (this.deviceFisherTimeConstant != null) {
            DeviceFisherTile.setTimeConstant(this.deviceFisherTimeConstant.get());
            DeviceFisherTile.setTimeReductionWater(this.deviceFisherTimeReductionWater.get());
            DeviceFisherTile.setParticles(this.deviceFisherParticles.get());
        }
    }
}

