/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermal.core.entity.monster;

import cofh.core.init.CoreMobEffects;
import cofh.core.init.CoreParticles;
import cofh.thermal.core.ThermalCore;
import cofh.thermal.core.config.ThermalClientConfig;
import cofh.thermal.core.entity.projectile.BlitzProjectile;
import cofh.thermal.core.init.TCoreSounds;
import cofh.thermal.lib.common.ThermalFlags;
import java.util.EnumSet;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.FlyingMoveControl;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MoveTowardsRestrictionGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.navigation.FlyingPathNavigation;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;

public class Blitz
extends Monster {
    private static final EntityDataAccessor<Byte> ANGRY = SynchedEntityData.m_135353_(Blitz.class, (EntityDataSerializer)EntityDataSerializers.f_135027_);

    public static boolean canSpawn(EntityType<Blitz> entityType, ServerLevelAccessor world, MobSpawnType reason, BlockPos pos, Random rand) {
        return ThermalFlags.getFlag(ThermalFlags.FLAG_MOB_BLITZ).get() != false && Monster.m_33017_(entityType, (ServerLevelAccessor)world, (MobSpawnType)reason, (BlockPos)pos, (Random)rand);
    }

    public Blitz(EntityType<? extends Blitz> type, Level world) {
        super(type, world);
        this.f_21342_ = new FlyingMoveControl((Mob)this, 20, true);
        this.f_21344_ = new FlyingPathNavigation((Mob)this, world);
        this.m_21441_(BlockPathTypes.WATER, -1.0f);
        this.m_21441_(BlockPathTypes.LAVA, -1.0f);
        this.f_21364_ = 10;
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(4, (Goal)new BlitzAttackGoal(this));
        this.f_21345_.m_25352_(5, (Goal)new MoveTowardsRestrictionGoal((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(7, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0, 0.0f));
        this.f_21345_.m_25352_(8, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.f_21345_.m_25352_(8, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21345_.m_25352_(8, (Goal)new FloatGoal((Mob)this));
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]).m_26044_(new Class[0]));
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true));
    }

    public static AttributeSupplier.Builder registerAttributes() {
        return Monster.m_33035_().m_22268_(Attributes.f_22281_, 6.0).m_22268_(Attributes.f_22279_, (double)0.23f).m_22268_(Attributes.f_22280_, (double)0.6f).m_22268_(Attributes.f_22277_, 48.0);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(ANGRY, (Object)0);
    }

    protected SoundEvent m_7515_() {
        return ThermalClientConfig.mobAmbientSounds.get() != false ? (SoundEvent)TCoreSounds.SOUND_BLITZ_AMBIENT.get() : null;
    }

    protected SoundEvent m_7975_(DamageSource damageSourceIn) {
        return (SoundEvent)TCoreSounds.SOUND_BLITZ_HURT.get();
    }

    protected SoundEvent m_5592_() {
        return (SoundEvent)TCoreSounds.SOUND_BLITZ_DEATH.get();
    }

    public void m_8107_() {
        if (!this.f_19861_ && this.m_20184_().f_82480_ < 0.0) {
            this.m_20256_(this.m_20184_().m_82542_(1.0, 0.6, 1.0));
        }
        if (this.f_19853_.f_46443_ && this.f_19796_.nextInt(3) == 0) {
            this.f_19853_.m_7106_((ParticleOptions)(this.isAngry() ? (SimpleParticleType)CoreParticles.SPARK.get() : ParticleTypes.f_123796_), this.m_20208_(0.5), this.m_20187_(), this.m_20262_(0.5), 0.0, 0.0, 0.0);
        }
        super.m_8107_();
    }

    public boolean m_7301_(MobEffectInstance effect) {
        return super.m_7301_(effect) && !effect.m_19544_().equals(CoreMobEffects.SHOCKED.get());
    }

    public boolean m_142535_(float distance, float damageMultiplier, DamageSource source) {
        return false;
    }

    public ItemStack getPickedResult(HitResult target) {
        return new ItemStack((ItemLike)ThermalCore.ITEMS.get("blitz_spawn_egg"));
    }

    public boolean m_6673_(DamageSource source) {
        return source == DamageSource.f_19306_ || source.f_19326_.equals("blitz") || super.m_6673_(source);
    }

    public boolean isAngry() {
        return ((Byte)this.f_19804_.m_135370_(ANGRY) & 1) != 0;
    }

    protected void setAngry(boolean angry) {
        byte b0 = (Byte)this.f_19804_.m_135370_(ANGRY);
        b0 = angry ? (byte)(b0 | 1) : (byte)(b0 & 0xFFFFFFFE);
        this.f_19804_.m_135381_(ANGRY, (Object)b0);
    }

    static class BlitzAttackGoal
    extends Goal {
        private final Blitz blitz;
        private int attackTime;
        private int navTime;

        public BlitzAttackGoal(Blitz blitzIn) {
            this.blitz = blitzIn;
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        }

        public boolean m_8036_() {
            LivingEntity target = this.blitz.m_5448_();
            return target != null && target.m_6084_() && this.blitz.m_6779_(target);
        }

        public void m_8056_() {
            this.navTime = 0;
        }

        public void m_8041_() {
            this.blitz.setAngry(false);
            this.navTime = 0;
        }

        public void m_8037_() {
            --this.attackTime;
            --this.navTime;
            LivingEntity target = this.blitz.m_5448_();
            if (target == null) {
                return;
            }
            Vec3 pos = this.blitz.m_20299_(0.5f);
            Vec3 targetPos = target.m_20182_().m_82520_(0.0, (double)(target.m_20206_() * 0.5f), 0.0);
            Vec3 diff = targetPos.m_82546_(pos);
            double distSqr = this.blitz.m_20280_((Entity)target);
            if (this.blitz.m_21574_().m_148306_((Entity)target) && distSqr < this.getFollowDistance() * this.getFollowDistance()) {
                this.blitz.m_21563_().m_24960_((Entity)target, 10.0f, 10.0f);
                this.blitz.setAngry(true);
                if (distSqr < 4.0) {
                    if (this.attackTime <= 0) {
                        this.attackTime = 20;
                        this.blitz.m_7327_((Entity)target);
                    }
                } else if (distSqr < 576.0) {
                    if (this.attackTime <= 0) {
                        this.attackTime = 20;
                        Level world = this.blitz.f_19853_;
                        world.m_6263_(null, pos.f_82479_ + 0.5, pos.f_82480_ + 0.5, pos.f_82481_ + 0.5, (SoundEvent)TCoreSounds.SOUND_BLITZ_SHOOT.get(), SoundSource.HOSTILE, 1.0f, (this.blitz.f_19796_.nextFloat() - 0.5f) * 0.2f + 1.0f);
                        float gravity = 0.05f;
                        float horzSpeed = 0.8f;
                        double horzDist = Math.sqrt(diff.m_165925_());
                        double time = 1.25 * horzDist;
                        Vec3 horzVel = diff.m_82490_((double)horzSpeed / horzDist);
                        BlitzProjectile projectile = new BlitzProjectile(pos.f_82479_, pos.f_82480_, pos.f_82481_, 0.0, -gravity, 0.0, world);
                        projectile.m_20334_(horzVel.f_82479_, (double)gravity * time + diff.f_82480_ / time, horzVel.f_82481_);
                        projectile.m_5602_((Entity)this.blitz);
                        world.m_7967_((Entity)projectile);
                    }
                    if (distSqr > 400.0) {
                        this.blitz.f_21344_.m_26573_();
                        this.navTime = 0;
                    } else if (this.navTime <= 0) {
                        Vec3 want = new Vec3(pos.f_82479_ - targetPos.f_82479_, 0.0, pos.f_82481_ - targetPos.f_82481_).m_82541_().m_82490_(30.0);
                        this.blitz.f_21344_.m_26519_(targetPos.f_82479_ + want.f_82479_, targetPos.f_82480_, targetPos.f_82481_ + want.f_82481_, 1.0);
                        this.navTime = 15;
                    }
                } else if (this.navTime <= 0) {
                    this.blitz.f_21344_.m_26519_(targetPos.f_82479_, targetPos.f_82480_, targetPos.f_82481_, 1.0);
                    this.navTime = 15;
                }
            } else {
                this.blitz.setAngry(false);
            }
            super.m_8037_();
        }

        private double getFollowDistance() {
            return this.blitz.m_21133_(Attributes.f_22277_);
        }
    }
}

