/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermal.core.util.managers.machine;

import cofh.lib.api.fluid.IFluidStackHolder;
import cofh.lib.api.inventory.IItemStackHolder;
import cofh.lib.util.crafting.ComparableItemStack;
import cofh.thermal.core.init.TCoreRecipeTypes;
import cofh.thermal.core.item.SlotSealItem;
import cofh.thermal.lib.util.managers.AbstractManager;
import cofh.thermal.lib.util.managers.IRecipeManager;
import cofh.thermal.lib.util.recipes.IThermalInventory;
import cofh.thermal.lib.util.recipes.ThermalRecipe;
import cofh.thermal.lib.util.recipes.internal.IMachineRecipe;
import cofh.thermal.lib.util.recipes.internal.SimpleMachineRecipe;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraftforge.fluids.FluidStack;

public class PressRecipeManager
extends AbstractManager
implements IRecipeManager {
    private static final PressRecipeManager INSTANCE = new PressRecipeManager();
    protected static final int DEFAULT_ENERGY = 2400;
    protected Map<List<ComparableItemStack>, IMachineRecipe> recipeMap = new Object2ObjectOpenHashMap();
    protected Set<ComparableItemStack> validInputs = new ObjectOpenHashSet();
    protected Set<ComparableItemStack> validDies = new ObjectOpenHashSet();
    protected int maxOutputItems = 1;
    protected int maxOutputFluids = 1;

    public static PressRecipeManager instance() {
        return INSTANCE;
    }

    private PressRecipeManager() {
        super(2400);
    }

    public void addRecipe(ThermalRecipe recipe) {
        if (recipe.getInputItems().size() == 1) {
            for (ItemStack recipeInput : recipe.getInputItems().get(0).m_43908_()) {
                this.addRecipe(recipe.getEnergy(), recipe.getXp(), Collections.singletonList(recipeInput), Collections.emptyList(), recipe.getOutputItems(), recipe.getOutputItemChances(), recipe.getOutputFluids());
            }
        } else {
            for (ItemStack dieInput : recipe.getInputItems().get(1).m_43908_()) {
                for (ItemStack recipeInput : recipe.getInputItems().get(0).m_43908_()) {
                    this.addRecipe(recipe.getEnergy(), recipe.getXp(), Arrays.asList(recipeInput, dieInput), Collections.emptyList(), recipe.getOutputItems(), recipe.getOutputItemChances(), recipe.getOutputFluids());
                }
            }
        }
    }

    public boolean validInput(ItemStack item) {
        return this.validInputs.contains(PressRecipeManager.makeComparable(item));
    }

    public boolean validDie(ItemStack item) {
        return this.validDies.contains(PressRecipeManager.makeComparable(item));
    }

    protected void clear() {
        this.recipeMap.clear();
        this.validInputs.clear();
        this.validDies.clear();
    }

    protected ArrayList<ComparableItemStack> getKeyFromSlots(List<? extends IItemStackHolder> inputSlots) {
        ArrayList<ComparableItemStack> key = new ArrayList<ComparableItemStack>();
        for (IItemStackHolder iItemStackHolder : inputSlots) {
            if (iItemStackHolder.isEmpty() || iItemStackHolder.getItemStack().m_41720_() instanceof SlotSealItem) continue;
            key.add(PressRecipeManager.makeComparable(iItemStackHolder.getItemStack()));
        }
        return key;
    }

    protected ArrayList<ComparableItemStack> getKeyFromStacks(List<ItemStack> inputStacks) {
        ArrayList<ComparableItemStack> key = new ArrayList<ComparableItemStack>();
        for (ItemStack stack : inputStacks) {
            if (stack.m_41619_() || stack.m_41720_() instanceof SlotSealItem) continue;
            key.add(PressRecipeManager.makeComparable(stack));
        }
        return key;
    }

    protected IMachineRecipe getRecipe(List<? extends IItemStackHolder> inputSlots, List<? extends IFluidStackHolder> inputTanks) {
        if (inputSlots.isEmpty() || inputSlots.get(0).isEmpty()) {
            return null;
        }
        return this.recipeMap.get(this.getKeyFromSlots(inputSlots));
    }

    protected IMachineRecipe addRecipe(int energy, float experience, List<ItemStack> inputItems, List<FluidStack> inputFluids, List<ItemStack> outputItems, List<Float> chance, List<FluidStack> outputFluids) {
        if (inputItems.isEmpty() || outputItems.isEmpty() && outputFluids.isEmpty() || outputItems.size() > this.maxOutputItems || outputFluids.size() > this.maxOutputFluids || energy <= 0) {
            return null;
        }
        if (inputItems.get(0).m_41619_()) {
            return null;
        }
        for (ItemStack itemStack : outputItems) {
            if (!itemStack.m_41619_()) continue;
            return null;
        }
        for (FluidStack fluidStack : outputFluids) {
            if (!fluidStack.isEmpty()) continue;
            return null;
        }
        energy = (int)((float)energy * this.getDefaultScale());
        SimpleMachineRecipe recipe = new SimpleMachineRecipe(energy, experience, inputItems, inputFluids, outputItems, chance, outputFluids);
        this.validInputs.add(PressRecipeManager.makeComparable(inputItems.get(0)));
        if (inputItems.size() > 1 && !inputItems.get(1).m_41619_()) {
            this.validDies.add(PressRecipeManager.makeComparable(inputItems.get(1)));
        }
        this.recipeMap.put(this.getKeyFromStacks(inputItems), recipe);
        return recipe;
    }

    @Override
    public IMachineRecipe getRecipe(IThermalInventory inventory) {
        return this.getRecipe(inventory.inputSlots(), inventory.inputTanks());
    }

    @Override
    public List<IMachineRecipe> getRecipeList() {
        return new ArrayList<IMachineRecipe>(this.recipeMap.values());
    }

    @Override
    public void refresh(RecipeManager recipeManager) {
        this.clear();
        Map recipes = recipeManager.m_44054_(TCoreRecipeTypes.RECIPE_PRESS);
        for (Map.Entry entry : recipes.entrySet()) {
            this.addRecipe((ThermalRecipe)((Object)entry.getValue()));
        }
    }
}

