/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermal.core.util.recipes.device;

import cofh.lib.util.recipes.RecipeJsonUtils;
import cofh.thermal.core.util.managers.device.RockGenManager;
import cofh.thermal.core.util.recipes.device.RockGenMapping;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import javax.annotation.Nullable;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.ForgeRegistryEntry;

public class RockGenMappingSerializer
extends ForgeRegistryEntry<RecipeSerializer<?>>
implements RecipeSerializer<RockGenMapping> {
    public RockGenMapping fromJson(ResourceLocation recipeId, JsonObject json) {
        int time = RockGenManager.instance().getDefaultEnergy();
        Block below = Blocks.f_50016_;
        Block adjacent = Blocks.f_50016_;
        ItemStack result = ItemStack.f_41583_;
        if (json.has("below")) {
            below = RecipeJsonUtils.parseBlock((JsonElement)json.get("below"));
        } else if (json.has("base")) {
            below = RecipeJsonUtils.parseBlock((JsonElement)json.get("base"));
        }
        if (json.has("adjacent")) {
            adjacent = RecipeJsonUtils.parseBlock((JsonElement)json.get("adjacent"));
        }
        if (json.has("result")) {
            result = RecipeJsonUtils.parseItemStack((JsonElement)json.get("result"));
        } else if (json.has("item")) {
            result = RecipeJsonUtils.parseItemStack((JsonElement)json.get("item"));
        }
        if (json.has("time")) {
            time = json.get("time").getAsInt();
        } else if (json.has("ticks")) {
            time = json.get("ticks").getAsInt();
        }
        return new RockGenMapping(recipeId, time, below, adjacent, result);
    }

    @Nullable
    public RockGenMapping fromNetwork(ResourceLocation recipeId, FriendlyByteBuf buffer) {
        int time = buffer.readInt();
        Block trunk = (Block)ForgeRegistries.BLOCKS.getValue(buffer.m_130281_());
        Block leaves = (Block)ForgeRegistries.BLOCKS.getValue(buffer.m_130281_());
        ItemStack result = buffer.m_130267_();
        return new RockGenMapping(recipeId, time, trunk, leaves, result);
    }

    public void toNetwork(FriendlyByteBuf buffer, RockGenMapping recipe) {
        buffer.writeInt(recipe.time);
        buffer.m_130085_(recipe.below.getRegistryName());
        buffer.m_130085_(recipe.adjacent.getRegistryName());
        buffer.m_130055_(recipe.result);
    }
}

