/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.clothconfig2.gui.entries;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Locale;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Supplier;
import me.shedaniel.clothconfig2.gui.entries.TextFieldListEntry;
import me.shedaniel.clothconfig2.gui.widget.ColorDisplayWidget;
import net.minecraft.client.Minecraft;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

public class ColorEntry
extends TextFieldListEntry<Integer> {
    private final ColorDisplayWidget colorDisplayWidget;
    private boolean alpha = true;

    @Deprecated
    @ApiStatus.Internal
    public ColorEntry(Component fieldName, int value, Component resetButtonKey, Supplier<Integer> defaultValue, Consumer<Integer> saveConsumer, Supplier<Optional<Component[]>> tooltipSupplier, boolean requiresRestart) {
        super(fieldName, 0, resetButtonKey, defaultValue, tooltipSupplier, requiresRestart);
        ColorValue colorValue = this.getColorValue(String.valueOf(value));
        if (colorValue.hasError()) {
            throw new IllegalArgumentException("Invalid Color: " + colorValue.getError().name());
        }
        this.alpha = false;
        this.saveCallback = saveConsumer;
        this.original = value;
        this.textFieldWidget.m_94144_(this.getHexColorString(value));
        this.colorDisplayWidget = new ColorDisplayWidget(this.textFieldWidget, 0, 0, 20, this.getColorValueColor(this.textFieldWidget.m_94155_()));
        this.resetButton.f_93717_ = button -> this.textFieldWidget.m_94144_(this.getHexColorString((Integer)defaultValue.get()));
    }

    @Override
    protected boolean isChanged(Integer original, String s) {
        ColorValue colorValue = this.getColorValue(s);
        return colorValue.hasError() || (Integer)this.original != colorValue.color;
    }

    @Override
    public void render(PoseStack matrices, int index, int y, int x, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean isHovered, float delta) {
        super.render(matrices, index, y, x, entryWidth, entryHeight, mouseX, mouseY, isHovered, delta);
        this.colorDisplayWidget.f_93621_ = y;
        ColorValue value = this.getColorValue(this.textFieldWidget.m_94155_());
        if (!value.hasError()) {
            this.colorDisplayWidget.setColor(this.alpha ? value.getColor() : 0xFF000000 | value.getColor());
        }
        this.colorDisplayWidget.f_93620_ = Minecraft.m_91087_().f_91062_.m_92718_() ? x + this.resetButton.m_5711_() + this.textFieldWidget.m_5711_() : this.textFieldWidget.f_93620_ - 23;
        this.colorDisplayWidget.m_6305_(matrices, mouseX, mouseY, delta);
    }

    @Override
    protected boolean isMatchDefault(String text) {
        if (!this.getDefaultValue().isPresent()) {
            return false;
        }
        ColorValue colorValue = this.getColorValue(text);
        return !colorValue.hasError() && colorValue.color == (Integer)this.getDefaultValue().get();
    }

    @Override
    public boolean isEdited() {
        ColorValue colorValue = this.getColorValue(this.textFieldWidget.m_94155_());
        return colorValue.hasError() || colorValue.color != (Integer)this.original;
    }

    @Override
    public Integer getValue() {
        return this.getColorValueColor(this.textFieldWidget.m_94155_());
    }

    @Deprecated
    public void setValue(int color) {
        this.textFieldWidget.m_94144_(this.getHexColorString(color));
    }

    @Override
    public Optional<Component> getError() {
        ColorValue colorValue = this.getColorValue(this.textFieldWidget.m_94155_());
        if (colorValue.hasError()) {
            return Optional.of(new TranslatableComponent("text.cloth-config.error.color." + colorValue.getError().name().toLowerCase(Locale.ROOT)));
        }
        return super.getError();
    }

    public void withAlpha() {
        if (!this.alpha) {
            this.alpha = true;
            this.textFieldWidget.m_94144_(this.getHexColorString((Integer)this.original));
        }
    }

    public void withoutAlpha() {
        if (this.alpha) {
            this.alpha = false;
            this.textFieldWidget.m_94144_(this.getHexColorString((Integer)this.original));
        }
    }

    protected String stripHexStarter(String hex) {
        if (hex.startsWith("#")) {
            return hex.substring(1);
        }
        return hex;
    }

    protected boolean isValidColorString(String str) {
        return !this.getColorValue(str).hasError();
    }

    protected int getColorValueColor(String str) {
        return this.getColorValue(str).getColor();
    }

    protected ColorValue getColorValue(String str) {
        try {
            int color;
            if (str.startsWith("#")) {
                String stripHexStarter = this.stripHexStarter(str);
                if (stripHexStarter.length() > 8) {
                    return ColorError.INVALID_COLOR.toValue();
                }
                if (!this.alpha && stripHexStarter.length() > 6) {
                    return ColorError.NO_ALPHA_ALLOWED.toValue();
                }
                color = (int)Long.parseLong(stripHexStarter, 16);
            } else {
                color = (int)Long.parseLong(str);
            }
            int a = color >> 24 & 0xFF;
            if (!this.alpha && a > 0) {
                return ColorError.NO_ALPHA_ALLOWED.toValue();
            }
            if (a < 0 || a > 255) {
                return ColorError.INVALID_ALPHA.toValue();
            }
            int r = color >> 16 & 0xFF;
            if (r < 0 || r > 255) {
                return ColorError.INVALID_RED.toValue();
            }
            int g = color >> 8 & 0xFF;
            if (g < 0 || g > 255) {
                return ColorError.INVALID_GREEN.toValue();
            }
            int b = color & 0xFF;
            if (b < 0 || b > 255) {
                return ColorError.INVALID_BLUE.toValue();
            }
            return new ColorValue(color);
        }
        catch (NumberFormatException e) {
            return ColorError.INVALID_COLOR.toValue();
        }
    }

    protected String getHexColorString(int color) {
        return "#" + StringUtils.leftPad((String)Integer.toHexString(color), (int)(this.alpha ? 8 : 6), (char)'0');
    }

    protected static class ColorValue {
        private int color = -1;
        @Nullable
        private ColorError error = null;

        public ColorValue(int color) {
            this.color = color;
        }

        public ColorValue(ColorError error) {
            this.error = error;
        }

        public int getColor() {
            return this.color;
        }

        @Nullable
        public ColorError getError() {
            return this.error;
        }

        public boolean hasError() {
            return this.getError() != null;
        }
    }

    protected static enum ColorError {
        NO_ALPHA_ALLOWED,
        INVALID_ALPHA,
        INVALID_RED,
        INVALID_GREEN,
        INVALID_BLUE,
        INVALID_COLOR;

        private final ColorValue value = new ColorValue(this);

        public ColorValue toValue() {
            return this.value;
        }
    }
}

