/*
 * Decompiled with CFR 0.152.
 */
package com.corosus.zombieawareness;

import com.corosus.zombieawareness.ZAUtil;
import com.corosus.zombieawareness.ZombieAwareness;
import com.corosus.zombieawareness.client.SoundProfileEntry;
import com.corosus.zombieawareness.config.ZAConfig;
import com.mojang.math.Vector3d;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.PlaySoundAtEntityEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingSetAttackTargetEvent;
import net.minecraftforge.event.entity.living.LivingSpawnEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.event.world.ExplosionEvent;
import net.minecraftforge.event.world.NoteBlockEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="zombieawareness", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class ZAEventHandler {
    @SubscribeEvent
    public void noteBlockEvent(NoteBlockEvent.Play event) {
        if (event.getWorld() instanceof Level) {
            ZAUtil.hookSoundEvent(SoundEvents.f_12209_, (Level)event.getWorld(), event.getPos().m_123341_(), event.getPos().m_123342_(), event.getPos().m_123343_(), 1.0f, 1.0f);
        }
    }

    @SubscribeEvent
    public void soundEvent(PlaySoundAtEntityEvent event) {
        try {
            if (event.getEntity() != null && !event.getEntity().f_19853_.m_5776_()) {
                ZAUtil.hookSoundEvent(event.getSound(), event.getEntity().f_19853_, event.getEntity().m_20185_(), event.getEntity().m_20186_(), event.getEntity().m_20189_(), event.getVolume(), event.getPitch());
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    @SubscribeEvent
    public void setAttackTarget(LivingSetAttackTargetEvent event) {
        if (!event.getEntityLiving().f_19853_.f_46443_) {
            if (!ZAUtil.isZombieAwarenessActive(event.getEntityLiving().f_19853_)) {
                return;
            }
            ZAUtil.hookSetAttackTarget(event);
        }
    }

    @SubscribeEvent
    public void breakSpeed(PlayerEvent.BreakSpeed event) {
        if (!event.getEntityLiving().f_19853_.f_46443_) {
            if (!ZAUtil.isZombieAwarenessActive(event.getEntityLiving().f_19853_)) {
                return;
            }
            if (!ZAConfig.blockHittingEvent_Active) {
                return;
            }
            ZAUtil.hookBlockEvent((PlayerEvent)event, ZAConfig.blockHittingEvent_OddsTo1);
        }
    }

    @SubscribeEvent
    public void harvest(PlayerEvent.HarvestCheck event) {
        if (!event.getEntityLiving().f_19853_.f_46443_) {
            // empty if block
        }
    }

    @SubscribeEvent
    public void breakBlock(BlockEvent.BreakEvent event) {
        if (!event.getWorld().m_5776_() && event.getWorld() instanceof Level) {
            if (!ZAUtil.isZombieAwarenessActive((Level)event.getWorld())) {
                return;
            }
            if (!ZAConfig.blockBreakEvent_Active) {
                return;
            }
            ZombieAwareness.dbg("HarvestDrops event");
            ZAUtil.handleBlockBasedEvent(event.getPlayer(), (Level)event.getWorld(), event.getPos(), 3);
        }
    }

    @SubscribeEvent
    public void interact(PlayerInteractEvent event) {
        if (event.getEntityLiving().f_19853_.f_46443_ || event.getHand() == InteractionHand.MAIN_HAND) {
            // empty if block
        }
    }

    @SubscribeEvent
    public void tickEntity(LivingEvent.LivingUpdateEvent event) {
        LivingEntity ent = event.getEntityLiving();
        if (ent.f_19853_.f_46443_) {
            return;
        }
        if ((ent.f_19853_.m_46467_() + (long)ent.m_142049_()) % (long)ZAConfig.tickRateAILoop == 0L && ZombieAwareness.canProcessEntity((Entity)ent) && ent instanceof Mob) {
            ZAUtil.tickAI((Mob)ent);
        }
    }

    @SubscribeEvent
    public void spawnEntity(LivingSpawnEvent.SpecialSpawn event) {
        LivingEntity ent = event.getEntityLiving();
        if (ent.f_19853_.f_46443_) {
            return;
        }
        ZAUtil.processMobSpawn(event);
    }

    @SubscribeEvent
    public void tickPlayer(TickEvent.PlayerTickEvent event) {
        if (event.player.f_19853_.f_46443_ || event.phase == TickEvent.Phase.END) {
            return;
        }
        if (event.player.f_19853_.m_46467_() % (long)ZAConfig.tickRatePlayerLoop == 0L) {
            ZAUtil.tickPlayer(event.player);
        }
    }

    @SubscribeEvent
    public void explosion(ExplosionEvent.Detonate event) {
        SoundProfileEntry entry = ZAUtil.getSoundIDEntry(SoundEvents.f_11913_.f_11656_.toString());
        if (entry != null) {
            Vec3 pos = event.getExplosion().getPosition();
            Player closestPlayer = ZAUtil.getClosestPlayer(event.getWorld(), pos.f_82479_, pos.f_82480_, pos.f_82481_, 128.0);
            if (closestPlayer != null) {
                ZAUtil.handleSoundProfileEvent(event.getWorld(), entry, new Vector3d(pos.f_82479_, pos.f_82480_, pos.f_82481_), closestPlayer);
            }
        }
    }
}

