/*
 * Decompiled with CFR 0.152.
 */
package com.corosus.zombieawareness;

import com.corosus.coroutil.util.CoroUtilAttributes;
import com.corosus.coroutil.util.CoroUtilEntity;
import com.corosus.coroutil.util.CoroUtilPath;
import com.corosus.coroutil.util.CoroUtilWorldTime;
import com.corosus.zombieawareness.EntityRegistry;
import com.corosus.zombieawareness.EntityScent;
import com.corosus.zombieawareness.EnumSenseType;
import com.corosus.zombieawareness.ZombieAwareness;
import com.corosus.zombieawareness.client.SoundProfileEntry;
import com.corosus.zombieawareness.client.SoundRegistry;
import com.corosus.zombieawareness.config.ZAConfig;
import com.corosus.zombieawareness.config.ZAConfigFeatures;
import com.corosus.zombieawareness.config.ZAConfigPlayerLists;
import com.mojang.math.Vector3d;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Random;
import java.util.WeakHashMap;
import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.monster.Skeleton;
import net.minecraft.world.entity.monster.Spider;
import net.minecraft.world.entity.monster.Zombie;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.ButtonBlock;
import net.minecraft.world.level.block.LeverBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.level.pathfinder.Node;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.event.entity.living.LivingSetAttackTargetEvent;
import net.minecraftforge.event.entity.living.LivingSpawnEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;

public class ZAUtil {
    public static Random rand = new Random();
    public static HashMap<String, Integer> lastHealths = new HashMap();
    public static HashMap<String, Long> lastBleedTimes = new HashMap();
    public static List<SoundProfileEntry> listSoundProfiles = new ArrayList<SoundProfileEntry>();
    public static HashMap<String, SoundProfileEntry> lookupSoundNameToProfileCache = new HashMap();
    public static HashMap<Integer, SoundProfileEntry> lookupSoundIntToProfile = new HashMap();
    public static WeakHashMap<Entity, Long> lookupLastAlertTime = new WeakHashMap();
    public static long alertDelay = 1200L;
    public static WeakHashMap<Entity, Long> lookupLastInvestigateTime = new WeakHashMap();
    public static long investigateDelay = 1200L;
    public static HashMap<String, Long> lookupLastWaypointTime = new HashMap();
    public static HashMap<EntityType, Boolean> lookupTickableEntitiesCache = new HashMap();
    public static String SPEED_BOOST_TAG = "za_speedbosted";
    public static String ZA_LAST_ACTION = "za_last_action";
    public static boolean debug = false;

    public static void addSoundHooks() {
        int noisyInteractRange = 30;
        double noisyInteractBuff = 1.3;
        listSoundProfiles.clear();
        lookupSoundIntToProfile.clear();
        lookupSoundNameToProfileCache.clear();
        listSoundProfiles.add(new SoundProfileEntry(SoundEvents.f_11686_, 1.1));
        listSoundProfiles.add(new SoundProfileEntry(SoundEvents.f_11685_, 1.1));
        listSoundProfiles.add(new SoundProfileEntry(SoundEvents.f_11840_, 1.1));
        listSoundProfiles.add(new SoundProfileEntry(SoundEvents.f_11747_, noisyInteractBuff).setMaxDistToSpawnFromPlayer(noisyInteractRange));
        ArrayList<Integer> listDoorSoundEvents = new ArrayList<Integer>();
        listDoorSoundEvents.add(1037);
        listDoorSoundEvents.add(1007);
        listDoorSoundEvents.add(1036);
        listDoorSoundEvents.add(1013);
        listDoorSoundEvents.add(1011);
        listDoorSoundEvents.add(1012);
        listDoorSoundEvents.add(1005);
        listDoorSoundEvents.add(1006);
        listDoorSoundEvents.add(1008);
        listDoorSoundEvents.add(1014);
        ZAUtil.addSoundIntegerEntry(new SoundProfileEntry("debug-doors", noisyInteractBuff).setListSoundEventTypes(listDoorSoundEvents));
        ArrayList<Integer> list = new ArrayList<Integer>();
        list.add(1010);
        ZAUtil.addSoundIntegerEntry(new SoundProfileEntry("debug-records", 300.0).setListSoundEventTypes(list));
        listSoundProfiles.add(new SoundProfileEntry(".place", noisyInteractBuff));
        listSoundProfiles.add(new SoundProfileEntry("player.burp", 1.1));
        listSoundProfiles.add(new SoundProfileEntry("block.note", noisyInteractBuff).setMaxDistToSpawnFromPlayer(64.0));
        listSoundProfiles.add(new SoundProfileEntry("lever.click", noisyInteractBuff).setMaxDistToSpawnFromPlayer(noisyInteractRange));
        listSoundProfiles.add(new SoundProfileEntry("pressure_plate", noisyInteractBuff).setMaxDistToSpawnFromPlayer(noisyInteractRange));
        listSoundProfiles.add(new SoundProfileEntry("button.click", noisyInteractBuff).setMaxDistToSpawnFromPlayer(noisyInteractRange));
        listSoundProfiles.add(new SoundProfileEntry("tripwire", noisyInteractBuff).setMaxDistToSpawnFromPlayer(noisyInteractRange));
        listSoundProfiles.add(new SoundProfileEntry("block.barrel", noisyInteractBuff).setMaxDistToSpawnFromPlayer(noisyInteractRange));
        if (ZAConfigFeatures.noisyZombies) {
            listSoundProfiles.add(new SoundProfileEntry(SoundEvents.f_12598_, 0.8, ZAConfig.noisyZombiesReinforceOddsTo1).setMaxDistToSpawnFromPlayer(18.0));
        }
        if (ZAConfigFeatures.noisyPistons) {
            listSoundProfiles.add(new SoundProfileEntry(SoundEvents.f_12312_, 2.0, 20).setMaxDistToSpawnFromPlayer(24.0));
        }
        listSoundProfiles.add(new SoundProfileEntry(SoundEvents.f_11913_, 3.0).setMaxDistToSpawnFromPlayer(24.0));
    }

    public static void addSoundIntegerEntry(SoundProfileEntry entry) {
        for (int soundID : entry.getListSoundEventTypes()) {
            lookupSoundIntToProfile.put(soundID, entry);
        }
        listSoundProfiles.add(entry);
    }

    public static SoundProfileEntry getSoundIDEntry(int soundType) {
        return lookupSoundIntToProfile.get(soundType);
    }

    public static SoundProfileEntry getSoundIDEntry(String sound) {
        if (lookupSoundNameToProfileCache.containsKey(sound)) {
            return lookupSoundNameToProfileCache.get(sound);
        }
        for (SoundProfileEntry entry : listSoundProfiles) {
            if (entry.getSoundName().equals(sound)) {
                lookupSoundNameToProfileCache.put(sound, entry);
                return entry;
            }
            if (!entry.isPartialMatchOnly() || !sound.contains(entry.getSoundName())) continue;
            lookupSoundNameToProfileCache.put(sound, entry);
            return entry;
        }
        return null;
    }

    public static void tickPlayer(Player player) {
        if (ZAConfigFeatures.wanderingHordes) {
            long lastWaypoint;
            long l = lastWaypoint = lookupLastWaypointTime.containsKey(CoroUtilEntity.getName((Entity)player)) ? lookupLastWaypointTime.get(CoroUtilEntity.getName((Entity)player)) : 0L;
            if (lastWaypoint < System.currentTimeMillis()) {
                lastWaypoint = System.currentTimeMillis() + (long)ZAConfigFeatures.frequencyOfWanderingHordesPerPlayer * 1000L;
                lookupLastWaypointTime.put(CoroUtilEntity.getName((Entity)player), lastWaypoint);
                ZAUtil.spawnWaypoint((Entity)player);
            }
        }
        if (ZAConfigFeatures.awareness_Scent && !player.m_7500_()) {
            EntityScent scent;
            int lastHealth = lastHealths.containsKey(CoroUtilEntity.getName((Entity)player)) ? lastHealths.get(CoroUtilEntity.getName((Entity)player)) : 0;
            Long lastBleedTime = lastBleedTimes.containsKey(CoroUtilEntity.getName((Entity)player)) ? lastBleedTimes.get(CoroUtilEntity.getName((Entity)player)) : 0L;
            Vector3d pos = new Vector3d(player.m_20185_(), player.m_20186_(), player.m_20189_());
            if ((int)player.m_21223_() != lastHealth) {
                if (player.m_21223_() < (float)lastHealth) {
                    scent = ZAUtil.spawnOrBuffSenseAtPos(player.f_19853_, pos, EnumSenseType.SCENT_BLOOD, ZAConfig.scentStrength);
                    ZombieAwareness.dbg("spawned or buffed scent sense from damage: " + scent.getStrengthPeak());
                }
                lastHealth = (int)player.m_21223_();
            }
            lastHealths.put(CoroUtilEntity.getName((Entity)player), lastHealth);
            if (player.m_21223_() / player.m_21233_() < 0.6f && lastBleedTime < System.currentTimeMillis()) {
                lastBleedTime = System.currentTimeMillis() + 30000L;
                lastBleedTimes.put(CoroUtilEntity.getName((Entity)player), lastBleedTime);
                scent = ZAUtil.spawnOrBuffSenseAtPos(player.f_19853_, pos, EnumSenseType.SCENT_BLOOD, ZAConfig.scentStrength);
                ZombieAwareness.dbg("spawned or buffed scent sense from bleeding: " + scent.getStrengthPeak());
            }
        }
    }

    public static void processMobSpawn(LivingSpawnEvent.SpecialSpawn event) {
        LivingEntity ent;
        if (ZAConfig.zombieRandSpeedBoost > 0.0 && (ent = event.getEntityLiving()) instanceof Zombie && !ZAUtil.isMobSpeedBosted((Mob)ent)) {
            ZAUtil.giveRandomSpeedBoost((Mob)ent);
        }
    }

    public static boolean isMobSpeedBosted(Mob ent) {
        return ent.getPersistentData().m_128471_(SPEED_BOOST_TAG);
    }

    public static void giveRandomSpeedBoost(Mob ent) {
        if (ZAConfig.zombieRandSpeedBoost > 0.0) {
            double randBoost = ent.f_19853_.f_46441_.nextDouble() * ZAConfig.zombieRandSpeedBoost;
            if (ent.m_6162_()) {
                randBoost *= -1.0;
            }
            AttributeModifier speedBoostModifier = new AttributeModifier(CoroUtilAttributes.SPEED_BOOST_UUID, "ZA speed boost", randBoost, AttributeModifier.Operation.MULTIPLY_BASE);
            if (!ent.m_21051_(Attributes.f_22279_).m_22109_(speedBoostModifier)) {
                ZombieAwareness.dbg("boosting zombie speed to " + randBoost);
                ent.m_21051_(Attributes.f_22279_).m_22125_(speedBoostModifier);
                ent.getPersistentData().m_128379_(SPEED_BOOST_TAG, true);
            }
        }
    }

    public static void huntTarget(Mob ent, LivingEntity targ, int pri) {
        CoroUtilPath.tryMoveToEntityLivingLongDist((Mob)ent, (Entity)targ, (double)1.0);
        if (ent instanceof Mob) {
            ent.m_6710_(targ);
        }
    }

    public static void huntTarget(Mob ent, LivingEntity targ) {
        ZAUtil.huntTarget(ent, targ, 0);
    }

    public static boolean isEnemy(Entity ent, Entity targ) {
        return ZAUtil.isEnemy(ent, targ, false);
    }

    public static boolean isEnemy(Entity ent, Entity targ, boolean omniTarget) {
        if (targ instanceof LivingEntity) {
            if (targ instanceof Player && !((Player)targ).m_7500_() && ((Player)targ).m_21124_(MobEffects.f_19609_) == null) {
                if (!omniTarget) {
                    return true;
                }
                if (ZAConfigPlayerLists.whiteListUsedOmniscient) {
                    if (ZAConfigPlayerLists.whitelistOmniscientTargettedPlayers.contains(CoroUtilEntity.getName((Entity)((Player)targ)))) {
                        if (ZAConfig.debugConsoleOmniscient) {
                            ZombieAwareness.dbg(CoroUtilEntity.getName((Entity)((Player)targ)) + " targetting omnisciently by " + ent);
                        }
                        return true;
                    }
                } else {
                    return true;
                }
            }
            return false;
        }
        return false;
    }

    public static boolean sanityCheck(Entity ent, Entity entity1) {
        return true;
    }

    public static void markPerformedPathing(Mob ent) {
        ent.m_21310_(0);
        ent.getPersistentData().m_128356_(ZA_LAST_ACTION, ent.f_19853_.m_46467_());
    }

    public static void tickAI(Mob ent) {
        Player player;
        Node pathTo;
        long lastActionTime;
        if (ZAConfig.debugConsoleSuperDetailed) {
            ZombieAwareness.dbg("ZA DBG: Ticking: " + ent);
        }
        if ((lastActionTime = ent.getPersistentData().m_128454_(ZA_LAST_ACTION)) > 0L && ent.f_19853_.m_46467_() - (long)ZAConfig.tickCooldownBetweenPathfinds < lastActionTime) {
            return;
        }
        if ((ent.f_19853_.m_46467_() + (long)ent.m_142049_()) % 40L == 0L) {
            if (ZAConfig.omniscient && ent.m_5448_() == null) {
                ZAUtil.ai_FindTarget(ent, true);
            } else {
                ZAUtil.ai_FindTarget(ent, false);
            }
        }
        EntityScent senseTracked = null;
        if (ent.m_5448_() == null && ent.m_21573_().m_26571_()) {
            if (!ZAConfig.awareness_Light_OnlyZombies || ent instanceof Zombie) {
                if (!(ZAConfigFeatures.awareness_Light && ZAUtil.ai_FindLightSource(ent) || ent.f_19853_.f_46441_.nextInt(3) != 0)) {
                    senseTracked = ZAUtil.ai_FindSense(ent, true);
                }
            } else {
                senseTracked = ZAUtil.ai_FindSense(ent);
            }
        }
        if (senseTracked != null && ent.m_21573_().m_26570_() != null && (pathTo = ent.m_21573_().m_26570_().m_77395_()) != null && (player = ZAUtil.getClosestPlayer(ent.f_19853_, pathTo.f_77271_, pathTo.f_77272_, pathTo.f_77273_, 6.0)) != null) {
            ZAUtil.tryPlayInvestigateSound(ent, new Vector3d((double)pathTo.f_77271_, (double)pathTo.f_77272_, (double)pathTo.f_77273_));
        }
        ZAUtil.tickCustomMob(ent);
    }

    public static void tickCustomMob(Mob ent) {
        if (ZAConfigFeatures.wanderingHordes && ent instanceof Spider && ent.m_20197_().size() > 0 && ent.m_20197_().get(0) instanceof Skeleton && ent.f_19853_.f_46441_.nextInt(100) == 0) {
            ZAUtil.spawnWaypoint((Entity)ent);
        }
    }

    public static boolean ai_FindLightSource(Mob ent) {
        if (ent.f_19853_.m_46461_()) {
            return false;
        }
        boolean forceOn = false;
        if (forceOn || ent.f_19853_.f_46441_.nextInt(3) == 0) {
            float lightValueAtEntity = ent.f_19853_.m_46863_(ent.m_142538_());
            Random rand = new Random();
            for (int i = 0; i < 4; ++i) {
                boolean canSeePos;
                int rZ;
                int rY;
                Player entP = ZAUtil.getClosestPlayerToEntity(ent.f_19853_, (Entity)ent, 999.0);
                if (entP == null) continue;
                int size = 32 * (i + 1);
                int rX = (int)Math.floor(entP.m_20185_() + (double)(rand.nextInt(size) - size / 2));
                BlockPos pos = new BlockPos(rX, rY = (int)Math.floor(entP.m_20186_() + (double)(rand.nextInt(size / 2) - size / 4)), rZ = (int)Math.floor(entP.m_20189_() + (double)(rand.nextInt(size) - size / 2)));
                if (!ent.f_19853_.m_46749_(pos)) continue;
                float lightValue = entP.f_19853_.m_46863_(pos);
                if (!forceOn && !(lightValue > 0.2f) || !forceOn && ent.f_19853_.f_46441_.nextInt(5) != 0 || !(ent.m_20270_((Entity)entP) > 16.0f) || !(canSeePos = CoroUtilEntity.canSee((Entity)ent, (BlockPos)new BlockPos(rX, rY, rZ)))) continue;
                ZombieAwareness.dbg("try path to light source - " + rX + ", " + rY + ", " + rZ);
                if (ent.m_21573_().m_26519_((double)rX, (double)rY, (double)rZ, 1.0)) {
                    ZombieAwareness.dbg("node count: " + ent.m_21573_().m_26570_().m_77398_());
                    ZombieAwareness.dbg("pathing to lightsource at " + rX + ", " + rY + ", " + rZ + " - " + ent);
                    ZAUtil.markPerformedPathing(ent);
                }
                return true;
            }
        }
        return false;
    }

    public static EntityScent ai_FindSense(Mob ent) {
        return ZAUtil.ai_FindSense(ent, true);
    }

    public static EntityScent ai_FindSense(Mob ent, boolean includeWaypoints) {
        EntityScent var3 = ZAUtil.getSenseNearEntity((Entity)ent);
        if (var3 != null && (includeWaypoints || var3.f_19847_ != 2) && CoroUtilPath.tryMoveToEntityLivingLongDist((Mob)ent, (Entity)var3, (double)1.0)) {
            ZAUtil.markPerformedPathing(ent);
            ZombieAwareness.dbg("ai_FindSense call, type: " + var3.f_19847_ + " - " + ent.m_7755_() + " -> " + var3.m_20182_());
            return var3;
        }
        return null;
    }

    public static boolean ai_FindTarget(Mob ent, boolean omniscient) {
        long huntRange = ZAConfig.sightRange;
        if (omniscient) {
            huntRange = 512L;
        }
        if (ent.m_5448_() == null || ent.f_19853_.f_46441_.nextInt(100) == 0) {
            boolean found = false;
            Entity clEnt = null;
            float closest = 9999.0f;
            List list = ent.f_19853_.m_45933_((Entity)ent, ent.m_142469_().m_82377_((double)huntRange, (double)(huntRange / 2L), (double)huntRange));
            for (int j = 0; j < list.size(); ++j) {
                float dist;
                Entity entity1 = (Entity)list.get(j);
                if (ent.getClass().getSimpleName().equals("EntityZombiePlayer") || !ZAUtil.isEnemy((Entity)ent, entity1, omniscient) || !omniscient && !ZAConfig.seeThroughWalls && !((LivingEntity)entity1).m_142582_((Entity)ent) || !ZAUtil.sanityCheck((Entity)ent, entity1) || !((dist = (float)ent.m_20280_(entity1)) < closest)) continue;
                closest = dist;
                clEnt = entity1;
            }
            if (clEnt != null) {
                ZAUtil.huntTarget(ent, (LivingEntity)clEnt);
                ZAUtil.markPerformedPathing(ent);
                ZombieAwareness.dbg(" hunting target " + ent + " " + clEnt);
                return true;
            }
        }
        return false;
    }

    public static EntityScent getSenseNearEntity(Entity entSource) {
        List listEnts = entSource.f_19853_.m_45933_(entSource, entSource.m_142469_().m_82377_((double)ZAConfig.maxPFRangeSense, (double)ZAConfig.maxPFRangeSense, (double)ZAConfig.maxPFRangeSense));
        EntityScent entBest = null;
        for (int i = 0; i < listEnts.size(); ++i) {
            Entity entCheck = (Entity)listEnts.get(i);
            if (!(entCheck instanceof EntityScent)) continue;
            double dist = entSource.m_20270_(entCheck);
            float rangeToClose = 5.0f;
            int randChance = 20;
            if (((EntityScent)entCheck).f_19847_ == 2) {
                rangeToClose = 10.0f;
                randChance = 2;
            }
            if (!(dist < (double)((EntityScent)entCheck).getRange()) || !(dist > (double)rangeToClose) || entSource.f_19853_.f_46441_.nextInt(randChance) != 0) continue;
            entBest = (EntityScent)entCheck;
            return entBest;
        }
        return entBest;
    }

    public static void hookPlayEvent(int type, Level world, double pX, double pY, double pZ, int data) {
        Player closestPlayer;
        ZAUtil.addSoundHooks();
        if (world.m_5776_() || !ZAUtil.canSpawnTraceQuickCheck(world)) {
            return;
        }
        SoundProfileEntry entry = ZAUtil.getSoundIDEntry(type);
        if (entry != null && (closestPlayer = ZAUtil.getClosestPlayer(world, pX, pY, pZ, entry.getMaxDistToSpawnFromPlayer())) != null) {
            Vector3d pos = new Vector3d(pX, pY, pZ);
            if (!ZAUtil.canSpawnTrace(world, pX, pY, pZ)) {
                return;
            }
            ZAUtil.handleSoundProfileEvent(world, entry, pos, closestPlayer);
        }
    }

    public static void hookSoundEvent(SoundEvent sound, Level world, double x, double y, double z, float volume, float pitch) {
        Player closestPlayer;
        ZAUtil.addSoundHooks();
        if (world.m_5776_() || sound == null || !ZAUtil.canSpawnTraceQuickCheck(world)) {
            return;
        }
        String soundName = SoundProfileEntry.getSoundEventName(sound);
        SoundProfileEntry entry = ZAUtil.getSoundIDEntry(soundName);
        if (entry != null && (closestPlayer = ZAUtil.getClosestPlayer(world, x, y, z, entry.getMaxDistToSpawnFromPlayer())) != null) {
            Vector3d pos = new Vector3d(x, y, z);
            if (!ZAUtil.canSpawnTrace(world, x, y, z) && !ZAUtil.canSpawnTrace(world, x, y += 1.0, z)) {
                return;
            }
            ZAUtil.handleSoundProfileEvent(world, entry, pos, closestPlayer);
        }
    }

    public static void handleSoundProfileEvent(Level world, SoundProfileEntry entry, Vector3d pos, Player closestPlayer) {
        double distToPlayer = Math.sqrt(closestPlayer.m_20275_(pos.f_86214_, pos.f_86215_, pos.f_86216_));
        double strength = ZAConfig.soundStrength;
        if (distToPlayer <= entry.getMaxDistToSpawnFromPlayer() && (entry.getOddsTo1ToUse() <= 0 || rand.nextInt(entry.getOddsTo1ToUse()) == 0)) {
            EntityScent scent = ZAUtil.spawnOrBuffSenseAtPos(world, pos, EnumSenseType.SOUND, (int)(strength *= entry.getMultiplier()));
            ZombieAwareness.dbg("spawned or buffed sound sense from soundEvent, sound: " + entry.getSoundName() + ", str: " + scent.getStrengthPeak());
        }
    }

    public static void hookBlockEvent(PlayerEvent event, int chance) {
        if (event.getEntity() != null && !ZAUtil.canSpawnTraceQuickCheck(event.getEntity().f_19853_)) {
            return;
        }
        if (event.getPlayer() == null || ZAConfigPlayerLists.whiteListUsedSenses && !ZAConfigPlayerLists.whitelistSenses.contains(CoroUtilEntity.getName((Entity)event.getPlayer()))) {
            return;
        }
        if (!event.getEntity().f_19853_.m_5776_() && event.getEntity().f_19853_.f_46441_.nextInt(chance) == 0) {
            int strength = ZAConfig.soundStrength;
            Vector3d pos = new Vector3d(event.getPlayer().m_20185_(), event.getPlayer().m_20186_(), event.getPlayer().m_20189_());
            EntityScent scent = ZAUtil.spawnOrBuffSenseAtPos(event.getEntity().f_19853_, pos, EnumSenseType.SOUND, strength);
            ZombieAwareness.dbg("spawned or buffed sound sense from PlayerEvent: " + scent.getStrengthPeak());
        }
    }

    public static void handleBlockBasedEvent(Player player, Level world, BlockPos pos, int chance) {
        if (player == null && ZAConfig.blockBreakEvent_PlayersOnly) {
            return;
        }
        if (!ZAUtil.canSpawnTraceQuickCheck(world)) {
            return;
        }
        if (player != null && ZAConfigPlayerLists.whiteListUsedSenses && ZAConfigPlayerLists.whitelistSenses.contains(CoroUtilEntity.getName((Entity)player))) {
            return;
        }
        if (!world.m_5776_() && world.f_46441_.nextInt(chance) == 0) {
            int strength = ZAConfig.soundStrength;
            Vector3d posVec = new Vector3d((double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_());
            EntityScent scent = ZAUtil.spawnOrBuffSenseAtPos(world, posVec, EnumSenseType.SOUND, strength);
            ZombieAwareness.dbg("spawned or buffed sound sense from BlockBasedEvent: " + scent.getStrengthPeak());
        }
    }

    public static void hookSetAttackTarget(LivingSetAttackTargetEvent event) {
        if (event.getEntityLiving() instanceof Mob) {
            if (event.getTarget() instanceof Player) {
                ZAUtil.tryPlayTargetSound((Mob)event.getEntityLiving(), event.getTarget(), new Vector3d(event.getEntityLiving().m_20185_(), event.getEntityLiving().m_20186_(), event.getEntityLiving().m_20189_()));
            } else if (event.getTarget() == null) {
                // empty if block
            }
        }
    }

    public static void spawnWaypoint(Entity entSource) {
        int range = 128;
        double tryX = (int)entSource.m_20185_() - range / 2 + rand.nextInt(range);
        double tryZ = (int)entSource.m_20189_() - range / 2 + rand.nextInt(range);
        double tryY = entSource.f_19853_.m_6924_(Heightmap.Types.MOTION_BLOCKING, (int)Math.floor(tryX), (int)Math.floor(tryZ));
        if (!ZAUtil.canSpawnTrace(entSource.f_19853_, tryX, tryY, tryZ)) {
            return;
        }
        double height = entSource.m_20186_();
        EntityScent var1 = ZAUtil.getSenseNodeAtPos(entSource.f_19853_, new Vector3d(tryX, tryY, tryZ), EnumSenseType.WAYPOINT);
        boolean newNode = false;
        if (var1 == null) {
            var1 = new EntityScent(EntityRegistry.SCENT, entSource.f_19853_);
            newNode = true;
        }
        var1.setStrengthPeak(150);
        if (newNode) {
            var1.m_6034_(tryX, tryY, tryZ);
            var1.f_19847_ = 2;
            entSource.f_19853_.m_7967_((Entity)var1);
        }
        if (debug) {
            System.out.println("WP: " + entSource + " - range: " + var1.getRange());
        }
    }

    public static boolean canSpawnTraceQuickCheck(Level world) {
        if (!ZAConfigFeatures.awareness_Sound) {
            return false;
        }
        return !ZAConfigFeatures.awareness_Sound_OverworldOnly || world.m_46472_() == Level.f_46428_;
    }

    public static boolean canSpawnTrace(Level world, double x, double y, double z) {
        BlockPos pos = new BlockPos(x, y, z);
        if (!world.m_46749_(pos)) {
            return false;
        }
        BlockState state = world.m_8055_(pos);
        return state.m_60767_() != Material.f_76310_ || state.m_60734_() instanceof ButtonBlock || state.m_60734_() instanceof LeverBlock;
    }

    public static Player getClosestPlayerToEntity(Level world, Entity par1Entity, double par2) {
        return ZAUtil.getClosestPlayer(world, par1Entity.m_20185_(), par1Entity.m_20186_(), par1Entity.m_20189_(), par2);
    }

    public static Player getClosestPlayer(Level world, double x, double y, double z, double maxDistance) {
        double closestDist = -1.0;
        Player closestPlayer = null;
        for (int i = 0; i < world.m_6907_().size(); ++i) {
            Player entityplayer1 = (Player)world.m_6907_().get(i);
            if (ZAConfigPlayerLists.whiteListUsedSenses && !ZAConfigPlayerLists.whitelistSenses.contains(CoroUtilEntity.getName((Entity)entityplayer1))) continue;
            double d5 = entityplayer1.m_20275_(x, y, z);
            if (!(maxDistance < 0.0) && !(d5 < maxDistance * maxDistance) || closestDist != -1.0 && !(d5 < closestDist)) continue;
            closestDist = d5;
            closestPlayer = entityplayer1;
        }
        return closestPlayer;
    }

    public static EntityScent getSenseNodeAtPos(Level parWorld, Vector3d parPos, EnumSenseType type) {
        if (ZAConfig.extraScentCutoffRange == -1.0) {
            return null;
        }
        AABB aabb = new AABB(parPos.f_86214_, parPos.f_86215_, parPos.f_86216_, parPos.f_86214_ + 1.0, parPos.f_86215_ + 1.0, parPos.f_86216_ + 1.0);
        List list = parWorld.m_45976_(EntityScent.class, aabb = aabb.m_82377_(ZAConfig.extraScentCutoffRange, ZAConfig.extraScentCutoffRange, ZAConfig.extraScentCutoffRange));
        if (list.size() > 0) {
            for (int j = 0; j < list.size(); ++j) {
                EntityScent node = (EntityScent)((Object)list.get(j));
                if (node.f_19847_ != type.ordinal()) continue;
                return node;
            }
        }
        return null;
    }

    public static EntityScent spawnOrBuffSenseAtPos(Level world, Vector3d parPos, EnumSenseType type, int strength) {
        return ZAUtil.spawnOrBuffSenseAtPos(world, parPos, type, strength, true);
    }

    public static EntityScent spawnOrBuffSenseAtPos(Level world, Vector3d parPos, EnumSenseType type, int strength, boolean frequentSoundMultiply) {
        EntityScent sense = ZAUtil.getSenseNodeAtPos(world, parPos, type);
        if (sense == null) {
            sense = new EntityScent(EntityRegistry.SCENT, world);
            sense.f_19847_ = type.ordinal();
            sense.m_6034_(parPos.f_86214_, parPos.f_86215_, parPos.f_86216_);
            sense.setStrengthPeak(strength);
            world.m_7967_((Entity)sense);
        } else if (frequentSoundMultiply) {
            float str = sense.getStrengthPeak();
            if (str < (float)strength) {
                str = strength;
            }
            if (sense.lastBuffTime + (long)ZAConfig.frequentSoundThreshold > System.currentTimeMillis()) {
                sense.lastMultiply += 0.1f;
                str *= sense.lastMultiply;
            } else {
                sense.lastMultiply = 1.0f;
            }
            sense.lastBuffTime = System.currentTimeMillis();
            sense.setStrengthPeak((int)str);
        }
        return sense;
    }

    public static void tryPlayTargetSound(Mob entAlerted, LivingEntity entTargetted, Vector3d pos) {
        if (!ZAConfigFeatures.soundAlerts) {
            return;
        }
        if (!ZombieAwareness.canProcessEntity((Entity)entAlerted)) {
            return;
        }
        double distMaxCancel = 75.0;
        if ((!lookupLastAlertTime.containsKey(entAlerted) || lookupLastAlertTime.get(entAlerted) + alertDelay < entAlerted.f_19853_.m_46467_()) && (double)entAlerted.m_20270_((Entity)entTargetted) < distMaxCancel && entAlerted.f_19853_.m_46472_() == entTargetted.f_19853_.m_46472_() && entAlerted.f_19853_.m_46749_(entAlerted.m_142538_()) && entTargetted.f_19853_.m_46749_(entTargetted.m_142538_())) {
            if (entAlerted.m_142582_((Entity)entTargetted)) {
                entAlerted.f_19853_.m_6263_(null, entTargetted.m_20185_(), entTargetted.m_20186_(), entTargetted.m_20189_(), ZAConfigFeatures.soundUseAlternateAlertNoise ? SoundRegistry.get("alert") : SoundRegistry.get("target"), SoundSource.HOSTILE, (float)ZAConfigFeatures.soundVolumeAlertTarget, ZAConfigFeatures.soundUseAlternateAlertNoise ? 1.0f : 0.8f + entAlerted.f_19853_.f_46441_.nextFloat() * 0.2f);
                lookupLastAlertTime.put((Entity)entAlerted, entAlerted.f_19853_.m_46467_());
            } else {
                ZAUtil.tryPlayInvestigateSound(entAlerted, pos);
            }
        }
    }

    public static void tryPlayInvestigateSound(Mob entAlerted, Vector3d pos) {
        if (!ZAConfigFeatures.soundInvestigates) {
            return;
        }
        if (!ZombieAwareness.canProcessEntity((Entity)entAlerted)) {
            return;
        }
        if (!lookupLastInvestigateTime.containsKey(entAlerted) || lookupLastInvestigateTime.get(entAlerted) + investigateDelay < entAlerted.f_19853_.m_46467_()) {
            entAlerted.f_19853_.m_6263_(null, pos.f_86214_, pos.f_86215_, pos.f_86216_, SoundRegistry.get("investigate"), SoundSource.HOSTILE, (float)ZAConfigFeatures.soundVolumeInvestigate, 0.7f + entAlerted.f_19853_.f_46441_.nextFloat() * 0.3f);
            lookupLastInvestigateTime.put((Entity)entAlerted, entAlerted.f_19853_.m_46467_());
            ZombieAwareness.dbg("!!! investigate play for ent: " + entAlerted.m_142049_() + ", lookupSize: " + lookupLastInvestigateTime.size());
        }
    }

    public static boolean isZombieAwarenessActive(Level world) {
        if (world == null) {
            return false;
        }
        if (ZAConfig.daysBeforeFeaturesActivate <= 0.0) {
            return true;
        }
        return (double)world.m_46467_() / (double)CoroUtilWorldTime.getDayLength() >= ZAConfig.daysBeforeFeaturesActivate;
    }

    static {
        ZAUtil.addSoundHooks();
    }
}

