/*
 * Decompiled with CFR 0.152.
 */
package mekanism.tools.common.item;

import java.util.List;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mekanism.tools.client.render.ToolsRenderPropertiesProvider;
import mekanism.tools.common.IHasRepairType;
import mekanism.tools.common.material.BaseMekanismMaterial;
import mekanism.tools.common.util.ToolsUtils;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ShieldItem;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.Level;
import net.minecraftforge.client.IItemRenderProperties;

public class ItemMekanismShield
extends ShieldItem
implements IHasRepairType {
    private final BaseMekanismMaterial material;

    public ItemMekanismShield(BaseMekanismMaterial material, Item.Properties properties) {
        super(properties.m_41503_(material.getShieldDurability()));
        this.material = material;
    }

    public void initializeClient(@Nonnull Consumer<IItemRenderProperties> consumer) {
        consumer.accept(ToolsRenderPropertiesProvider.shield());
    }

    public void m_7373_(@Nonnull ItemStack stack, @Nullable Level world, @Nonnull List<Component> tooltip, @Nonnull TooltipFlag flag) {
        super.m_7373_(stack, world, tooltip, flag);
        ToolsUtils.addDurability(tooltip, stack);
    }

    @Override
    @Nonnull
    public Ingredient getRepairMaterial() {
        return this.material.m_6230_();
    }

    public int getMaxDamage(ItemStack stack) {
        return this.material.getShieldDurability();
    }

    public boolean m_41465_() {
        return this.material.getShieldDurability() > 0;
    }

    public boolean m_6832_(@Nonnull ItemStack toRepair, @Nonnull ItemStack repair) {
        return this.getRepairMaterial().test(repair);
    }

    public int m_6473_() {
        return this.material.m_6646_();
    }
}

