/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.data;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.CacheStats;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.Sets;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import journeymap.client.JourneymapClient;
import journeymap.client.api.display.ImageOverlay;
import journeymap.client.api.display.MarkerOverlay;
import journeymap.client.api.display.PolygonOverlay;
import journeymap.client.data.AllData;
import journeymap.client.data.AnimalsData;
import journeymap.client.data.MessagesData;
import journeymap.client.data.MobsData;
import journeymap.client.data.PlayerData;
import journeymap.client.data.PlayersData;
import journeymap.client.data.VillagersData;
import journeymap.client.data.WaypointsData;
import journeymap.client.data.WorldData;
import journeymap.client.io.nbt.JMChunkLoader;
import journeymap.client.model.BlockMD;
import journeymap.client.model.ChunkMD;
import journeymap.client.model.EntityDTO;
import journeymap.client.model.MapType;
import journeymap.client.model.RegionCoord;
import journeymap.client.model.RegionImageCache;
import journeymap.client.model.RegionImageSet;
import journeymap.client.render.draw.DrawEntityStep;
import journeymap.client.render.draw.DrawImageStep;
import journeymap.client.render.draw.DrawMarkerStep;
import journeymap.client.render.draw.DrawPolygonStep;
import journeymap.client.render.draw.DrawWayPointStep;
import journeymap.client.waypoint.Waypoint;
import journeymap.client.waypoint.WaypointStore;
import journeymap.common.Journeymap;
import journeymap.common.log.LogFormatter;
import net.minecraft.class_1309;
import net.minecraft.class_1923;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_310;
import net.minecraft.class_5321;

public enum DataCache {
    INSTANCE;

    final LoadingCache<Long, Map> all;
    final LoadingCache<Class, Map<String, EntityDTO>> animals;
    final LoadingCache<Class, Map<String, EntityDTO>> mobs;
    final LoadingCache<Class, Map<String, EntityDTO>> players;
    final LoadingCache<Class, Map<String, EntityDTO>> villagers;
    final LoadingCache<Class, Collection<Waypoint>> waypoints;
    final LoadingCache<Class, EntityDTO> player;
    final LoadingCache<Class, WorldData> world;
    final LoadingCache<RegionImageSet.Key, RegionImageSet> regionImageSets;
    final LoadingCache<Class, Map<String, Object>> messages;
    final LoadingCache<class_1309, DrawEntityStep> entityDrawSteps;
    final LoadingCache<Waypoint, DrawWayPointStep> waypointDrawSteps;
    final LoadingCache<class_1309, EntityDTO> entityDTOs;
    final Cache<String, RegionCoord> regionCoords;
    final Cache<String, MapType> mapTypes;
    final LoadingCache<class_2680, BlockMD> blockMetadata;
    final Cache<class_1923, ChunkMD> chunkMetadata;
    final LoadingCache<PolygonOverlay, List<class_2338>> polygonTriangulation;
    final LoadingCache<PolygonOverlay, DrawPolygonStep> polygonDrawSteps;
    final LoadingCache<MarkerOverlay, DrawMarkerStep> markerDrawSteps;
    final LoadingCache<ImageOverlay, DrawImageStep> imageDrawSteps;
    private final Long2ObjectMap<class_1923> chunkCoordCache = new Long2ObjectOpenHashMap();
    final HashMap<Cache, String> managedCaches = new HashMap();
    private final int chunkCacheExpireSeconds = 30;
    private final int defaultConcurrencyLevel = 2;

    private DataCache() {
        AllData allData = new AllData();
        this.all = this.getCacheBuilder().maximumSize(1L).expireAfterWrite(allData.getTTL(), TimeUnit.MILLISECONDS).build((CacheLoader)allData);
        this.managedCaches.put((Cache)this.all, "AllData (web)");
        AnimalsData animalsData = new AnimalsData();
        this.animals = this.getCacheBuilder().expireAfterWrite(animalsData.getTTL(), TimeUnit.MILLISECONDS).build((CacheLoader)animalsData);
        this.managedCaches.put((Cache)this.animals, "Animals");
        MobsData mobsData = new MobsData();
        this.mobs = this.getCacheBuilder().expireAfterWrite(mobsData.getTTL(), TimeUnit.MILLISECONDS).build((CacheLoader)mobsData);
        this.managedCaches.put((Cache)this.mobs, "Mobs");
        PlayerData playerData = new PlayerData();
        this.player = this.getCacheBuilder().expireAfterWrite(playerData.getTTL(), TimeUnit.MILLISECONDS).build((CacheLoader)playerData);
        this.managedCaches.put((Cache)this.player, "Player");
        PlayersData playersData = new PlayersData();
        this.players = this.getCacheBuilder().expireAfterWrite(playersData.getTTL(), TimeUnit.MILLISECONDS).build((CacheLoader)playersData);
        this.managedCaches.put((Cache)this.players, "Players");
        VillagersData villagersData = new VillagersData();
        this.villagers = this.getCacheBuilder().expireAfterWrite(villagersData.getTTL(), TimeUnit.MILLISECONDS).build((CacheLoader)villagersData);
        this.managedCaches.put((Cache)this.villagers, "Villagers");
        WaypointsData waypointsData = new WaypointsData();
        this.waypoints = this.getCacheBuilder().expireAfterWrite(waypointsData.getTTL(), TimeUnit.MILLISECONDS).build((CacheLoader)waypointsData);
        this.managedCaches.put((Cache)this.waypoints, "Waypoints");
        WorldData worldData = new WorldData();
        this.world = this.getCacheBuilder().expireAfterWrite(worldData.getTTL(), TimeUnit.MILLISECONDS).build((CacheLoader)worldData);
        this.managedCaches.put((Cache)this.world, "World");
        MessagesData messagesData = new MessagesData();
        this.messages = this.getCacheBuilder().expireAfterWrite(messagesData.getTTL(), TimeUnit.MILLISECONDS).build((CacheLoader)messagesData);
        this.managedCaches.put((Cache)this.messages, "Messages (web)");
        this.entityDrawSteps = this.getCacheBuilder().weakKeys().build((CacheLoader)new DrawEntityStep.SimpleCacheLoader());
        this.managedCaches.put((Cache)this.entityDrawSteps, "DrawEntityStep");
        this.waypointDrawSteps = this.getCacheBuilder().weakKeys().build((CacheLoader)new DrawWayPointStep.SimpleCacheLoader());
        this.managedCaches.put((Cache)this.waypointDrawSteps, "DrawWaypointStep");
        this.polygonDrawSteps = this.getCacheBuilder().weakKeys().build((CacheLoader)new DrawPolygonStep.SimpleCacheLoader());
        this.managedCaches.put((Cache)this.polygonDrawSteps, "PolygonDrawSteps");
        this.polygonTriangulation = this.getCacheBuilder().weakKeys().build((CacheLoader)new DrawPolygonStep.TriangulationCacheLoader());
        this.managedCaches.put((Cache)this.polygonTriangulation, "Triangulatio");
        this.imageDrawSteps = this.getCacheBuilder().weakKeys().build((CacheLoader)new DrawImageStep.SimpleCacheLoader());
        this.managedCaches.put((Cache)this.imageDrawSteps, "ImageDrawSteps");
        this.markerDrawSteps = this.getCacheBuilder().weakKeys().build((CacheLoader)new DrawMarkerStep.SimpleCacheLoader());
        this.managedCaches.put((Cache)this.markerDrawSteps, "MarkerDrawSteps");
        this.entityDTOs = this.getCacheBuilder().weakKeys().build((CacheLoader)new EntityDTO.SimpleCacheLoader());
        this.managedCaches.put((Cache)this.entityDTOs, "EntityDTO");
        this.regionImageSets = RegionImageCache.INSTANCE.initRegionImageSetsCache(this.getCacheBuilder());
        this.managedCaches.put((Cache)this.regionImageSets, "RegionImageSet");
        this.blockMetadata = this.getCacheBuilder().weakKeys().build((CacheLoader)new BlockMD.CacheLoader());
        this.managedCaches.put((Cache)this.blockMetadata, "BlockMD");
        this.chunkMetadata = this.getCacheBuilder().expireAfterAccess(30L, TimeUnit.SECONDS).build();
        this.managedCaches.put(this.chunkMetadata, "ChunkMD");
        this.regionCoords = this.getCacheBuilder().expireAfterAccess(30L, TimeUnit.SECONDS).build();
        this.managedCaches.put(this.regionCoords, "RegionCoord");
        this.mapTypes = this.getCacheBuilder().build();
        this.managedCaches.put(this.mapTypes, "MapType");
    }

    public static EntityDTO getPlayer() {
        return INSTANCE.getPlayer(false);
    }

    private CacheBuilder<Object, Object> getCacheBuilder() {
        CacheBuilder builder = CacheBuilder.newBuilder();
        builder.concurrencyLevel(2);
        if (JourneymapClient.getInstance().getCoreProperties().recordCacheStats.get().booleanValue()) {
            builder.recordStats();
        }
        return builder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map getAll(long since) {
        LoadingCache<Long, Map> loadingCache = this.all;
        synchronized (loadingCache) {
            try {
                return (Map)this.all.get((Object)since);
            }
            catch (ExecutionException e) {
                Journeymap.getLogger().error("ExecutionException in getAll: " + LogFormatter.toString(e));
                return Collections.EMPTY_MAP;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, EntityDTO> getAnimals(boolean forceRefresh) {
        LoadingCache<Class, Map<String, EntityDTO>> loadingCache = this.animals;
        synchronized (loadingCache) {
            try {
                if (forceRefresh) {
                    this.animals.invalidateAll();
                }
                return (Map)this.animals.get(AnimalsData.class);
            }
            catch (ExecutionException e) {
                Journeymap.getLogger().error("ExecutionException in getAnimals: " + LogFormatter.toString(e));
                return Collections.EMPTY_MAP;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, EntityDTO> getMobs(boolean forceRefresh) {
        LoadingCache<Class, Map<String, EntityDTO>> loadingCache = this.mobs;
        synchronized (loadingCache) {
            try {
                if (forceRefresh) {
                    this.mobs.invalidateAll();
                }
                return (Map)this.mobs.get(MobsData.class);
            }
            catch (ExecutionException e) {
                Journeymap.getLogger().error("ExecutionException in getMobs: " + LogFormatter.toString(e));
                return Collections.EMPTY_MAP;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, EntityDTO> getPlayers(boolean forceRefresh) {
        LoadingCache<Class, Map<String, EntityDTO>> loadingCache = this.players;
        synchronized (loadingCache) {
            try {
                if (forceRefresh) {
                    this.players.invalidateAll();
                }
                return (Map)this.players.get(PlayersData.class);
            }
            catch (ExecutionException e) {
                Journeymap.getLogger().error("ExecutionException in getPlayers: " + LogFormatter.toString(e));
                return Collections.EMPTY_MAP;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EntityDTO getPlayer(boolean forceRefresh) {
        LoadingCache<Class, EntityDTO> loadingCache = this.player;
        synchronized (loadingCache) {
            try {
                if (forceRefresh) {
                    this.player.invalidateAll();
                }
                return (EntityDTO)this.player.get(PlayerData.class);
            }
            catch (Exception e) {
                Journeymap.getLogger().error("ExecutionException in getPlayer: " + LogFormatter.toString(e));
                return null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, EntityDTO> getVillagers(boolean forceRefresh) {
        LoadingCache<Class, Map<String, EntityDTO>> loadingCache = this.villagers;
        synchronized (loadingCache) {
            try {
                if (forceRefresh) {
                    this.villagers.invalidateAll();
                }
                return (Map)this.villagers.get(VillagersData.class);
            }
            catch (ExecutionException e) {
                Journeymap.getLogger().error("ExecutionException in getVillagers: " + LogFormatter.toString(e));
                return Collections.EMPTY_MAP;
            }
        }
    }

    public MapType getMapType(MapType.Name name, Integer vSlice, class_5321<class_1937> dimension) {
        vSlice = name != MapType.Name.underground ? null : vSlice;
        MapType mapType = (MapType)this.mapTypes.getIfPresent((Object)MapType.toCacheKey(name, vSlice, dimension));
        if (mapType == null) {
            mapType = new MapType(name, vSlice, dimension);
            this.mapTypes.put((Object)mapType.toCacheKey(), (Object)mapType);
        }
        return mapType;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<Waypoint> getWaypoints(boolean forceRefresh) {
        LoadingCache<Class, Collection<Waypoint>> loadingCache = this.waypoints;
        synchronized (loadingCache) {
            if (WaypointsData.isManagerEnabled()) {
                return WaypointStore.INSTANCE.getAll();
            }
            return Collections.EMPTY_LIST;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, Object> getMessages(boolean forceRefresh) {
        LoadingCache<Class, Map<String, Object>> loadingCache = this.messages;
        synchronized (loadingCache) {
            try {
                if (forceRefresh) {
                    this.messages.invalidateAll();
                }
                return (Map)this.messages.get(MessagesData.class);
            }
            catch (ExecutionException e) {
                Journeymap.getLogger().error("ExecutionException in getMessages: " + LogFormatter.toString(e));
                return Collections.EMPTY_MAP;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WorldData getWorld(boolean forceRefresh) {
        LoadingCache<Class, WorldData> loadingCache = this.world;
        synchronized (loadingCache) {
            try {
                if (forceRefresh) {
                    this.world.invalidateAll();
                }
                return (WorldData)((Object)this.world.get(WorldData.class));
            }
            catch (ExecutionException e) {
                Journeymap.getLogger().error("ExecutionException in getWorld: " + LogFormatter.toString(e));
                return new WorldData();
            }
        }
    }

    public void resetRadarCaches() {
        this.animals.invalidateAll();
        this.mobs.invalidateAll();
        this.players.invalidateAll();
        this.villagers.invalidateAll();
        this.entityDrawSteps.invalidateAll();
        this.entityDTOs.invalidateAll();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DrawEntityStep getDrawEntityStep(class_1309 entity) {
        LoadingCache<class_1309, DrawEntityStep> loadingCache = this.entityDrawSteps;
        synchronized (loadingCache) {
            return (DrawEntityStep)this.entityDrawSteps.getUnchecked((Object)entity);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EntityDTO getEntityDTO(class_1309 entity) {
        LoadingCache<class_1309, EntityDTO> loadingCache = this.entityDTOs;
        synchronized (loadingCache) {
            return (EntityDTO)this.entityDTOs.getUnchecked((Object)entity);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<class_2338> getTriangulation(PolygonOverlay overlay) {
        LoadingCache<PolygonOverlay, List<class_2338>> loadingCache = this.polygonTriangulation;
        synchronized (loadingCache) {
            return (List)this.polygonTriangulation.getUnchecked((Object)overlay);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DrawPolygonStep getDrawPolygonStep(PolygonOverlay overlay) {
        LoadingCache<PolygonOverlay, DrawPolygonStep> loadingCache = this.polygonDrawSteps;
        synchronized (loadingCache) {
            return (DrawPolygonStep)this.polygonDrawSteps.getUnchecked((Object)overlay);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invalidatePolygon(PolygonOverlay overlay) {
        LoadingCache<PolygonOverlay, DrawPolygonStep> loadingCache = this.polygonDrawSteps;
        synchronized (loadingCache) {
            this.polygonDrawSteps.invalidate((Object)overlay);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DrawImageStep getDrawImageStep(ImageOverlay overlay) {
        LoadingCache<ImageOverlay, DrawImageStep> loadingCache = this.imageDrawSteps;
        synchronized (loadingCache) {
            return (DrawImageStep)this.imageDrawSteps.getUnchecked((Object)overlay);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DrawMarkerStep getDrawMakerStep(MarkerOverlay overlay) {
        LoadingCache<MarkerOverlay, DrawMarkerStep> loadingCache = this.markerDrawSteps;
        synchronized (loadingCache) {
            return (DrawMarkerStep)this.markerDrawSteps.getUnchecked((Object)overlay);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DrawWayPointStep getDrawWayPointStep(Waypoint waypoint) {
        LoadingCache<Waypoint, DrawWayPointStep> loadingCache = this.waypointDrawSteps;
        synchronized (loadingCache) {
            return (DrawWayPointStep)this.waypointDrawSteps.getUnchecked((Object)waypoint);
        }
    }

    public boolean hasBlockMD(class_2680 aBlockState) {
        try {
            return this.blockMetadata.getIfPresent((Object)aBlockState) != null;
        }
        catch (Exception e) {
            return false;
        }
    }

    public BlockMD getBlockMD(class_2680 blockState) {
        try {
            return (BlockMD)this.blockMetadata.get((Object)blockState);
        }
        catch (Exception e) {
            Journeymap.getLogger().error("Error in getBlockMD() for " + blockState + ": " + e);
            return BlockMD.AIRBLOCK;
        }
    }

    public int getBlockMDCount() {
        return this.blockMetadata.asMap().size();
    }

    public Set<BlockMD> getLoadedBlockMDs() {
        return Sets.newHashSet(this.blockMetadata.asMap().values());
    }

    public void resetBlockMetadata() {
        this.blockMetadata.invalidateAll();
    }

    public ChunkMD getChunkMD(class_2338 blockPos) {
        return this.getChunkMD(class_1923.method_8331((int)(blockPos.method_10263() >> 4), (int)(blockPos.method_10260() >> 4)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ChunkMD getChunkMD(long coordLong) {
        Cache<class_1923, ChunkMD> cache = this.chunkMetadata;
        synchronized (cache) {
            try {
                class_1923 coord = (class_1923)this.chunkCoordCache.get(coordLong);
                if (coord == null) {
                    int x = (int)(coordLong & 0xFFFFFFFFL);
                    int z = (int)(coordLong >>> 32 & 0xFFFFFFFFL);
                    coord = new class_1923(x, z);
                    this.chunkCoordCache.put(coordLong, (Object)coord);
                }
                class_310 mc = class_310.method_1551();
                if (mc.field_1687 == null || mc.field_1724 == null || mc.field_1687 != mc.field_1724.method_37908()) {
                    return null;
                }
                ChunkMD chunkMD = (ChunkMD)this.chunkMetadata.getIfPresent((Object)coord);
                if (chunkMD != null && chunkMD.hasChunk()) {
                    return chunkMD;
                }
                chunkMD = JMChunkLoader.getChunkMdFromMemory(mc.field_1724.method_37908(), class_1923.method_8325((long)coord.field_9181), class_1923.method_8332((long)coord.field_9180));
                if (chunkMD != null && chunkMD.hasChunk() && chunkMD.getChunk().method_12200().method_27983() == mc.field_1724.method_37908().method_27983()) {
                    this.chunkMetadata.put((Object)coord, (Object)chunkMD);
                    return chunkMD;
                }
                if (chunkMD != null) {
                    this.chunkMetadata.invalidate((Object)coord);
                }
                return null;
            }
            catch (Throwable e) {
                Journeymap.getLogger().warn("Unexpected error getting ChunkMD from cache: ", e);
                return null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addChunkMD(ChunkMD chunkMD) {
        Cache<class_1923, ChunkMD> cache = this.chunkMetadata;
        synchronized (cache) {
            this.chunkMetadata.put((Object)chunkMD.getCoord(), (Object)chunkMD);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeChunkMD(ChunkMD chunkMD) {
        Cache<class_1923, ChunkMD> cache = this.chunkMetadata;
        synchronized (cache) {
            this.chunkMetadata.invalidate((Object)chunkMD.getCoord());
            this.chunkCoordCache.remove(chunkMD.getLongCoord());
        }
    }

    public void invalidateChunkMDCache() {
        this.chunkMetadata.invalidateAll();
        this.chunkCoordCache.clear();
    }

    public void stopChunkMDRetention() {
        for (ChunkMD chunkMD : this.chunkMetadata.asMap().values()) {
            if (chunkMD == null) continue;
            chunkMD.stopChunkRetention();
        }
    }

    public LoadingCache<RegionImageSet.Key, RegionImageSet> getRegionImageSets() {
        return this.regionImageSets;
    }

    public Cache<String, RegionCoord> getRegionCoords() {
        return this.regionCoords;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void purge() {
        RegionImageCache.INSTANCE.flushToDisk(false);
        this.resetBlockMetadata();
        HashMap<Cache, String> hashMap = this.managedCaches;
        synchronized (hashMap) {
            this.chunkCoordCache.clear();
            for (Cache cache : this.managedCaches.keySet()) {
                try {
                    cache.invalidateAll();
                }
                catch (Exception e) {
                    Journeymap.getLogger().warn("Couldn't purge managed cache: " + cache);
                }
            }
        }
    }

    public String getDebugHtml() {
        StringBuffer sb = new StringBuffer();
        if (JourneymapClient.getInstance().getCoreProperties().recordCacheStats.get().booleanValue()) {
            this.appendDebugHtml(sb, "Managed Caches", this.managedCaches);
        } else {
            sb.append("<b>Cache stat recording disabled.  Set config/journeymap.core.config 'recordCacheStats' to 1.</b>");
        }
        return sb.toString();
    }

    private void appendDebugHtml(StringBuffer sb, String name, Map<Cache, String> cacheMap) {
        ArrayList<Map.Entry<Cache, String>> list = new ArrayList<Map.Entry<Cache, String>>(cacheMap.entrySet());
        Collections.sort(list, new Comparator<Map.Entry<Cache, String>>(){

            @Override
            public int compare(Map.Entry<Cache, String> o1, Map.Entry<Cache, String> o2) {
                return o1.getValue().compareTo(o2.getValue());
            }
        });
        sb.append("<b>").append(name).append(":</b>");
        sb.append("<pre>");
        for (Map.Entry<Cache, String> entry : list) {
            sb.append(this.toString(entry.getValue(), entry.getKey()));
        }
        sb.append("</pre>");
    }

    private String toString(String label, Cache cache) {
        double avgLoadMillis = 0.0;
        CacheStats cacheStats = cache.stats();
        if (cacheStats.totalLoadTime() > 0L && cacheStats.loadSuccessCount() > 0L) {
            avgLoadMillis = (double)TimeUnit.NANOSECONDS.toMillis(cacheStats.totalLoadTime()) * 1.0 / (double)cacheStats.loadSuccessCount();
        }
        return String.format("%s<b>%20s:</b> Size: %9s, Hits: %9s, Misses: %9s, Loads: %9s, Errors: %9s, Avg Load Time: %1.2fms", LogFormatter.LINEBREAK, label, cache.size(), cacheStats.hitCount(), cacheStats.missCount(), cacheStats.loadCount(), cacheStats.loadExceptionCount(), avgLoadMillis);
    }
}

