/*
 * Decompiled with CFR 0.152.
 */
package journeymap.common.network.packets;

import journeymap.client.JourneymapClient;
import journeymap.common.Journeymap;
import journeymap.common.network.data.PacketContext;
import journeymap.common.network.data.Side;
import net.minecraft.class_2540;
import net.minecraft.class_2960;

public class MultiplayerOptionsPacket {
    public static final class_2960 CHANNEL = new class_2960("journeymap", "mp_options_req");
    private String payload;

    public MultiplayerOptionsPacket() {
    }

    public MultiplayerOptionsPacket(String payload) {
        this.payload = payload;
    }

    public String getPayload() {
        return this.payload;
    }

    public static MultiplayerOptionsPacket decode(class_2540 buf) {
        MultiplayerOptionsPacket packet = new MultiplayerOptionsPacket();
        try {
            if (buf.readableBytes() > 1) {
                buf.readByte();
                packet.payload = buf.method_10800(Short.MAX_VALUE);
            }
        }
        catch (Throwable t) {
            Journeymap.getLogger().error(String.format("Failed to read message for multiplayer options request: %s", t));
        }
        return packet;
    }

    public void encode(class_2540 buf) {
        try {
            if (this.payload != null) {
                buf.method_52997(42);
                buf.method_10814(this.payload);
            }
        }
        catch (Throwable t) {
            Journeymap.getLogger().error("[toBytes]Failed to write message for multiplayer options request:" + t);
        }
    }

    public static void handle(PacketContext<MultiplayerOptionsPacket> ctx) {
        if (Side.SERVER.equals((Object)ctx.side())) {
            if (ctx.message().getPayload() == null) {
                Journeymap.getInstance().getPacketHandler().onMultiplayerOptionsOpen(ctx.sender());
            } else {
                Journeymap.getInstance().getPacketHandler().onMultiplayerOptionsSave(ctx.sender(), ctx.message().getPayload());
            }
        } else {
            JourneymapClient.getInstance().getPacketHandler().onMultiplayerDataResponse(ctx.message().getPayload());
        }
    }
}

