/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.malilib.render.shader;

import fi.dy.masa.malilib.MaLiLib;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Optional;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3298;
import org.lwjgl.opengl.GL20;

public class ShaderProgram {
    private final class_310 mc = class_310.method_1551();
    private int program;

    public ShaderProgram(String domain, String vertShaderFilename, String fragShaderFilename) {
        try {
            this.init(domain, vertShaderFilename, fragShaderFilename);
        }
        catch (Exception e) {
            MaLiLib.logger.error("Could not initialize shader program!", (Throwable)e);
            this.program = 0;
        }
    }

    private void init(String domain, String vertShaderFilename, String fragShaderFilename) {
        this.program = GL20.glCreateProgram();
        int vertShader = this.loadAndCompileShader(domain, vertShaderFilename, 35633);
        int fragShader = this.loadAndCompileShader(domain, fragShaderFilename, 35632);
        if (vertShader != 0) {
            GL20.glAttachShader((int)this.program, (int)vertShader);
        }
        if (fragShader != 0) {
            GL20.glAttachShader((int)this.program, (int)fragShader);
        }
        GL20.glLinkProgram((int)this.program);
        if (GL20.glGetProgrami((int)this.program, (int)35714) == 0) {
            MaLiLib.logger.error("Could not link shader: {}", (Object)GL20.glGetProgramInfoLog((int)this.program, (int)1024));
            GL20.glDeleteProgram((int)this.program);
            this.program = 0;
            return;
        }
        GL20.glValidateProgram((int)this.program);
        if (GL20.glGetProgrami((int)this.program, (int)35715) == 0) {
            MaLiLib.logger.error("Could not validate shader: {}", (Object)GL20.glGetProgramInfoLog((int)this.program, (int)1024));
            GL20.glDeleteProgram((int)this.program);
            this.program = 0;
        }
    }

    private int loadAndCompileShader(String domain, String filename, int shaderType) {
        if (filename == null) {
            return 0;
        }
        int handle = GL20.glCreateShader((int)shaderType);
        if (handle == 0) {
            MaLiLib.logger.error("Could not create shader of type {} for {}: {}", (Object)shaderType, (Object)filename, (Object)GL20.glGetProgramInfoLog((int)this.program, (int)1024));
            return 0;
        }
        String code = this.loadFile(new class_2960(domain, filename));
        if (code == null) {
            GL20.glDeleteShader((int)handle);
            return 0;
        }
        GL20.glShaderSource((int)handle, (CharSequence)code);
        GL20.glCompileShader((int)handle);
        if (GL20.glGetShaderi((int)handle, (int)35713) == 0) {
            MaLiLib.logger.error("Could not compile shader {}: {}", (Object)filename, (Object)GL20.glGetShaderInfoLog((int)this.program, (int)1024));
            GL20.glDeleteShader((int)handle);
            return 0;
        }
        return handle;
    }

    private String loadFile(class_2960 resourceLocation) {
        try {
            String line;
            Optional optional = this.mc.method_1478().method_14486(resourceLocation);
            if (!optional.isPresent()) {
                return null;
            }
            StringBuilder code = new StringBuilder();
            InputStream inputStream = ((class_3298)optional.get()).method_14482();
            BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream));
            while ((line = reader.readLine()) != null) {
                code.append(line);
                code.append('\n');
            }
            reader.close();
            return code.toString();
        }
        catch (Exception e) {
            MaLiLib.logger.error("Could not load shader file!", (Throwable)e);
            return null;
        }
    }

    public int getProgram() {
        return this.program;
    }
}

