/*
 * Decompiled with CFR 0.152.
 */
package me.jellysquid.mods.lithium.common.entity.item;

import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntListIterator;
import it.unimi.dsi.fastutil.objects.Reference2ReferenceOpenHashMap;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.ConcurrentModificationException;
import java.util.function.Consumer;
import java.util.function.IntFunction;
import java.util.stream.Stream;
import net.minecraft.class_7927;
import org.jetbrains.annotations.NotNull;

public abstract class ElementCategorizingList<T, Category>
extends AbstractList<T> {
    private static final int CATEGORY_DOWNGRADE_THRESHOLD = 15;
    private static final int CATEGORY_UPGRADE_THRESHOLD = 20;
    private final ArrayList<T> delegate;
    private final ArrayList<T> delegateWithNulls;
    private final Reference2ReferenceOpenHashMap<Category, IntArrayList> elementsByType;
    private final Reference2ReferenceOpenHashMap<Category, IntArrayList> elementsByTypeA;
    private final Reference2ReferenceOpenHashMap<Category, IntArrayList> elementsByTypeB;
    private int modCount;

    public ElementCategorizingList(ArrayList<T> delegate) {
        this.delegate = delegate;
        this.delegateWithNulls = new ArrayList(this.delegate.size());
        this.elementsByType = new Reference2ReferenceOpenHashMap();
        this.elementsByTypeA = new Reference2ReferenceOpenHashMap();
        this.elementsByTypeB = new Reference2ReferenceOpenHashMap();
    }

    protected void initialize() {
        this.initializeInternal();
    }

    abstract Category getCategory(T var1);

    abstract boolean areSubcategoriesAlwaysEmpty(Category var1);

    abstract boolean isSubCategoryA(T var1);

    abstract boolean isSubCategoryB(T var1);

    abstract void onElementSubcategorized(T var1, int var2);

    abstract void onElementUnSubcategorized(T var1);

    abstract void onCollectionReset();

    abstract T castOrNull(Object var1);

    @SafeVarargs
    public final void consumeCategories(class_7927<T> elementConsumer, Category ... categories) {
        IntArrayList[] categoryLists = new IntArrayList[categories.length];
        int totalSize = 0;
        int numCategories = 0;
        for (Category category : categories) {
            IntArrayList categoryList = (IntArrayList)this.elementsByType.get(category);
            if (categoryList.isEmpty()) continue;
            categoryLists[numCategories++] = categoryList;
            totalSize += categoryList.size();
        }
        if (numCategories <= 1) {
            this.consumeElements(elementConsumer, categoryLists[0]);
            return;
        }
        int[] categoryListIndices = new int[categoryLists.length];
        for (int i = 0; i < totalSize; ++i) {
            int smallestIndex = -1;
            int smallestIndexCategory = -1;
            for (int j = 0; j < numCategories; ++j) {
                int categoryListIndex = categoryListIndices[j];
                if (categoryListIndex >= categoryLists[j].size() || smallestIndex != -1 && categoryLists[j].getInt(categoryListIndex) >= smallestIndex) continue;
                smallestIndex = categoryLists[j].getInt(categoryListIndex);
                smallestIndexCategory = j;
            }
            if (smallestIndexCategory == -1) {
                throw new IllegalStateException("No more elements to get!");
            }
            int n = smallestIndexCategory;
            categoryListIndices[n] = categoryListIndices[n] + 1;
            T element = this.delegateWithNulls.get(smallestIndex);
            class_7927.class_7928 next = elementConsumer.accept(element);
            if (!next.method_47543()) continue;
            return;
        }
    }

    public class_7927.class_7928 consumeCategory(class_7927<T> elementConsumer, Category category) {
        IntArrayList categoryList = (IntArrayList)this.elementsByType.get(category);
        return this.consumeElements(elementConsumer, categoryList);
    }

    public class_7927.class_7928 consumeCategoryA(class_7927<T> elementConsumer, Category category) {
        IntArrayList categoryList = (IntArrayList)this.elementsByTypeA.get(category);
        if (categoryList == null && !this.areSubcategoriesAlwaysEmpty(category)) {
            categoryList = (IntArrayList)this.elementsByType.get(category);
        }
        return this.consumeElements(elementConsumer, categoryList);
    }

    public class_7927.class_7928 consumeCategoryB(class_7927<T> elementConsumer, Category category) {
        IntArrayList categoryList = (IntArrayList)this.elementsByTypeB.get(category);
        if (categoryList == null && !this.areSubcategoriesAlwaysEmpty(category)) {
            categoryList = (IntArrayList)this.elementsByType.get(category);
        }
        return this.consumeElements(elementConsumer, categoryList);
    }

    private class_7927.class_7928 consumeElements(class_7927<T> elementConsumer, IntArrayList categoryList) {
        if (categoryList == null) {
            return class_7927.class_7928.field_41283;
        }
        int expectedModCount = this.modCount;
        int size = categoryList.size();
        for (int i = 0; i < size; ++i) {
            if (expectedModCount != this.modCount) {
                throw new ConcurrentModificationException("Collection was modified during iteration!");
            }
            int index = categoryList.getInt(i);
            T element = this.delegateWithNulls.get(index);
            class_7927.class_7928 next = elementConsumer.accept(element);
            if (next == class_7927.class_7928.field_41283) continue;
            return next;
        }
        return class_7927.class_7928.field_41283;
    }

    private void initSubCategories(Category category, IntArrayList source) {
        if (this.areSubcategoriesAlwaysEmpty(category)) {
            return;
        }
        IntArrayList categoryListA = new IntArrayList();
        IntArrayList categoryListB = new IntArrayList();
        this.elementsByTypeA.put(category, (Object)categoryListA);
        this.elementsByTypeB.put(category, (Object)categoryListB);
        for (int i = 0; i < source.size(); ++i) {
            int elementIndex = source.getInt(i);
            T element = this.delegateWithNulls.get(elementIndex);
            if (this.isSubCategoryA(element)) {
                categoryListA.add(elementIndex);
            }
            if (this.isSubCategoryB(element)) {
                categoryListB.add(elementIndex);
            }
            this.onElementSubcategorized(element, elementIndex);
        }
    }

    private void removeSubCategories(Category category) {
        IntArrayList remove = (IntArrayList)this.elementsByTypeA.remove(category);
        if (remove == null) {
            return;
        }
        this.elementsByTypeB.remove(category);
        IntArrayList categoryList = (IntArrayList)this.elementsByType.get(category);
        IntListIterator intListIterator = categoryList.iterator();
        while (intListIterator.hasNext()) {
            int index = (Integer)intListIterator.next();
            this.onElementUnSubcategorized(this.delegateWithNulls.get(index));
        }
    }

    @Override
    public int size() {
        return this.delegate.size();
    }

    @Override
    public boolean isEmpty() {
        return this.delegate.isEmpty();
    }

    @Override
    public boolean contains(Object o) {
        return this.delegate.contains(o);
    }

    @Override
    @NotNull
    public @NotNull Object @NotNull [] toArray() {
        return this.delegate.toArray();
    }

    @Override
    @NotNull
    public <U> @NotNull U @NotNull [] toArray(U @NotNull [] a) {
        return this.delegate.toArray(a);
    }

    @Override
    public boolean add(T element) {
        this.addInternal(element);
        return this.delegate.add(element);
    }

    private void addInternal(T element) {
        ++this.modCount;
        Category category = this.getCategory(element);
        int index = this.delegateWithNulls.size();
        this.delegateWithNulls.add(element);
        IntArrayList categoryList = (IntArrayList)this.elementsByType.computeIfAbsent(category, e -> new IntArrayList());
        categoryList.add(index);
        if (categoryList.size() > 15) {
            IntArrayList categoryListA = (IntArrayList)this.elementsByTypeA.get(category);
            if (categoryListA != null) {
                if (this.isSubCategoryA(element)) {
                    categoryListA.add(index);
                }
                if (this.isSubCategoryB(element)) {
                    IntArrayList categoryListB = (IntArrayList)this.elementsByTypeB.get(category);
                    categoryListB.add(index);
                }
                this.onElementSubcategorized(element, index);
            } else if (categoryList.size() > 20) {
                this.initSubCategories(category, categoryList);
            }
        }
        if (this.delegateWithNulls.size() == Integer.MAX_VALUE) {
            throw new IllegalStateException("Internal list size hit Integer.MAX_VALUE");
        }
    }

    @Override
    public boolean remove(Object o) {
        T element;
        boolean remove = this.delegate.remove(o);
        if (remove && (element = this.castOrNull(o)) != null) {
            this.removeInternal(element);
        }
        return remove;
    }

    @Override
    public boolean containsAll(@NotNull Collection<?> c) {
        return this.delegate.containsAll(c);
    }

    @Override
    public void clear() {
        this.delegate.clear();
        this.resetInternal();
        this.initializeInternal();
    }

    @Override
    public boolean equals(Object o) {
        return this.delegate.equals(o);
    }

    @Override
    public int hashCode() {
        return this.delegate.hashCode();
    }

    @Override
    public T get(int index) {
        return this.delegate.get(index);
    }

    @Override
    public T set(int index, T element) {
        T previous = this.delegate.set(index, element);
        if (previous != element) {
            ++this.modCount;
            Category previousCategory = this.getCategory(previous);
            Category category = this.getCategory(element);
            int internalIndex = this.delegateWithNulls.indexOf(previous);
            this.delegateWithNulls.set(internalIndex, element);
            boolean subCategoryA = this.isSubCategoryA(element);
            boolean subCategoryB = this.isSubCategoryB(element);
            boolean prevSubCategoryA = this.isSubCategoryA(previous);
            boolean prevSubCategoryB = this.isSubCategoryB(previous);
            if (this.isSubCategorized(previousCategory)) {
                this.onElementUnSubcategorized(previous);
            }
            this.updateCategoryAndSubcategories(category, previousCategory, internalIndex, subCategoryA, prevSubCategoryA, subCategoryB, prevSubCategoryB);
            if (this.isSubCategorized(category)) {
                this.onElementSubcategorized(element, internalIndex);
            }
        }
        return previous;
    }

    private boolean isSubCategorized(Category previousCategory) {
        return this.elementsByTypeA.containsKey(previousCategory);
    }

    void updateCategoryAndSubcategories(Category category, Category previousCategory, int internalIndex, boolean subCategoryA, boolean prevSubCategoryA, boolean subCategoryB, boolean prevSubCategoryB) {
        boolean changedB;
        boolean changedCategory = category != previousCategory;
        boolean changedA = changedCategory || subCategoryA != prevSubCategoryA;
        boolean bl = changedB = changedCategory || subCategoryB != prevSubCategoryB;
        if (!(changedCategory || changedA || changedB)) {
            return;
        }
        ++this.modCount;
        IntArrayList previousCategoryList = (IntArrayList)this.elementsByType.get(previousCategory);
        IntArrayList categoryList = (IntArrayList)this.elementsByType.computeIfAbsent(category, e -> new IntArrayList());
        if (changedCategory) {
            previousCategoryList.rem(internalIndex);
            int binarySearchIndex = Collections.binarySearch(categoryList, internalIndex);
            binarySearchIndex = -(binarySearchIndex + 1);
            categoryList.add(binarySearchIndex, internalIndex);
        }
        if (previousCategoryList.size() >= 15) {
            this.removeFromSubCategories(previousCategoryList, previousCategory, internalIndex, prevSubCategoryA && changedA, prevSubCategoryB && changedB, changedCategory);
        }
        this.addToSubCategories(categoryList, category, internalIndex, subCategoryA && changedA, subCategoryB && changedB, changedCategory);
    }

    void removeFromSubCategories(Category previousCategory, int internalIndex, boolean removeFromA, boolean removeFromB, boolean allowRemoval) {
        ++this.modCount;
        this.removeFromSubCategories((IntArrayList)this.elementsByType.get(previousCategory), previousCategory, internalIndex, removeFromA, removeFromB, allowRemoval);
    }

    private void removeFromSubCategories(IntArrayList previousCategoryList, Category previousCategory, int internalIndex, boolean removeFromA, boolean removeFromB, boolean allowRemoval) {
        if (allowRemoval && previousCategoryList.size() == 15) {
            this.removeSubCategories(previousCategory);
        } else {
            IntArrayList categoryListA = (IntArrayList)this.elementsByTypeA.get(previousCategory);
            if (categoryListA != null) {
                if (removeFromA) {
                    categoryListA.rem(internalIndex);
                }
                if (removeFromB) {
                    ((IntArrayList)this.elementsByTypeB.get(previousCategory)).rem(internalIndex);
                }
            }
        }
    }

    void addToSubCategories(Category category, int internalIndex, boolean subCategoryA, boolean subCategoryB, boolean allowCreation) {
        ++this.modCount;
        IntArrayList categoryList = (IntArrayList)this.elementsByType.computeIfAbsent(category, e -> new IntArrayList());
        this.addToSubCategories(categoryList, category, internalIndex, subCategoryA, subCategoryB, allowCreation);
    }

    private void addToSubCategories(IntArrayList categoryList, Category category, int internalIndex, boolean addToCategoryA, boolean addToCategoryB, boolean allowCreation) {
        if (categoryList.size() > 15) {
            IntArrayList categoryListA = (IntArrayList)this.elementsByTypeA.get(category);
            if (categoryListA != null) {
                if (addToCategoryA) {
                    int binarySearchIndex = Collections.binarySearch(categoryListA, internalIndex);
                    binarySearchIndex = -(binarySearchIndex + 1);
                    categoryListA.add(binarySearchIndex, internalIndex);
                }
                if (addToCategoryB) {
                    IntArrayList categoryListB = (IntArrayList)this.elementsByTypeB.get(category);
                    int binarySearchIndex = Collections.binarySearch(categoryListB, internalIndex);
                    binarySearchIndex = -(binarySearchIndex + 1);
                    categoryListB.add(binarySearchIndex, internalIndex);
                }
            } else if (allowCreation && categoryList.size() > 20) {
                this.initSubCategories(category, categoryList);
            }
        }
    }

    @Override
    public T remove(int index) {
        T removed = this.delegate.remove(index);
        this.removeInternal(removed);
        return removed;
    }

    private void removeInternal(T element) {
        ++this.modCount;
        Category category = this.getCategory(element);
        IntArrayList categoryList = (IntArrayList)this.elementsByType.get(category);
        int index = this.delegateWithNulls.indexOf(element);
        if (index != this.delegateWithNulls.size() - 1) {
            this.delegateWithNulls.set(index, null);
        } else {
            this.delegateWithNulls.remove(index);
        }
        categoryList.rem(index);
        if (categoryList.size() >= 15) {
            if (categoryList.size() == 15) {
                this.removeSubCategories(category);
            } else {
                IntArrayList categoryListA = (IntArrayList)this.elementsByTypeA.get(category);
                if (categoryListA != null) {
                    categoryListA.rem(index);
                    ((IntArrayList)this.elementsByTypeB.get(category)).rem(index);
                    this.onElementUnSubcategorized(element);
                }
            }
        }
        this.checkResize();
    }

    private void checkResize() {
        int size = this.delegateWithNulls.size();
        if (size > 64 && size > this.delegate.size() * 2) {
            this.resetInternal();
            this.initializeInternal();
        }
    }

    private void resetInternal() {
        this.onCollectionReset();
        this.delegateWithNulls.clear();
        this.elementsByType.clear();
        this.elementsByTypeA.clear();
        this.elementsByTypeB.clear();
    }

    private void initializeInternal() {
        for (T element : this.delegate) {
            this.addInternal(element);
        }
    }

    @Override
    public int indexOf(Object o) {
        return this.delegate.indexOf(o);
    }

    @Override
    public int lastIndexOf(Object o) {
        return this.delegate.lastIndexOf(o);
    }

    @Override
    public <U> U[] toArray(IntFunction<U[]> generator) {
        return this.delegate.toArray(generator);
    }

    @Override
    public Stream<T> stream() {
        return this.delegate.stream();
    }

    @Override
    public Stream<T> parallelStream() {
        return this.delegate.parallelStream();
    }

    @Override
    public void forEach(Consumer<? super T> action) {
        this.delegate.forEach((Consumer<T>)action);
    }
}

