/*
 * Decompiled with CFR 0.152.
 */
package me.jellysquid.mods.lithium.mixin.experimental.chunk_tickets;

import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import java.util.Collections;
import java.util.Iterator;
import me.jellysquid.mods.lithium.common.util.collections.ChunkTicketSortedArraySet;
import net.minecraft.class_3204;
import net.minecraft.class_3228;
import net.minecraft.class_4706;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.LocalCapture;

@Mixin(value={class_3204.class})
public abstract class ChunkTicketManagerMixin {
    @Shadow
    private long field_13894;
    @Shadow
    @Final
    Long2ObjectOpenHashMap<class_4706<class_3228<?>>> field_13895;
    private final Long2ObjectOpenHashMap<class_4706<class_3228<?>>> positionWithExpiringTicket = new Long2ObjectOpenHashMap();

    private static boolean canNoneExpire(class_4706<class_3228<?>> tickets) {
        if (!tickets.isEmpty()) {
            for (class_3228 ticket : tickets) {
                if (!ChunkTicketManagerMixin.canExpire(ticket)) continue;
                return false;
            }
        }
        return true;
    }

    @Redirect(method={"method_14041"}, at=@At(value="INVOKE", target="Lnet/minecraft/util/collection/SortedArraySet;create(I)Lnet/minecraft/util/collection/SortedArraySet;"))
    private static class_4706<class_3228<?>> useLithiumSortedArraySet(int initialCapacity) {
        return new ChunkTicketSortedArraySet(initialCapacity);
    }

    private static boolean canExpire(class_3228<?> ticket) {
        return ticket.method_14281().method_20629() != 0L;
    }

    @Inject(method={"addTicket(JLnet/minecraft/server/world/ChunkTicket;)V"}, at={@At(value="INVOKE", target="Lnet/minecraft/server/world/ChunkTicket;setTickCreated(J)V")}, locals=LocalCapture.CAPTURE_FAILHARD)
    private void registerExpiringTicket(long position, class_3228<?> ticket, CallbackInfo ci, class_4706<class_3228<?>> ticketsAtPos, int i, class_3228<?> chunkTicket) {
        if (ChunkTicketManagerMixin.canExpire(ticket)) {
            this.positionWithExpiringTicket.put(position, ticketsAtPos);
        }
    }

    @Inject(method={"removeTicket(JLnet/minecraft/server/world/ChunkTicket;)V"}, at={@At(value="INVOKE", target="Lnet/minecraft/server/world/ChunkTicketManager$TicketDistanceLevelPropagator;updateLevel(JIZ)V")})
    private void unregisterExpiringTicket(long pos, class_3228<?> ticket, CallbackInfo ci) {
        class_4706 ticketsAtPos;
        if (ChunkTicketManagerMixin.canExpire(ticket) && ChunkTicketManagerMixin.canNoneExpire(ticketsAtPos = (class_4706)this.positionWithExpiringTicket.get(pos))) {
            this.positionWithExpiringTicket.remove(pos);
        }
    }

    @Inject(method={"addTicket(JLnet/minecraft/server/world/ChunkTicket;)V"}, at={@At(value="INVOKE", shift=At.Shift.BEFORE, target="Lnet/minecraft/util/collection/SortedArraySet;addAndGet(Ljava/lang/Object;)Ljava/lang/Object;")}, locals=LocalCapture.CAPTURE_FAILHARD)
    private void updateSetMinExpiryTime(long position, class_3228<?> ticket, CallbackInfo ci, class_4706<class_3228<?>> sortedArraySet, int i) {
        if (ChunkTicketManagerMixin.canExpire(ticket) && sortedArraySet instanceof ChunkTicketSortedArraySet) {
            ChunkTicketSortedArraySet chunkTickets = (ChunkTicketSortedArraySet)sortedArraySet;
            chunkTickets.addExpireTime(this.field_13894 + ticket.method_14281().method_20629());
        }
    }

    @Redirect(method={"purge"}, at=@At(value="FIELD", target="Lnet/minecraft/server/world/ChunkTicketManager;ticketsByPosition:Lit/unimi/dsi/fastutil/longs/Long2ObjectOpenHashMap;", ordinal=0))
    private Long2ObjectOpenHashMap<class_4706<class_3228<?>>> getExpiringTicketsByPosition(class_3204 chunkTicketManager) {
        return this.positionWithExpiringTicket;
    }

    @Redirect(method={"purge"}, at=@At(value="INVOKE", target="Lnet/minecraft/util/collection/SortedArraySet;isEmpty()Z"))
    private boolean retCanNoneExpire(class_4706<class_3228<?>> tickets) {
        return ChunkTicketManagerMixin.canNoneExpire(tickets);
    }

    @Inject(method={"purge"}, locals=LocalCapture.CAPTURE_FAILHARD, at={@At(value="INVOKE", shift=At.Shift.BEFORE, target="Lnet/minecraft/util/collection/SortedArraySet;isEmpty()Z")})
    private void removeIfEmpty(CallbackInfo ci, ObjectIterator<?> objectIterator, Long2ObjectMap.Entry<class_4706<class_3228<?>>> entry) {
        class_4706 ticketsAtPos = (class_4706)entry.getValue();
        if (ticketsAtPos.isEmpty()) {
            this.field_13895.remove(entry.getLongKey(), (Object)ticketsAtPos);
        }
    }

    @Redirect(method={"purge"}, at=@At(value="INVOKE", target="Lnet/minecraft/util/collection/SortedArraySet;iterator()Ljava/util/Iterator;"))
    private Iterator<class_3228<?>> skipIfNotExpiringNow(class_4706<class_3228<?>> ticketsAtPos) {
        ChunkTicketSortedArraySet optimizedSet;
        if (ticketsAtPos instanceof ChunkTicketSortedArraySet && (optimizedSet = (ChunkTicketSortedArraySet)ticketsAtPos).getMinExpireTime() > this.field_13894) {
            return Collections.emptyIterator();
        }
        return ticketsAtPos.iterator();
    }
}

