/*
 * Decompiled with CFR 0.152.
 */
package su.plo.lib.api.chat;

import java.util.regex.Pattern;

public enum MinecraftTextStyle {
    BLACK(Type.COLOR, '0'),
    DARK_BLUE(Type.COLOR, '1'),
    DARK_GREEN(Type.COLOR, '2'),
    DARK_AQUA(Type.COLOR, '3'),
    DARK_RED(Type.COLOR, '4'),
    DARK_PURPLE(Type.COLOR, '5'),
    GOLD(Type.COLOR, '6'),
    GRAY(Type.COLOR, '7'),
    DARK_GRAY(Type.COLOR, '8'),
    BLUE(Type.COLOR, '9'),
    GREEN(Type.COLOR, 'a'),
    AQUA(Type.COLOR, 'b'),
    RED(Type.COLOR, 'c'),
    LIGHT_PURPLE(Type.COLOR, 'd'),
    YELLOW(Type.COLOR, 'e'),
    WHITE(Type.COLOR, 'f'),
    OBFUSCATED(Type.DECORATION, 'k'),
    BOLD(Type.DECORATION, 'l'),
    STRIKETHROUGH(Type.DECORATION, 'm'),
    UNDERLINE(Type.DECORATION, 'n'),
    ITALIC(Type.DECORATION, 'o'),
    RESET(Type.RESET, 'r');

    private static final char COLOR_CHAR = '\u00a7';
    private static final Pattern COLOR_CODE_PATTERN;
    private final Type type;
    private final char colorChar;

    public static String stripColorCodes(String input) {
        return COLOR_CODE_PATTERN.matcher(input).replaceAll("");
    }

    private MinecraftTextStyle(Type type, char colorChar) {
        this.type = type;
        this.colorChar = colorChar;
    }

    public String toString() {
        return String.format("%s%s", Character.valueOf('\u00a7'), Character.valueOf(this.colorChar));
    }

    public Type getType() {
        return this.type;
    }

    public char getColorChar() {
        return this.colorChar;
    }

    static {
        COLOR_CODE_PATTERN = Pattern.compile("\u00a7[0-9a-f]", 2);
    }

    public static enum Type {
        COLOR,
        DECORATION,
        RESET;

    }
}

