/*
 * Decompiled with CFR 0.152.
 */
package su.plo.voice.audio.codec.opus;

import com.sun.jna.ptr.PointerByReference;
import java.nio.IntBuffer;
import java.nio.ShortBuffer;
import su.plo.opus.Opus;
import su.plo.voice.api.audio.codec.CodecException;
import su.plo.voice.audio.codec.opus.BaseOpusDecoder;

public final class NativeOpusDecoder
implements BaseOpusDecoder {
    private final int sampleRate;
    private final int channels;
    private final int bufferSize;
    private final int mtuSize;
    private PointerByReference decoder;
    private ShortBuffer buffer;

    public NativeOpusDecoder(int sampleRate, boolean stereo, int bufferSize, int mtuSize) {
        this.sampleRate = sampleRate;
        this.channels = stereo ? 2 : 1;
        this.bufferSize = bufferSize;
        this.mtuSize = mtuSize;
    }

    @Override
    public short[] decode(byte[] encoded) throws CodecException {
        if (!this.isOpen()) {
            throw new CodecException("Decoder is not open");
        }
        this.buffer.clear();
        int result2 = encoded == null || encoded.length == 0 ? Opus.INSTANCE.opus_decode(this.decoder, null, 0, this.buffer, this.bufferSize, 0) : Opus.INSTANCE.opus_decode(this.decoder, encoded, encoded.length, this.buffer, this.bufferSize, 0);
        if (result2 != this.bufferSize) {
            throw new CodecException("Audio was decoded with invalid frame size");
        }
        if (result2 < 0) {
            throw new CodecException("Failed to decode audio: " + Opus.INSTANCE.opus_strerror(result2));
        }
        short[] decoded = encoded == null || encoded.length == 0 ? new short[result2] : new short[result2 * this.channels];
        this.buffer.get(decoded, 0, decoded.length);
        return decoded;
    }

    @Override
    public void open() throws CodecException {
        IntBuffer error = IntBuffer.allocate(1);
        this.decoder = Opus.INSTANCE.opus_decoder_create(this.sampleRate, this.channels, error);
        this.buffer = ShortBuffer.allocate(this.bufferSize * this.channels);
        if (error.get() != 0 && this.decoder == null) {
            throw new CodecException("Failed to open opus decoder:" + Opus.INSTANCE.opus_strerror(error.get()));
        }
    }

    @Override
    public void reset() {
        if (!this.isOpen()) {
            return;
        }
        Opus.INSTANCE.opus_decoder_ctl(this.decoder, 4028, new Object[0]);
    }

    @Override
    public void close() {
        if (!this.isOpen()) {
            return;
        }
        Opus.INSTANCE.opus_decoder_destroy(this.decoder);
        this.decoder = null;
        this.buffer = null;
    }

    @Override
    public boolean isOpen() {
        return this.decoder != null;
    }

    @Override
    public short[] decodePLC() throws CodecException {
        return this.decode(null);
    }
}

