/*
 * Decompiled with CFR 0.152.
 */
package su.plo.voice.client.config.keybind;

import org.jetbrains.annotations.NotNull;
import su.plo.config.entry.BooleanConfigEntry;
import su.plo.config.entry.ConfigEntry;
import su.plo.lib.api.chat.MinecraftTextComponent;
import su.plo.lib.mod.client.render.RenderUtil;
import su.plo.voice.api.client.PlasmoVoiceClient;
import su.plo.voice.api.client.config.keybind.KeyBinding;
import su.plo.voice.api.client.config.keybind.KeyBindings;
import su.plo.voice.client.config.VoiceClientConfig;
import su.plo.voice.proto.packets.tcp.serverbound.PlayerStatePacket;
import su.plo.voice.universal.UChat;

public final class HotkeyActions {
    private final PlasmoVoiceClient voiceClient;
    private final KeyBindings keyBindings;
    private final VoiceClientConfig config;

    public void register() {
        this.setHotkeyAction("key.plasmovoice.general.mute_microphone", this.createConfigToggleAction(this.config.getVoice().getMicrophoneDisabled()));
        this.config.getVoice().getMicrophoneDisabled().addChangeListener(value -> this.sendPlayerStatePacket());
        this.setHotkeyAction("key.plasmovoice.general.disable_voice", this.createConfigToggleAction(this.config.getVoice().getDisabled()));
        this.config.getVoice().getDisabled().addChangeListener(value -> this.sendPlayerStatePacket());
        this.setHotkeyAction("key.plasmovoice.occlusion.toggle", this.createKeyDownAction(() -> {
            BooleanConfigEntry entry;
            entry.set((Boolean)(entry = this.config.getVoice().getSoundOcclusion()).value() == false);
            UChat.actionBar(RenderUtil.getTextConverter().convert(MinecraftTextComponent.translatable("message.plasmovoice.occlusion_changed", (Boolean)entry.value() != false ? MinecraftTextComponent.translatable("message.plasmovoice.on", new Object[0]) : MinecraftTextComponent.translatable("message.plasmovoice.off", new Object[0]))));
        }));
    }

    private KeyBinding.OnPress createConfigToggleAction(ConfigEntry<Boolean> entry) {
        return this.createKeyDownAction(() -> entry.set((Boolean)entry.value() == false));
    }

    private KeyBinding.OnPress createKeyDownAction(Runnable runnable) {
        return action -> {
            if (action != KeyBinding.Action.DOWN) {
                return;
            }
            runnable.run();
        };
    }

    private void setHotkeyAction(@NotNull String name, @NotNull KeyBinding.OnPress onPress) {
        this.keyBindings.getKeyBinding(name).ifPresent(hotkey -> hotkey.addPressListener(onPress));
    }

    private void sendPlayerStatePacket() {
        this.voiceClient.getServerConnection().ifPresent(connection -> connection.sendPacket(new PlayerStatePacket((Boolean)this.config.getVoice().getDisabled().value(), (Boolean)this.config.getVoice().getMicrophoneDisabled().value())));
    }

    public HotkeyActions(PlasmoVoiceClient voiceClient, KeyBindings keyBindings, VoiceClientConfig config) {
        this.voiceClient = voiceClient;
        this.keyBindings = keyBindings;
        this.config = config;
    }
}

