/*
 * Decompiled with CFR 0.152.
 */
package su.plo.voice.client.connection;

import java.util.Optional;
import org.jetbrains.annotations.NotNull;
import su.plo.voice.api.client.connection.UdpClientManager;
import su.plo.voice.api.client.event.socket.UdpClientClosedEvent;
import su.plo.voice.api.client.socket.UdpClient;

public final class VoiceUdpClientManager
implements UdpClientManager {
    private UdpClient client;

    @Override
    public void setClient(@NotNull UdpClient client) {
        this.client = client;
    }

    @Override
    public void removeClient(@NotNull UdpClientClosedEvent.Reason reason) {
        if (this.client != null) {
            this.client.close(reason);
        }
        this.client = null;
    }

    @Override
    public Optional<UdpClient> getClient() {
        return Optional.ofNullable(this.client);
    }

    @Override
    public boolean isConnected() {
        if (this.client == null) {
            return false;
        }
        return !this.client.isClosed() && this.client.isConnected() && !this.client.isTimedOut();
    }
}

