/*
 * Decompiled with CFR 0.152.
 */
package su.plo.voice.client.gui.settings.tab;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import su.plo.config.entry.ConfigEntry;
import su.plo.lib.api.chat.MinecraftTextComponent;
import su.plo.lib.mod.client.gui.widget.GuiAbstractWidget;
import su.plo.voice.api.client.PlasmoVoiceClient;
import su.plo.voice.api.client.config.keybind.KeyBindings;
import su.plo.voice.client.config.VoiceClientConfig;
import su.plo.voice.client.config.keybind.KeyBindingConfigEntry;
import su.plo.voice.client.gui.settings.VoiceSettingsScreen;
import su.plo.voice.client.gui.settings.tab.TabWidget;
import su.plo.voice.client.gui.settings.widget.HotKeyWidget;

public abstract class AbstractHotKeysTabWidget
extends TabWidget {
    protected final KeyBindings hotKeys;
    private HotKeyWidget focusedHotKey;

    public AbstractHotKeysTabWidget(@NotNull VoiceSettingsScreen parent, @NotNull PlasmoVoiceClient voiceClient, @NotNull VoiceClientConfig config) {
        super(parent, voiceClient, config);
        this.hotKeys = voiceClient.getKeyBindings();
    }

    @Override
    public void removed() {
        super.removed();
        this.focusedHotKey = null;
        this.updateOptionEntries(widget -> widget instanceof HotKeyWidget);
    }

    public void setFocusedHotKey(@Nullable HotKeyWidget focusedHotKey) {
        if (this.focusedHotKey != null && focusedHotKey == null) {
            ((VoiceSettingsScreen)this.parent).setPreventEscClose(true);
        }
        this.focusedHotKey = focusedHotKey;
        this.hotKeys.resetStates();
    }

    protected TabWidget.OptionEntry<HotKeyWidget> createHotKey(@NotNull String translatable, @Nullable String tooltipTranslatable, @NotNull KeyBindingConfigEntry entry) {
        HotKeyWidget keyBinding = new HotKeyWidget(this, entry, 0, 0, 124, 20);
        return new TabWidget.OptionEntry((TabWidget)this, (MinecraftTextComponent)MinecraftTextComponent.translatable(translatable, new Object[0]), (GuiAbstractWidget)keyBinding, (ConfigEntry)entry, tooltipTranslatable != null ? MinecraftTextComponent.translatable(tooltipTranslatable, new Object[0]) : null);
    }

    public HotKeyWidget getFocusedHotKey() {
        return this.focusedHotKey;
    }
}

