/*
 * Decompiled with CFR 0.152.
 */
package su.plo.voice.client.gui.settings.tab;

import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import su.plo.config.entry.BooleanConfigEntry;
import su.plo.config.entry.ConfigEntry;
import su.plo.config.entry.DoubleConfigEntry;
import su.plo.config.entry.IntConfigEntry;
import su.plo.lib.api.chat.MinecraftTextComponent;
import su.plo.lib.mod.client.gui.widget.GuiAbstractWidget;
import su.plo.voice.client.BaseVoiceClient;
import su.plo.voice.client.config.VoiceClientConfig;
import su.plo.voice.client.config.addon.VoiceAddonConfig;
import su.plo.voice.client.gui.settings.VoiceSettingsScreen;
import su.plo.voice.client.gui.settings.tab.TabWidget;
import su.plo.voice.client.gui.settings.widget.DropDownWidget;

public final class AddonsTabWidget
extends TabWidget {
    private final BaseVoiceClient voiceClient;

    public AddonsTabWidget(@NotNull VoiceSettingsScreen parent, @NotNull BaseVoiceClient voiceClient, @NotNull VoiceClientConfig config) {
        super(parent, voiceClient, config);
        this.voiceClient = voiceClient;
    }

    @Override
    public void init() {
        super.init();
        this.voiceClient.getAddonConfigs().forEach((addonId, addonConfig) -> this.createAddonEntry((VoiceAddonConfig)addonConfig));
    }

    private void createAddonEntry(@NotNull VoiceAddonConfig addonConfig) {
        this.addEntry(new TabWidget.CategoryEntry(MinecraftTextComponent.translatable(addonConfig.getAddon().getName(), new Object[0])));
        addonConfig.getWidgets().forEach(widget -> {
            switch (widget.getType()) {
                case INT_SLIDER: {
                    this.addEntry(this.createIntSliderWidget(MinecraftTextComponent.translatable(widget.getTranslatable(), new Object[0]), widget.getTooltipTranslatable() != null ? MinecraftTextComponent.translatable(widget.getTooltipTranslatable(), new Object[0]) : null, (IntConfigEntry)widget.getConfigEntry(), ((VoiceAddonConfig.ConfigSliderWidget)widget).getSuffix()));
                    break;
                }
                case VOLUME_SLIDER: {
                    this.addEntry(this.createVolumeSlider(MinecraftTextComponent.translatable(widget.getTranslatable(), new Object[0]), widget.getTooltipTranslatable() != null ? MinecraftTextComponent.translatable(widget.getTooltipTranslatable(), new Object[0]) : null, (DoubleConfigEntry)widget.getConfigEntry(), ((VoiceAddonConfig.ConfigSliderWidget)widget).getSuffix()));
                    break;
                }
                case TOGGLE: {
                    this.addEntry(this.createToggleEntry(MinecraftTextComponent.translatable(widget.getTranslatable(), new Object[0]), widget.getTooltipTranslatable() != null ? MinecraftTextComponent.translatable(widget.getTooltipTranslatable(), new Object[0]) : null, (BooleanConfigEntry)widget.getConfigEntry()));
                    break;
                }
                case DROPDOWN: {
                    this.addEntry(this.createDropDownEntry((VoiceAddonConfig.ConfigDropDownWidget)widget));
                }
            }
        });
    }

    private TabWidget.OptionEntry<DropDownWidget> createDropDownEntry(VoiceAddonConfig.ConfigDropDownWidget widget) {
        IntConfigEntry configEntry = (IntConfigEntry)widget.getConfigEntry();
        DropDownWidget dropdown = new DropDownWidget((VoiceSettingsScreen)this.parent, 0, 0, 124, 20, MinecraftTextComponent.translatable(widget.getElements().get((Integer)configEntry.value()), new Object[0]), widget.getElements().stream().map(x$0 -> MinecraftTextComponent.translatable(x$0, new Object[0])).collect(Collectors.toList()), widget.isElementTooltip(), configEntry::set);
        return new TabWidget.OptionEntry((TabWidget)this, (MinecraftTextComponent)MinecraftTextComponent.translatable(widget.getTranslatable(), new Object[0]), (GuiAbstractWidget)dropdown, (ConfigEntry)configEntry, (button, element) -> element.setText(MinecraftTextComponent.translatable(widget.getElements().get((Integer)configEntry.value()), new Object[0])));
    }
}

