/*
 * Decompiled with CFR 0.152.
 */
package su.plo.voice.client.gui.settings.tab;

import com.google.common.collect.ImmutableList;
import java.util.List;
import su.plo.config.entry.ConfigEntry;
import su.plo.lib.api.chat.MinecraftTextComponent;
import su.plo.lib.mod.client.gui.widget.GuiAbstractWidget;
import su.plo.voice.api.client.PlasmoVoiceClient;
import su.plo.voice.api.client.audio.device.DeviceManager;
import su.plo.voice.api.client.audio.device.DeviceType;
import su.plo.voice.api.client.audio.device.OutputDevice;
import su.plo.voice.client.config.VoiceClientConfig;
import su.plo.voice.client.gui.settings.VoiceSettingsScreen;
import su.plo.voice.client.gui.settings.tab.TabWidget;
import su.plo.voice.client.gui.settings.widget.ToggleButton;

public final class AdvancedTabWidget
extends TabWidget {
    private static final List<MinecraftTextComponent> ICONS_LIST = ImmutableList.of((Object)MinecraftTextComponent.translatable("gui.plasmovoice.advanced.show_icons.hud", new Object[0]), (Object)MinecraftTextComponent.translatable("gui.plasmovoice.advanced.show_icons.always", new Object[0]), (Object)MinecraftTextComponent.translatable("gui.plasmovoice.advanced.show_icons.hidden", new Object[0]));
    private final DeviceManager devices;

    public AdvancedTabWidget(VoiceSettingsScreen parent, PlasmoVoiceClient voiceClient, VoiceClientConfig config) {
        super(parent, voiceClient, config);
        this.devices = voiceClient.getDeviceManager();
    }

    @Override
    public void init() {
        super.init();
        this.addEntry(new TabWidget.CategoryEntry(MinecraftTextComponent.translatable("gui.plasmovoice.advanced.visual", new Object[0])));
        this.addEntry(this.createToggleEntry(MinecraftTextComponent.translatable("gui.plasmovoice.advanced.visualize_voice_distance", new Object[0]), null, this.config.getAdvanced().getVisualizeVoiceDistance()));
        this.addEntry(this.createToggleEntry(MinecraftTextComponent.translatable("gui.plasmovoice.advanced.visualize_voice_distance_on_join", new Object[0]), null, this.config.getAdvanced().getVisualizeVoiceDistanceOnJoin()));
        this.addEntry(new TabWidget.CategoryEntry(MinecraftTextComponent.translatable("gui.plasmovoice.advanced.audio_engine", new Object[0])));
        this.addEntry(this.createIntSliderWidget(MinecraftTextComponent.translatable("gui.plasmovoice.advanced.directional_sources_angle", new Object[0]), MinecraftTextComponent.translatable("gui.plasmovoice.advanced.directional_sources_angle.tooltip", new Object[0]), this.config.getAdvanced().getDirectionalSourcesAngle(), ""));
        this.addEntry(this.createStereoToMonoSources());
        this.addEntry(this.createPanning());
        this.addEntry(new TabWidget.CategoryEntry(MinecraftTextComponent.translatable("gui.plasmovoice.advanced.exponential_volume", new Object[0])));
        this.addEntry(this.createToggleEntry(MinecraftTextComponent.translatable("gui.plasmovoice.advanced.exponential_volume.volume_slider", new Object[0]), null, this.config.getAdvanced().getExponentialVolumeSlider()));
        this.addEntry(this.createToggleEntry(MinecraftTextComponent.translatable("gui.plasmovoice.advanced.exponential_volume.distance_gain", new Object[0]), null, this.config.getAdvanced().getExponentialDistanceGain()));
    }

    private TabWidget.OptionEntry<ToggleButton> createStereoToMonoSources() {
        Runnable onUpdate = () -> this.devices.getDevices(DeviceType.OUTPUT).forEach(OutputDevice::closeSourcesAsync);
        ToggleButton toggleButton = new ToggleButton(this.config.getAdvanced().getStereoSourcesToMono(), 0, 0, 124, 20, toggled -> onUpdate.run());
        return new TabWidget.OptionEntry((TabWidget)this, (MinecraftTextComponent)MinecraftTextComponent.translatable("gui.plasmovoice.advanced.stereo_sources_to_mono", new Object[0]), (GuiAbstractWidget)toggleButton, (ConfigEntry)this.config.getAdvanced().getStereoSourcesToMono(), (MinecraftTextComponent)MinecraftTextComponent.translatable("gui.plasmovoice.advanced.stereo_sources_to_mono.tooltip", new Object[0]), (button, element) -> onUpdate.run());
    }

    private TabWidget.OptionEntry<ToggleButton> createPanning() {
        ToggleButton toggleButton = new ToggleButton(this.config.getAdvanced().getPanning(), 0, 0, 124, 20);
        return new TabWidget.OptionEntry((TabWidget)this, (MinecraftTextComponent)MinecraftTextComponent.translatable("gui.plasmovoice.advanced.panning", new Object[0]), (GuiAbstractWidget)toggleButton, (ConfigEntry)this.config.getAdvanced().getPanning());
    }
}

