/*
 * Decompiled with CFR 0.152.
 */
package su.plo.voice.proto.data.player;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.io.ByteArrayDataInput;
import com.google.common.io.ByteArrayDataOutput;
import java.io.IOException;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import org.jetbrains.annotations.Nullable;
import su.plo.voice.proto.packets.PacketSerializable;
import su.plo.voice.proto.packets.PacketUtil;

public class MinecraftGameProfile
implements PacketSerializable {
    private UUID id;
    private String name;
    private List<Property> properties;

    @Override
    public void deserialize(ByteArrayDataInput in) throws IOException {
        this.id = PacketUtil.readUUID(in);
        this.name = in.readUTF();
        int length = PacketUtil.readSafeInt(in, 0, 100);
        this.properties = Lists.newArrayList();
        for (int i = 0; i < length; ++i) {
            this.properties.add(new Property(in.readUTF(), in.readUTF(), in.readUTF()));
        }
    }

    @Override
    public void serialize(ByteArrayDataOutput out) throws IOException {
        PacketUtil.writeUUID(out, (UUID)Preconditions.checkNotNull((Object)this.id));
        out.writeUTF((String)Preconditions.checkNotNull((Object)this.name));
        out.writeInt(this.properties.size());
        for (Property property : this.properties) {
            out.writeUTF(property.getName());
            out.writeUTF(property.getValue());
            out.writeUTF(property.getSignature());
        }
    }

    public boolean equals(@Nullable Object object) {
        if (this == object) {
            return true;
        }
        if (object != null && this.getClass() == object.getClass()) {
            MinecraftGameProfile gameProfile = (MinecraftGameProfile)object;
            return this.id.equals(gameProfile.id) && Objects.equals(this.name, gameProfile.getName());
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.id, this.name);
    }

    public UUID getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public List<Property> getProperties() {
        return this.properties;
    }

    public void setId(UUID id) {
        this.id = id;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setProperties(List<Property> properties) {
        this.properties = properties;
    }

    public MinecraftGameProfile(UUID id, String name, List<Property> properties) {
        this.id = id;
        this.name = name;
        this.properties = properties;
    }

    public MinecraftGameProfile() {
    }

    public String toString() {
        return "MinecraftGameProfile(id=" + this.getId() + ", name=" + this.getName() + ", properties=" + this.getProperties() + ")";
    }

    public static final class Property {
        private final String name;
        private final String value;
        private final String signature;

        public String getName() {
            return this.name;
        }

        public String getValue() {
            return this.value;
        }

        public String getSignature() {
            return this.signature;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Property)) {
                return false;
            }
            Property other = (Property)o;
            String this$name = this.getName();
            String other$name = other.getName();
            if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
                return false;
            }
            String this$value = this.getValue();
            String other$value = other.getValue();
            if (this$value == null ? other$value != null : !this$value.equals(other$value)) {
                return false;
            }
            String this$signature = this.getSignature();
            String other$signature = other.getSignature();
            return !(this$signature == null ? other$signature != null : !this$signature.equals(other$signature));
        }

        public int hashCode() {
            int PRIME = 59;
            int result2 = 1;
            String $name = this.getName();
            result2 = result2 * 59 + ($name == null ? 43 : $name.hashCode());
            String $value = this.getValue();
            result2 = result2 * 59 + ($value == null ? 43 : $value.hashCode());
            String $signature = this.getSignature();
            result2 = result2 * 59 + ($signature == null ? 43 : $signature.hashCode());
            return result2;
        }

        public Property(String name, String value, String signature) {
            this.name = name;
            this.value = value;
            this.signature = signature;
        }

        public String toString() {
            return "MinecraftGameProfile.Property(name=" + this.getName() + ", value=" + this.getValue() + ", signature=" + this.getSignature() + ")";
        }
    }
}

