/*
 * Decompiled with CFR 0.152.
 */
package su.plo.voice.proto.packets.tcp.clientbound;

import com.google.common.io.ByteArrayDataInput;
import com.google.common.io.ByteArrayDataOutput;
import java.io.IOException;
import org.jetbrains.annotations.Nullable;
import su.plo.voice.proto.data.pos.Pos3d;
import su.plo.voice.proto.packets.Packet;
import su.plo.voice.proto.packets.tcp.clientbound.ClientPacketTcpHandler;

public final class DistanceVisualizePacket
implements Packet<ClientPacketTcpHandler> {
    private int radius;
    private int hexColor;
    @Nullable
    private Pos3d position;

    @Override
    public void read(ByteArrayDataInput in) throws IOException {
        this.radius = in.readInt();
        this.hexColor = in.readInt();
        if (in.readBoolean()) {
            this.position = new Pos3d();
            this.position.deserialize(in);
        }
    }

    @Override
    public void write(ByteArrayDataOutput out) throws IOException {
        out.writeInt(this.radius);
        out.writeInt(this.hexColor);
        out.writeBoolean(this.position != null);
        if (this.position != null) {
            this.position.serialize(out);
        }
    }

    @Override
    public void handle(ClientPacketTcpHandler handler) {
        handler.handle(this);
    }

    public DistanceVisualizePacket() {
    }

    public DistanceVisualizePacket(int radius, int hexColor, @Nullable Pos3d position) {
        this.radius = radius;
        this.hexColor = hexColor;
        this.position = position;
    }

    public String toString() {
        return "DistanceVisualizePacket(radius=" + this.getRadius() + ", hexColor=" + this.getHexColor() + ", position=" + this.getPosition() + ")";
    }

    public int getRadius() {
        return this.radius;
    }

    public int getHexColor() {
        return this.hexColor;
    }

    @Nullable
    public Pos3d getPosition() {
        return this.position;
    }
}

