/*
 * Decompiled with CFR 0.152.
 */
package su.plo.voice.server.audio.capture;

import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import su.plo.lib.api.server.permission.PermissionDefault;
import su.plo.lib.api.server.permission.PermissionTristate;
import su.plo.lib.api.server.permission.PermissionsManager;
import su.plo.voice.api.addon.AddonContainer;
import su.plo.voice.api.event.Event;
import su.plo.voice.api.event.EventPriority;
import su.plo.voice.api.event.EventSubscribe;
import su.plo.voice.api.server.PlasmoBaseVoiceServer;
import su.plo.voice.api.server.audio.capture.ServerActivation;
import su.plo.voice.api.server.audio.capture.ServerActivationManager;
import su.plo.voice.api.server.connection.ConnectionManager;
import su.plo.voice.api.server.event.audio.capture.ServerActivationRegisterEvent;
import su.plo.voice.api.server.event.audio.capture.ServerActivationUnregisterEvent;
import su.plo.voice.api.server.event.audio.source.PlayerSpeakEndEvent;
import su.plo.voice.api.server.event.audio.source.PlayerSpeakEvent;
import su.plo.voice.api.server.event.player.PlayerPermissionUpdateEvent;
import su.plo.voice.api.server.player.VoicePlayer;
import su.plo.voice.libs.kotlin.Metadata;
import su.plo.voice.libs.kotlin.collections.CollectionsKt;
import su.plo.voice.libs.kotlin.jvm.functions.Function1;
import su.plo.voice.libs.kotlin.jvm.internal.DefaultConstructorMarker;
import su.plo.voice.libs.kotlin.jvm.internal.Intrinsics;
import su.plo.voice.libs.kotlin.text.Regex;
import su.plo.voice.proto.data.audio.capture.Activation;
import su.plo.voice.proto.data.audio.capture.VoiceActivation;
import su.plo.voice.proto.data.audio.codec.CodecInfo;
import su.plo.voice.proto.packets.tcp.clientbound.ActivationRegisterPacket;
import su.plo.voice.proto.packets.tcp.clientbound.ActivationUnregisterPacket;
import su.plo.voice.proto.packets.tcp.clientbound.ClientPacketTcpHandler;
import su.plo.voice.proto.packets.tcp.serverbound.PlayerAudioEndPacket;
import su.plo.voice.proto.packets.udp.serverbound.PlayerAudioPacket;
import su.plo.voice.server.audio.capture.VoiceServerActivation;
import su.plo.voice.server.player.BaseVoicePlayer;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000~\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\b\n\u0002\u0010\u001f\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\u0018\u0000 -2\u00020\u0001:\u0002-.BN\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0014\u0010\u0004\u001a\u0010\u0012\u0004\u0012\u00020\u0006\u0012\u0006\b\u0001\u0012\u00020\u00070\u0005\u0012)\u0010\b\u001a%\u0012\u0013\u0012\u00110\n\u00a2\u0006\f\b\u000b\u0012\b\b\f\u0012\u0004\b\b(\r\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000f0\u000e\u0018\u00010\t\u00a2\u0006\u0002\u0010\u0010J\b\u0010\u0015\u001a\u00020\u0016H\u0016J8\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\f\u001a\u00020\n2\u0006\u0010\u001b\u001a\u00020\n2\u0006\u0010\u001c\u001a\u00020\n2\u0006\u0010\u001d\u001a\u00020\n2\u0006\u0010\u001e\u001a\u00020\u000fH\u0016J\u0016\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u00140\u000e2\u0006\u0010 \u001a\u00020\u0013H\u0016J\u0016\u0010!\u001a\b\u0012\u0004\u0012\u00020\u00140\u000e2\u0006\u0010\f\u001a\u00020\nH\u0016J\u000e\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u00140#H\u0016J\u0010\u0010$\u001a\u00020\u00162\u0006\u0010%\u001a\u00020&H\u0007J\u0010\u0010'\u001a\u00020\u00162\u0006\u0010%\u001a\u00020(H\u0007J\u0010\u0010)\u001a\u00020\u00162\u0006\u0010%\u001a\u00020*H\u0007J\u0010\u0010+\u001a\u00020,2\u0006\u0010 \u001a\u00020\u0013H\u0016R\u001a\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u00140\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0004\u001a\u0010\u0012\u0004\u0012\u00020\u0006\u0012\u0006\b\u0001\u0012\u00020\u00070\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R1\u0010\b\u001a%\u0012\u0013\u0012\u00110\n\u00a2\u0006\f\b\u000b\u0012\b\b\f\u0012\u0004\b\b(\r\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000f0\u000e\u0018\u00010\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006/"}, d2={"Lsu/plo/voice/server/audio/capture/VoiceServerActivationManager;", "Lsu/plo/voice/api/server/audio/capture/ServerActivationManager;", "voiceServer", "Lsu/plo/voice/api/server/PlasmoBaseVoiceServer;", "tcpConnections", "Lsu/plo/voice/api/server/connection/ConnectionManager;", "Lsu/plo/voice/proto/packets/tcp/clientbound/ClientPacketTcpHandler;", "Lsu/plo/voice/api/server/player/VoicePlayer;", "weightSupplier", "Lsu/plo/voice/libs/kotlin/Function1;", "", "Lsu/plo/voice/libs/kotlin/ParameterName;", "name", "activationName", "Ljava/util/Optional;", "", "(Lsu/plo/voice/api/server/PlasmoBaseVoiceServer;Lsu/plo/voice/api/server/connection/ConnectionManager;Lkotlin/jvm/functions/Function1;)V", "activationById", "", "Ljava/util/UUID;", "Lsu/plo/voice/api/server/audio/capture/ServerActivation;", "clear", "", "createBuilder", "Lsu/plo/voice/api/server/audio/capture/ServerActivation$Builder;", "addonObject", "", "translation", "icon", "permission", "weight", "getActivationById", "id", "getActivationByName", "getActivations", "", "onPermissionUpdate", "event", "Lsu/plo/voice/api/server/event/player/PlayerPermissionUpdateEvent;", "onPlayerSpeak", "Lsu/plo/voice/api/server/event/audio/source/PlayerSpeakEvent;", "onPlayerSpeakEnd", "Lsu/plo/voice/api/server/event/audio/source/PlayerSpeakEndEvent;", "unregister", "", "Companion", "VoiceServerActivationBuilder", "server-common"})
public final class VoiceServerActivationManager
implements ServerActivationManager {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final PlasmoBaseVoiceServer voiceServer;
    @NotNull
    private final ConnectionManager<ClientPacketTcpHandler, ? extends VoicePlayer> tcpConnections;
    @Nullable
    private final Function1<String, Optional<Integer>> weightSupplier;
    @NotNull
    private final Map<UUID, ServerActivation> activationById;
    @NotNull
    private static final String WILDCARD_ACTIVATION_PERMISSION = "pv.activation.*";

    public VoiceServerActivationManager(@NotNull PlasmoBaseVoiceServer voiceServer, @NotNull ConnectionManager<ClientPacketTcpHandler, ? extends VoicePlayer> tcpConnections, @Nullable Function1<? super String, Optional<Integer>> weightSupplier) {
        Intrinsics.checkNotNullParameter(voiceServer, "voiceServer");
        Intrinsics.checkNotNullParameter(tcpConnections, "tcpConnections");
        this.voiceServer = voiceServer;
        this.tcpConnections = tcpConnections;
        this.weightSupplier = weightSupplier;
        ConcurrentMap concurrentMap = Maps.newConcurrentMap();
        Intrinsics.checkNotNullExpressionValue(concurrentMap, "newConcurrentMap()");
        this.activationById = concurrentMap;
    }

    @Override
    @NotNull
    public Optional<ServerActivation> getActivationById(@NotNull UUID id) {
        Intrinsics.checkNotNullParameter(id, "id");
        Optional<ServerActivation> optional = Optional.ofNullable(this.activationById.get(id));
        Intrinsics.checkNotNullExpressionValue(optional, "ofNullable(activationById[id])");
        return optional;
    }

    @Override
    @NotNull
    public Optional<ServerActivation> getActivationByName(@NotNull String name) {
        Intrinsics.checkNotNullParameter(name, "name");
        Optional<ServerActivation> optional = Optional.ofNullable(this.activationById.get(VoiceActivation.generateId(name)));
        Intrinsics.checkNotNullExpressionValue(optional, "ofNullable(activationByI\u2026vation.generateId(name)])");
        return optional;
    }

    @Override
    @NotNull
    public Collection<ServerActivation> getActivations() {
        return this.activationById.values();
    }

    @Override
    @NotNull
    public ServerActivation.Builder createBuilder(@NotNull Object addonObject, @NotNull String name, @NotNull String translation, @NotNull String icon, @NotNull String permission, int weight) {
        int n;
        Intrinsics.checkNotNullParameter(addonObject, "addonObject");
        Intrinsics.checkNotNullParameter(name, "name");
        Intrinsics.checkNotNullParameter(translation, "translation");
        Intrinsics.checkNotNullParameter(icon, "icon");
        Intrinsics.checkNotNullParameter(permission, "permission");
        AddonContainer addon = this.voiceServer.getAddonManager().getAddon(addonObject).orElseThrow(VoiceServerActivationManager::createBuilder$lambda-0);
        if (this.activationById.containsKey(VoiceActivation.generateId(name))) {
            throw new IllegalArgumentException("Activation with name " + name + " already exists");
        }
        Intrinsics.checkNotNullExpressionValue(addon, "addon");
        Object[] objectArray = new String[]{permission};
        HashSet hashSet = Sets.newHashSet((Object[])objectArray);
        Intrinsics.checkNotNullExpressionValue(hashSet, "newHashSet<String>(permission)");
        Set set = hashSet;
        Function1<String, Optional<Integer>> function1 = this.weightSupplier;
        if (function1 == null) {
            n = weight;
        } else {
            Optional<Integer> optional = function1.invoke(name);
            if (optional == null) {
                n = weight;
            } else {
                Integer n2 = optional.orElse(null);
                n = n2 == null ? weight : n2;
            }
        }
        return new VoiceServerActivationBuilder(addon, name, translation, icon, set, n);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean unregister(@NotNull UUID id) {
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter(id, "id");
        ServerActivation serverActivation = this.activationById.get(id);
        if (serverActivation == null) {
            return false;
        }
        ServerActivation activation = serverActivation;
        Object object = new ServerActivationUnregisterEvent(activation);
        ServerActivationUnregisterEvent event = object;
        boolean $i$a$-also-VoiceServerActivationManager$unregister$232 = false;
        if (!this.voiceServer.getEventBus().call((Event)event)) {
            return false;
        }
        object = activation.getPermissions();
        Intrinsics.checkNotNullExpressionValue(object, "activation.permissions");
        Iterable<Object> $this$forEach$iv = (Collection<?>)object;
        boolean $i$f$forEach = false;
        for (Object t : $this$forEach$iv) {
            String permission = (String)t;
            boolean bl = false;
            this.voiceServer.getMinecraftServer().getPermissionsManager().unregister(permission);
        }
        this.activationById.remove(id);
        $this$forEach$iv = this.voiceServer.getPlayerManager().getPlayers();
        Intrinsics.checkNotNullExpressionValue($this$forEach$iv, "voiceServer.playerManager.players");
        Iterable $this$filter$iv = $this$forEach$iv;
        boolean $i$f$filter = false;
        Iterable $i$a$-also-VoiceServerActivationManager$unregister$232 = $this$filter$iv;
        Collection collection = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            VoicePlayer it = (VoicePlayer)element$iv$iv;
            boolean bl = false;
            if (!it.hasVoiceChat()) continue;
            collection.add(element$iv$iv);
        }
        $this$forEach$iv = (List)collection;
        $i$f$forEach = false;
        for (Object object2 : $this$forEach$iv) {
            VoicePlayer it = (VoicePlayer)object2;
            boolean bl = false;
            VoicePlayer voicePlayer = it;
            if (voicePlayer == null) {
                throw new NullPointerException("null cannot be cast to non-null type su.plo.voice.server.player.BaseVoicePlayer<*>");
            }
            BaseVoicePlayer player = (BaseVoicePlayer)voicePlayer;
            player.removeActivationDistance(activation);
            player.getActiveActivations().remove(activation);
        }
        this.tcpConnections.broadcast(new ActivationUnregisterPacket(activation.getId()), arg_0 -> VoiceServerActivationManager.unregister$lambda-5(activation, arg_0));
        return true;
    }

    @Override
    public void clear() {
        Iterable $this$forEach$iv = this.activationById.values();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ServerActivation p0 = (ServerActivation)element$iv;
            boolean bl = false;
            this.unregister((Activation)p0);
        }
        this.activationById.clear();
    }

    @EventSubscribe(priority=EventPriority.LOWEST)
    public final void onPlayerSpeak(@NotNull PlayerSpeakEvent event) {
        Intrinsics.checkNotNullParameter(event, "event");
        VoicePlayer voicePlayer = event.getPlayer();
        if (voicePlayer == null) {
            throw new NullPointerException("null cannot be cast to non-null type su.plo.voice.server.player.BaseVoicePlayer<*>");
        }
        BaseVoicePlayer player = (BaseVoicePlayer)voicePlayer;
        PlayerAudioPacket packet = event.getPacket();
        UUID uUID = packet.getActivationId();
        Intrinsics.checkNotNullExpressionValue(uUID, "packet.activationId");
        VoiceServerActivation voiceServerActivation = this.getActivationById(uUID).orElse(null);
        if (voiceServerActivation == null) {
            return;
        }
        Object activation = voiceServerActivation;
        if (!activation.checkPermissions(player)) {
            return;
        }
        if (!((VoiceServerActivation)activation).checkDistance(packet.getDistance())) {
            return;
        }
        ServerActivation.Requirements requirements = ((VoiceServerActivation)activation).getRequirements();
        if (requirements == null ? false : !requirements.checkRequirements((VoicePlayer)player, packet)) {
            return;
        }
        if (!player.getActiveActivations().contains(activation)) {
            player.getActiveActivations().add(activation);
            Iterable $this$forEach$iv = ((VoiceServerActivation)activation).getActivationStartListeners();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                ServerActivation.PlayerActivationStartListener it = (ServerActivation.PlayerActivationStartListener)element$iv;
                boolean bl = false;
                it.onActivationStart(player);
            }
        }
        for (ServerActivation.PlayerActivationListener listener : ((VoiceServerActivation)activation).getActivationListeners()) {
            ServerActivation.Result result2 = listener.onActivation(player, packet);
            Intrinsics.checkNotNullExpressionValue((Object)result2, "listener.onActivation(player, packet)");
            ServerActivation.Result result3 = result2;
            if (result3 != ServerActivation.Result.HANDLED) continue;
            event.setResult(result3);
            event.setCancelled(true);
            break;
        }
    }

    @EventSubscribe(priority=EventPriority.LOWEST)
    public final void onPlayerSpeakEnd(@NotNull PlayerSpeakEndEvent event) {
        Intrinsics.checkNotNullParameter(event, "event");
        VoicePlayer voicePlayer = event.getPlayer();
        if (voicePlayer == null) {
            throw new NullPointerException("null cannot be cast to non-null type su.plo.voice.server.player.BaseVoicePlayer<*>");
        }
        BaseVoicePlayer player = (BaseVoicePlayer)voicePlayer;
        PlayerAudioEndPacket packet = event.getPacket();
        UUID uUID = packet.getActivationId();
        Intrinsics.checkNotNullExpressionValue(uUID, "packet.activationId");
        VoiceServerActivation voiceServerActivation = this.getActivationById(uUID).orElse(null);
        if (voiceServerActivation == null) {
            return;
        }
        VoiceServerActivation activation = voiceServerActivation;
        if (!player.getActiveActivations().contains(activation)) {
            return;
        }
        if (!activation.checkPermissions(player)) {
            return;
        }
        if (!activation.checkDistance(packet.getDistance())) {
            return;
        }
        ServerActivation.Requirements requirements = activation.getRequirements();
        if (requirements == null ? false : !requirements.checkRequirements((VoicePlayer)player, packet)) {
            return;
        }
        player.getActiveActivations().remove(activation);
        for (ServerActivation.PlayerActivationEndListener listener : activation.getActivationEndListeners()) {
            ServerActivation.Result result2 = listener.onActivationEnd(player, packet);
            Intrinsics.checkNotNullExpressionValue((Object)result2, "listener.onActivationEnd(player, packet)");
            ServerActivation.Result result3 = result2;
            if (result3 != ServerActivation.Result.HANDLED) continue;
            event.setResult(result3);
            event.setCancelled(true);
            break;
        }
    }

    /*
     * WARNING - void declaration
     */
    @EventSubscribe
    public final void onPermissionUpdate(@NotNull PlayerPermissionUpdateEvent event) {
        void $this$toTypedArray$iv;
        List list;
        Collection $this$dropLastWhile$iv;
        Object $this$forEach$iv;
        Object it;
        boolean bl;
        String permission;
        VoicePlayer player;
        block21: {
            Intrinsics.checkNotNullParameter(event, "event");
            player = event.getPlayer();
            permission = event.getPermission();
            Iterable $this$none$iv = this.activationById.values();
            boolean $i$f$none = false;
            if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$none$iv) {
                    it = (ServerActivation)element$iv;
                    boolean bl2 = false;
                    if (!it.getPermissions().contains(permission)) continue;
                    bl = false;
                    break block21;
                }
                bl = true;
            }
        }
        if (bl) {
            return;
        }
        if (Intrinsics.areEqual(permission, WILDCARD_ACTIVATION_PERMISSION)) {
            switch (WhenMappings.$EnumSwitchMapping$0[player.getInstance().getPermission(WILDCARD_ACTIVATION_PERMISSION).ordinal()]) {
                case 1: {
                    $this$forEach$iv = this.activationById.values();
                    boolean $i$f$forEach = false;
                    it = $this$forEach$iv.iterator();
                    while (it.hasNext()) {
                        Object element$iv = it.next();
                        ServerActivation it2 = (ServerActivation)element$iv;
                        boolean bl3 = false;
                        player.sendPacket(new ActivationRegisterPacket((VoiceActivation)((Object)it2)));
                    }
                    break;
                }
                case 2: {
                    $this$forEach$iv = this.activationById.keySet();
                    boolean $i$f$forEach = false;
                    it = $this$forEach$iv.iterator();
                    while (it.hasNext()) {
                        Object element$iv = it.next();
                        UUID it3 = (UUID)element$iv;
                        boolean bl4 = false;
                        player.sendPacket(new ActivationUnregisterPacket(it3));
                    }
                    break;
                }
                case 3: {
                    $this$forEach$iv = this.activationById;
                    boolean $i$f$forEach = false;
                    it = $this$forEach$iv.entrySet().iterator();
                    while (it.hasNext()) {
                        Map.Entry element$iv;
                        Map.Entry $dstr$activationId$activation = element$iv = (Map.Entry)it.next();
                        boolean bl5 = false;
                        UUID activationId = (UUID)$dstr$activationId$activation.getKey();
                        ServerActivation activation = (ServerActivation)$dstr$activationId$activation.getValue();
                        if (activation.checkPermissions(player)) {
                            player.sendPacket(new ActivationRegisterPacket((VoiceActivation)((Object)activation)));
                            continue;
                        }
                        player.sendPacket(new ActivationUnregisterPacket(activationId));
                    }
                    break;
                }
            }
            return;
        }
        Intrinsics.checkNotNullExpressionValue(permission, "permission");
        Object $i$f$none = permission;
        $this$forEach$iv = new Regex("\\.");
        int $i$f$forEach = 0;
        $i$f$none = ((Regex)$this$forEach$iv).split((CharSequence)$i$f$none, $i$f$forEach);
        boolean $i$f$dropLastWhile = false;
        if (!$this$dropLastWhile$iv.isEmpty()) {
            ListIterator iterator$iv = $this$dropLastWhile$iv.listIterator($this$dropLastWhile$iv.size());
            while (iterator$iv.hasPrevious()) {
                it = (String)iterator$iv.previous();
                boolean bl6 = false;
                if (((CharSequence)it).length() == 0) continue;
                list = CollectionsKt.take($this$dropLastWhile$iv, iterator$iv.nextIndex() + 1);
                break;
            }
        } else {
            list = CollectionsKt.emptyList();
        }
        $this$dropLastWhile$iv = list;
        boolean $i$f$toTypedArray = false;
        void thisCollection$iv = $this$toTypedArray$iv;
        String[] stringArray = thisCollection$iv.toArray(new String[0]);
        if (stringArray == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T of kotlin.collections.ArraysKt__ArraysJVMKt.toTypedArray>");
        }
        String[] permissionSplit = stringArray;
        ServerActivation serverActivation = this.getActivationByName(permissionSplit[permissionSplit.length - 1]).orElse(null);
        if (serverActivation == null) {
            return;
        }
        ServerActivation activation = serverActivation;
        if (activation.checkPermissions(player)) {
            player.sendPacket(new ActivationRegisterPacket((VoiceActivation)((Object)activation)));
        } else {
            player.sendPacket(new ActivationUnregisterPacket(activation.getId()));
        }
    }

    private static final IllegalArgumentException createBuilder$lambda-0() {
        return new IllegalArgumentException("addonObject is not an addon");
    }

    private static final boolean unregister$lambda-5(ServerActivation $activation, VoicePlayer it) {
        Intrinsics.checkNotNullParameter($activation, "$activation");
        return $activation.checkPermissions(it);
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010#\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\t\b\u0086\u0004\u0018\u00002\u00020\u0001B;\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\u0005\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00050\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fJ\u0014\u0010$\u001a\u00060\u0000R\u00020%2\u0006\u0010&\u001a\u00020\u0005H\u0016J\b\u0010'\u001a\u00020(H\u0016J\u0014\u0010)\u001a\u00060\u0000R\u00020%2\u0006\u0010\u000f\u001a\u00020\u000bH\u0016J\u001a\u0010*\u001a\u00060\u0000R\u00020%2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u000b0\u0011H\u0016J\u0016\u0010+\u001a\u00060\u0000R\u00020%2\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013H\u0016J\u0016\u0010,\u001a\u00060\u0000R\u00020%2\b\u0010\u0017\u001a\u0004\u0018\u00010\u0018H\u0016J\u0014\u0010-\u001a\u00060\u0000R\u00020%2\u0006\u0010\u001b\u001a\u00020\u001cH\u0016J\u0016\u0010.\u001a\u00060\u0000R\u00020%2\b\u0010\u001d\u001a\u0004\u0018\u00010\u001eH\u0016J\u0014\u0010/\u001a\u00060\u0000R\u00020%2\u0006\u0010\u001f\u001a\u00020\u001cH\u0016J\u0014\u00100\u001a\u00060\u0000R\u00020%2\u0006\u0010 \u001a\u00020\u001cH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u000e\u0010\u000f\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u000b0\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0012\u001a\u0004\u0018\u00010\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0007\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0015R\u0010\u0010\u0017\u001a\u0004\u0018\u00010\u0018X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0017\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00050\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u000e\u0010\u001b\u001a\u00020\u001cX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001d\u001a\u0004\u0018\u00010\u001eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001f\u001a\u00020\u001cX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010 \u001a\u00020\u001cX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\u0015R\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010#\u00a8\u00061"}, d2={"Lsu/plo/voice/server/audio/capture/VoiceServerActivationManager$VoiceServerActivationBuilder;", "Lsu/plo/voice/api/server/audio/capture/ServerActivation$Builder;", "addon", "Lsu/plo/voice/api/addon/AddonContainer;", "name", "", "translation", "icon", "permissions", "", "weight", "", "(Lsu/plo/voice/server/audio/capture/VoiceServerActivationManager;Lsu/plo/voice/api/addon/AddonContainer;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/util/Set;I)V", "getAddon", "()Lsu/plo/voice/api/addon/AddonContainer;", "defaultDistance", "distances", "", "encoderInfo", "Lsu/plo/voice/proto/data/audio/codec/CodecInfo;", "getIcon", "()Ljava/lang/String;", "getName", "permissionDefault", "Lsu/plo/lib/api/server/permission/PermissionDefault;", "getPermissions", "()Ljava/util/Set;", "proximity", "", "requirements", "Lsu/plo/voice/api/server/audio/capture/ServerActivation$Requirements;", "stereoSupported", "transitive", "getTranslation", "getWeight", "()I", "addPermission", "Lsu/plo/voice/server/audio/capture/VoiceServerActivationManager;", "permission", "build", "Lsu/plo/voice/api/server/audio/capture/ServerActivation;", "setDefaultDistance", "setDistances", "setEncoderInfo", "setPermissionDefault", "setProximity", "setRequirements", "setStereoSupported", "setTransitive", "server-common"})
    public final class VoiceServerActivationBuilder
    implements ServerActivation.Builder {
        @NotNull
        private final AddonContainer addon;
        @NotNull
        private final String name;
        @NotNull
        private final String translation;
        @NotNull
        private final String icon;
        @NotNull
        private final Set<String> permissions;
        private final int weight;
        @NotNull
        private List<Integer> distances;
        private int defaultDistance;
        private boolean transitive;
        private boolean proximity;
        private boolean stereoSupported;
        @Nullable
        private PermissionDefault permissionDefault;
        @Nullable
        private CodecInfo encoderInfo;
        @Nullable
        private ServerActivation.Requirements requirements;

        public VoiceServerActivationBuilder(@NotNull AddonContainer addon, @NotNull String name, @NotNull String translation, @NotNull String icon, Set<String> permissions, int weight) {
            Intrinsics.checkNotNullParameter(VoiceServerActivationManager.this, "this$0");
            Intrinsics.checkNotNullParameter(addon, "addon");
            Intrinsics.checkNotNullParameter(name, "name");
            Intrinsics.checkNotNullParameter(translation, "translation");
            Intrinsics.checkNotNullParameter(icon, "icon");
            Intrinsics.checkNotNullParameter(permissions, "permissions");
            this.addon = addon;
            this.name = name;
            this.translation = translation;
            this.icon = icon;
            this.permissions = permissions;
            this.weight = weight;
            this.distances = CollectionsKt.emptyList();
            this.transitive = true;
            this.proximity = true;
        }

        @NotNull
        public final AddonContainer getAddon() {
            return this.addon;
        }

        @NotNull
        public final String getName() {
            return this.name;
        }

        @NotNull
        public final String getTranslation() {
            return this.translation;
        }

        @NotNull
        public final String getIcon() {
            return this.icon;
        }

        @NotNull
        public final Set<String> getPermissions() {
            return this.permissions;
        }

        public final int getWeight() {
            return this.weight;
        }

        @Override
        @NotNull
        public VoiceServerActivationBuilder addPermission(@NotNull String permission) {
            VoiceServerActivationBuilder voiceServerActivationBuilder;
            Intrinsics.checkNotNullParameter(permission, "permission");
            VoiceServerActivationBuilder $this$addPermission_u24lambda_u2d0 = voiceServerActivationBuilder = this;
            boolean bl = false;
            $this$addPermission_u24lambda_u2d0.getPermissions().add(permission);
            return voiceServerActivationBuilder;
        }

        @Override
        @NotNull
        public VoiceServerActivationBuilder setPermissionDefault(@Nullable PermissionDefault permissionDefault) {
            VoiceServerActivationBuilder voiceServerActivationBuilder;
            VoiceServerActivationBuilder $this$setPermissionDefault_u24lambda_u2d1 = voiceServerActivationBuilder = this;
            boolean bl = false;
            $this$setPermissionDefault_u24lambda_u2d1.permissionDefault = permissionDefault;
            return voiceServerActivationBuilder;
        }

        @Override
        @NotNull
        public VoiceServerActivationBuilder setRequirements(@Nullable ServerActivation.Requirements requirements) {
            VoiceServerActivationBuilder voiceServerActivationBuilder;
            VoiceServerActivationBuilder $this$setRequirements_u24lambda_u2d2 = voiceServerActivationBuilder = this;
            boolean bl = false;
            $this$setRequirements_u24lambda_u2d2.requirements = requirements;
            return voiceServerActivationBuilder;
        }

        @Override
        @NotNull
        public VoiceServerActivationBuilder setDistances(@NotNull List<Integer> distances) {
            VoiceServerActivationBuilder voiceServerActivationBuilder;
            Intrinsics.checkNotNullParameter(distances, "distances");
            VoiceServerActivationBuilder $this$setDistances_u24lambda_u2d3 = voiceServerActivationBuilder = this;
            boolean bl = false;
            Object object = Preconditions.checkNotNull(distances);
            Intrinsics.checkNotNullExpressionValue(object, "checkNotNull(distances)");
            $this$setDistances_u24lambda_u2d3.distances = (List)object;
            return voiceServerActivationBuilder;
        }

        @Override
        @NotNull
        public VoiceServerActivationBuilder setDefaultDistance(int defaultDistance) {
            VoiceServerActivationBuilder voiceServerActivationBuilder;
            VoiceServerActivationBuilder $this$setDefaultDistance_u24lambda_u2d4 = voiceServerActivationBuilder = this;
            boolean bl = false;
            $this$setDefaultDistance_u24lambda_u2d4.defaultDistance = defaultDistance;
            return voiceServerActivationBuilder;
        }

        @Override
        @NotNull
        public VoiceServerActivationBuilder setTransitive(boolean transitive) {
            VoiceServerActivationBuilder voiceServerActivationBuilder;
            VoiceServerActivationBuilder $this$setTransitive_u24lambda_u2d5 = voiceServerActivationBuilder = this;
            boolean bl = false;
            $this$setTransitive_u24lambda_u2d5.transitive = transitive;
            return voiceServerActivationBuilder;
        }

        @Override
        @NotNull
        public VoiceServerActivationBuilder setProximity(boolean proximity) {
            VoiceServerActivationBuilder voiceServerActivationBuilder;
            VoiceServerActivationBuilder $this$setProximity_u24lambda_u2d6 = voiceServerActivationBuilder = this;
            boolean bl = false;
            $this$setProximity_u24lambda_u2d6.proximity = proximity;
            return voiceServerActivationBuilder;
        }

        @Override
        @NotNull
        public VoiceServerActivationBuilder setStereoSupported(boolean stereoSupported) {
            VoiceServerActivationBuilder voiceServerActivationBuilder;
            VoiceServerActivationBuilder $this$setStereoSupported_u24lambda_u2d7 = voiceServerActivationBuilder = this;
            boolean bl = false;
            $this$setStereoSupported_u24lambda_u2d7.stereoSupported = stereoSupported;
            return voiceServerActivationBuilder;
        }

        @Override
        @NotNull
        public VoiceServerActivationBuilder setEncoderInfo(@Nullable CodecInfo encoderInfo) {
            VoiceServerActivationBuilder voiceServerActivationBuilder;
            VoiceServerActivationBuilder $this$setEncoderInfo_u24lambda_u2d8 = voiceServerActivationBuilder = this;
            boolean bl = false;
            $this$setEncoderInfo_u24lambda_u2d8.encoderInfo = encoderInfo;
            return voiceServerActivationBuilder;
        }

        @Override
        @NotNull
        public ServerActivation build() {
            if (!(VoiceServerActivationManager.this.activationById.get(VoiceActivation.generateId(this.name)) == null)) {
                boolean bl = false;
                String string = "Activation with name " + this.getName() + " already exists";
                throw new IllegalStateException(string.toString());
            }
            VoiceServerActivation activation = new VoiceServerActivation(this.addon, this.name, this.translation, this.icon, this.permissions, this.distances, this.defaultDistance, this.proximity, this.transitive, this.stereoSupported, this.encoderInfo, this.weight, this.requirements);
            if (this.permissionDefault != null) {
                this.permissions.forEach(arg_0 -> VoiceServerActivationBuilder.build$lambda-10(VoiceServerActivationManager.this, this, arg_0));
            }
            Object object = new ServerActivationRegisterEvent(activation);
            Object object2 = VoiceServerActivationManager.this;
            ServerActivationRegisterEvent event = object;
            boolean bl = false;
            if (!((VoiceServerActivationManager)object2).voiceServer.getEventBus().call((Event)event)) {
                boolean bl2 = false;
                String string = "Activation registration was cancelled";
                throw new IllegalStateException(string.toString());
            }
            object = VoiceServerActivationManager.this.activationById;
            object2 = activation.getId();
            Intrinsics.checkNotNullExpressionValue(object2, "activation.id");
            object.put(object2, activation);
            VoiceServerActivationManager.this.tcpConnections.broadcast(new ActivationRegisterPacket(activation), arg_0 -> VoiceServerActivationBuilder.build$lambda-13(activation, arg_0));
            return activation;
        }

        private static final void build$lambda-10(VoiceServerActivationManager this$0, VoiceServerActivationBuilder this$1, String permission) {
            Intrinsics.checkNotNullParameter(this$0, "this$0");
            Intrinsics.checkNotNullParameter(this$1, "this$1");
            PermissionsManager permissionsManager = this$0.voiceServer.getMinecraftServer().getPermissionsManager();
            String string = permission;
            Intrinsics.checkNotNull(string);
            PermissionDefault permissionDefault = this$1.permissionDefault;
            Intrinsics.checkNotNull((Object)permissionDefault);
            permissionsManager.register(string, permissionDefault);
        }

        private static final boolean build$lambda-13(VoiceServerActivation $activation, VoicePlayer it) {
            Intrinsics.checkNotNullParameter($activation, "$activation");
            return $activation.checkPermissions(it);
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lsu/plo/voice/server/audio/capture/VoiceServerActivationManager$Companion;", "", "()V", "WILDCARD_ACTIVATION_PERMISSION", "", "server-common"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 6, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[PermissionTristate.values().length];
            nArray[PermissionTristate.TRUE.ordinal()] = 1;
            nArray[PermissionTristate.FALSE.ordinal()] = 2;
            nArray[PermissionTristate.UNDEFINED.ordinal()] = 3;
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

