/*
 * Decompiled with CFR 0.152.
 */
package su.plo.voice.server.audio.line;

import org.jetbrains.annotations.NotNull;
import su.plo.voice.api.addon.AddonContainer;
import su.plo.voice.api.server.PlasmoBaseVoiceServer;
import su.plo.voice.api.server.PlasmoVoiceServer;
import su.plo.voice.api.server.audio.line.ServerSourceLine;
import su.plo.voice.api.server.audio.line.ServerSourceLineManager;
import su.plo.voice.api.server.connection.TcpServerConnectionManager;
import su.plo.voice.libs.kotlin.Metadata;
import su.plo.voice.libs.kotlin.jvm.internal.Intrinsics;
import su.plo.voice.server.audio.line.VoiceBaseServerSourceLineManager;
import su.plo.voice.server.audio.line.VoiceServerSourceLine;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0006\n\u0000\u0018\u00002\u00020\u00012\b\u0012\u0004\u0012\u00020\u00030\u0002B\r\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J@\u0010\u0007\u001a\u00020\u00032\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0014R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lsu/plo/voice/server/audio/line/VoiceServerSourceLineManager;", "Lsu/plo/voice/api/server/audio/line/ServerSourceLineManager;", "Lsu/plo/voice/server/audio/line/VoiceBaseServerSourceLineManager;", "Lsu/plo/voice/api/server/audio/line/ServerSourceLine;", "voiceServer", "Lsu/plo/voice/api/server/PlasmoVoiceServer;", "(Lsu/plo/voice/api/server/PlasmoVoiceServer;)V", "createSourceLine", "addon", "Lsu/plo/voice/api/addon/AddonContainer;", "name", "", "translation", "icon", "weight", "", "withPlayers", "", "defaultVolume", "", "common"})
public final class VoiceServerSourceLineManager
extends VoiceBaseServerSourceLineManager<ServerSourceLine>
implements ServerSourceLineManager {
    @NotNull
    private final PlasmoVoiceServer voiceServer;

    public VoiceServerSourceLineManager(@NotNull PlasmoVoiceServer voiceServer) {
        Intrinsics.checkNotNullParameter(voiceServer, "voiceServer");
        PlasmoBaseVoiceServer plasmoBaseVoiceServer = voiceServer;
        TcpServerConnectionManager tcpServerConnectionManager = voiceServer.getTcpConnectionManager();
        Intrinsics.checkNotNullExpressionValue(tcpServerConnectionManager, "voiceServer.tcpConnectionManager");
        super(plasmoBaseVoiceServer, tcpServerConnectionManager);
        this.voiceServer = voiceServer;
    }

    @Override
    @NotNull
    protected ServerSourceLine createSourceLine(@NotNull AddonContainer addon, @NotNull String name, @NotNull String translation, @NotNull String icon, int weight, boolean withPlayers, double defaultVolume) {
        Intrinsics.checkNotNullParameter(addon, "addon");
        Intrinsics.checkNotNullParameter(name, "name");
        Intrinsics.checkNotNullParameter(translation, "translation");
        Intrinsics.checkNotNullParameter(icon, "icon");
        Integer n = this.voiceServer.getConfig().voice().weights().getSourceLineWeight(name).orElse(weight);
        Intrinsics.checkNotNullExpressionValue(n, "voiceServer.config.voice\u2026          .orElse(weight)");
        return new VoiceServerSourceLine(this.voiceServer, addon, name, translation, icon, defaultVolume, ((Number)n).intValue(), withPlayers);
    }
}

