/*
 * Decompiled with CFR 0.152.
 */
package su.plo.voice.server.connection;

import com.google.common.io.ByteStreams;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;
import java.io.IOException;
import java.util.List;
import java.util.stream.Collectors;
import net.fabricmc.fabric.api.networking.v1.PacketSender;
import net.fabricmc.fabric.api.networking.v1.S2CPlayChannelEvents;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3244;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.NotNull;
import su.plo.lib.mod.server.entity.ModServerPlayer;
import su.plo.voice.api.server.player.VoiceServerPlayer;
import su.plo.voice.proto.packets.Packet;
import su.plo.voice.proto.packets.PacketHandler;
import su.plo.voice.proto.packets.tcp.PacketTcpCodec;
import su.plo.voice.server.BaseVoiceServer;
import su.plo.voice.server.connection.BaseServerChannelHandler;
import su.plo.voice.server.connection.PlayerChannelHandler;

public final class ModServerChannelHandler
extends BaseServerChannelHandler
implements ServerPlayNetworking.PlayChannelHandler,
S2CPlayChannelEvents.Register {
    public static ModServerChannelHandler INSTANCE;

    public ModServerChannelHandler(@NotNull BaseVoiceServer voiceServer) {
        super(voiceServer);
        INSTANCE = this;
    }

    @Override
    protected void handleRegisterChannels(List<String> channels, VoiceServerPlayer player) {
        super.handleRegisterChannels(channels, player);
        channels.forEach(channel -> ((ModServerPlayer)player.getInstance()).addChannel((String)channel));
    }

    private void receive(class_3222 player, class_2540 buf) {
        byte[] data = ByteBufUtil.getBytes((ByteBuf)buf.duplicate());
        try {
            PacketTcpCodec.decode(ByteStreams.newDataInput((byte[])data)).ifPresent(packet -> {
                VoiceServerPlayer voicePlayer = this.voiceServer.getPlayerManager().wrap(player);
                PlayerChannelHandler channel = this.channels.computeIfAbsent(player.method_5667(), playerId -> new PlayerChannelHandler(this.voiceServer, voicePlayer));
                channel.handlePacket((Packet<PacketHandler>)packet);
            });
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void receive(MinecraftServer server, class_3222 player, class_3244 handler, class_2540 buf, PacketSender responseSender) {
        this.receive(player, buf);
    }

    public void onChannelRegister(class_3244 handler, PacketSender sender, MinecraftServer server, List<class_2960> channels) {
        this.voiceServer.getPlayerManager().getPlayerById(handler.method_32311().method_5667()).ifPresent(player -> this.handleRegisterChannels(channels.stream().map(class_2960::toString).collect(Collectors.toList()), (VoiceServerPlayer)player));
    }
}

