/*
 * Decompiled with CFR 0.152.
 */
package su.plo.voice.server.mute.storage.file;

import com.google.common.collect.Maps;
import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.Reader;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.ExecutorService;
import org.jetbrains.annotations.NotNull;
import su.plo.voice.BaseVoice;
import su.plo.voice.api.server.mute.ServerMuteInfo;
import su.plo.voice.api.server.mute.storage.MuteStorage;
import su.plo.voice.server.mute.VoiceMuteManager;

public final class JsonMuteStorage
implements MuteStorage {
    private static final Gson GSON = new Gson();
    private static final Type MUTE_MAP_TYPE = new TypeToken<Map<UUID, ServerMuteInfo>>(){}.getType();
    private final Map<UUID, ServerMuteInfo> muteByPlayerId = Maps.newConcurrentMap();
    private final ExecutorService executor;
    private final File file;

    @Override
    public void init() throws Exception {
        if (!this.file.exists()) {
            return;
        }
        BufferedReader bufferedReader = new BufferedReader(new FileReader(this.file));
        Map data = (Map)GSON.fromJson((Reader)bufferedReader, MUTE_MAP_TYPE);
        if (data == null) {
            return;
        }
        data.forEach((playerId, muteInfo) -> {
            if (VoiceMuteManager.isMuteValid(muteInfo)) {
                this.muteByPlayerId.put((UUID)playerId, (ServerMuteInfo)muteInfo);
            }
        });
        if (data.size() != this.muteByPlayerId.size()) {
            this.saveAsync();
        }
    }

    @Override
    public void close() throws Exception {
        this.save();
        this.executor.shutdown();
        this.muteByPlayerId.clear();
    }

    @Override
    public void putPlayerMute(@NotNull UUID playerId, @NotNull ServerMuteInfo muteInfo) {
        if (VoiceMuteManager.isMuteValid(muteInfo)) {
            this.muteByPlayerId.put(playerId, muteInfo);
            this.saveAsync();
        }
    }

    @Override
    public Optional<ServerMuteInfo> getMuteByPlayerId(@NotNull UUID playerId) {
        return Optional.ofNullable(this.muteByPlayerId.get(playerId));
    }

    @Override
    public Optional<ServerMuteInfo> removeMuteByPlayerId(@NotNull UUID playerId) {
        ServerMuteInfo muteInfo = this.muteByPlayerId.remove(playerId);
        if (muteInfo != null) {
            this.saveAsync();
        }
        return Optional.ofNullable(muteInfo);
    }

    @Override
    public Collection<ServerMuteInfo> getMutedPlayers() {
        return this.muteByPlayerId.values();
    }

    private void saveAsync() {
        this.executor.execute(() -> {
            try {
                this.save();
            }
            catch (Exception e) {
                BaseVoice.LOGGER.error("Failed to save json mute storage: {}", (Object)e.toString());
                e.printStackTrace();
            }
        });
    }

    private void save() throws Exception {
        this.muteByPlayerId.values().stream().filter(muteInfo -> !VoiceMuteManager.isMuteValid(muteInfo)).forEach(muteInfo -> this.muteByPlayerId.remove(muteInfo.getPlayerUUID()));
        try (FileWriter w = new FileWriter(this.file);){
            w.write(GSON.toJson(this.muteByPlayerId));
        }
    }

    public JsonMuteStorage(ExecutorService executor, File file) {
        this.executor = executor;
        this.file = file;
    }
}

