/*
 * Decompiled with CFR 0.152.
 */
package traben.entity_model_features.models.animation;

import it.unimi.dsi.fastutil.objects.Object2FloatOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectLinkedOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.UUID;
import traben.entity_model_features.config.EMFConfig;
import traben.entity_model_features.models.EMFModelPart;
import traben.entity_model_features.models.animation.EMFAnimationEntityContext;
import traben.entity_model_features.models.animation.math.MathComponent;
import traben.entity_model_features.models.animation.math.MathExpressionParser;
import traben.entity_model_features.models.animation.math.variables.EMFModelOrRenderVariable;
import traben.entity_model_features.utils.EMFUtils;

public class EMFAnimation {
    public final String animKey;
    public final String expressionString;
    public final String modelName;
    public final boolean isVariable;
    private final EMFModelPart partToApplyTo;
    private final EMFModelOrRenderVariable variableToChange;
    private final Object2FloatOpenHashMap<UUID> prevResult = new Object2FloatOpenHashMap();
    private final Object2IntOpenHashMap<UUID> lodTimer = new Object2IntOpenHashMap();
    public Object2ObjectLinkedOpenHashMap<String, EMFAnimation> emfAnimationVariables = null;
    public Object2ObjectOpenHashMap<String, EMFModelPart> allPartsBySingleAndFullHeirachicalId = null;
    private MathComponent EMFCalculator = MathExpressionParser.NULL_EXPRESSION;
    private EMFAnimation trueVariableToSet = null;

    public EMFAnimation(EMFModelPart partToApplyTo, EMFModelOrRenderVariable variableToChange, String animKey, String initialExpression, String modelName) {
        float defaultValue;
        this.modelName = modelName;
        this.animKey = animKey;
        this.isVariable = animKey.startsWith("var");
        this.variableToChange = this.isVariable ? null : variableToChange;
        this.partToApplyTo = partToApplyTo;
        if (this.variableToChange != null) {
            if (partToApplyTo == null) {
                if (this.variableToChange.isRenderVariable()) {
                    defaultValue = this.variableToChange.getValue();
                } else {
                    if (EMFConfig.getConfig().logModelCreationData) {
                        EMFUtils.log("null part for " + animKey);
                    }
                    defaultValue = 0.0f;
                }
            } else {
                defaultValue = this.variableToChange.getValue(partToApplyTo);
            }
        } else {
            defaultValue = 0.0f;
        }
        this.prevResult.defaultReturnValue(defaultValue);
        this.expressionString = initialExpression;
    }

    public void setTrueVariableSource(EMFAnimation trueVariableSource) {
        this.trueVariableToSet = trueVariableSource;
    }

    public String toString() {
        return this.animKey;
    }

    public void initExpression(Object2ObjectLinkedOpenHashMap<String, EMFAnimation> emfAnimationVariables, Object2ObjectOpenHashMap<String, EMFModelPart> allPartByName) {
        this.emfAnimationVariables = emfAnimationVariables;
        this.allPartsBySingleAndFullHeirachicalId = allPartByName;
        this.EMFCalculator = MathExpressionParser.getOptimizedExpression(this.expressionString, false, this);
        this.emfAnimationVariables = null;
        this.allPartsBySingleAndFullHeirachicalId = null;
    }

    public float getLastResultOnly() {
        if (EMFAnimationEntityContext.getEMFEntity() == null) {
            return 0.0f;
        }
        return this.prevResult.getFloat((Object)EMFAnimationEntityContext.getEMFEntity().etf$getUuid());
    }

    public float getResultViaCalculate() {
        UUID id;
        UUID uUID = id = EMFAnimationEntityContext.getEMFEntity() == null ? null : EMFAnimationEntityContext.getEMFEntity().etf$getUuid();
        if (id == null) {
            return 0.0f;
        }
        float result = this.calculatorRun();
        result = result == Float.MIN_VALUE ? 0.0f : result;
        this.prevResult.put((Object)id, result);
        return result;
    }

    private float calculatorRun() {
        return this.EMFCalculator.getResult();
    }

    private void sendValueToTrueVariable(float value) {
        if (EMFAnimationEntityContext.getEMFEntity() == null) {
            return;
        }
        UUID id = EMFAnimationEntityContext.getEMFEntity().etf$getUuid();
        this.prevResult.put((Object)id, value);
    }

    public void calculateAndSet() {
        if (EMFConfig.getConfig().animationLODDistance == 0) {
            this.calculateAndSetPostLod();
            return;
        }
        int lodTimer = this.lodTimer.getInt((Object)EMFAnimationEntityContext.getEMFEntity().etf$getUuid());
        int lodResult = lodTimer < 1 ? EMFAnimationEntityContext.getLODFactorOfEntity() : lodTimer - 1;
        this.lodTimer.put((Object)EMFAnimationEntityContext.getEMFEntity().etf$getUuid(), lodResult);
        this.handleResult(lodResult > 0 ? this.getLastResultOnly() : this.getResultViaCalculate());
    }

    private void calculateAndSetPostLod() {
        if (this.isVariable) {
            if (this.trueVariableToSet != null) {
                this.trueVariableToSet.sendValueToTrueVariable(this.getResultViaCalculate());
            } else {
                this.getResultViaCalculate();
            }
        } else {
            this.handleResult(this.getResultViaCalculate());
        }
    }

    private void handleResult(float result) {
        if (this.variableToChange != null) {
            if (Double.isNaN(result)) {
                this.variableToChange.setValue(this.partToApplyTo, Float.MAX_VALUE);
            } else {
                this.variableToChange.setValue(this.partToApplyTo, result);
            }
        }
    }

    public boolean isValid() {
        return this.EMFCalculator != MathExpressionParser.NULL_EXPRESSION;
    }
}

