/*
 * Decompiled with CFR 0.152.
 */
package traben.entity_model_features.models.animation.math;

import traben.entity_model_features.models.animation.math.MathAction;
import traben.entity_model_features.models.animation.math.MathComponent;
import traben.entity_model_features.models.animation.math.MathConstant;
import traben.entity_model_features.models.animation.math.MathValue;

public class MathBinaryExpressionComponent
extends MathValue
implements MathComponent {
    private final MathComponent first;
    private final MathAction action;
    private final MathComponent second;

    private MathBinaryExpressionComponent(MathComponent first, MathAction action, MathComponent second) {
        this.first = first;
        this.action = action;
        this.second = second;
    }

    public static MathComponent getOptimizedExpression(MathComponent first, MathAction action, MathComponent second) {
        MathBinaryExpressionComponent component = new MathBinaryExpressionComponent(first, action, second);
        if (component.first.isConstant() && component.second.isConstant()) {
            return new MathConstant(component.getResult(), false);
        }
        return component;
    }

    @Override
    MathValue.ResultSupplier getResultSupplier() {
        return null;
    }

    @Override
    public float getResult() {
        float value = this.action.execute(this.first, this.second);
        return this.isNegative ? -value : value;
    }

    public String toString() {
        return "[oExp:{" + this.first + ", " + this.action + ", " + this.second + "}=" + this.getResult() + "]";
    }
}

