/*
 * Decompiled with CFR 0.152.
 */
package traben.entity_model_features.models.animation.math;

import it.unimi.dsi.fastutil.chars.CharArrayList;
import it.unimi.dsi.fastutil.chars.CharListIterator;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectList;
import it.unimi.dsi.fastutil.objects.ObjectListIterator;
import java.util.ArrayList;
import java.util.List;
import traben.entity_model_features.models.animation.EMFAnimation;
import traben.entity_model_features.models.animation.math.EMFMathException;
import traben.entity_model_features.models.animation.math.MathAction;
import traben.entity_model_features.models.animation.math.MathBinaryExpressionComponent;
import traben.entity_model_features.models.animation.math.MathComponent;
import traben.entity_model_features.models.animation.math.MathConstant;
import traben.entity_model_features.models.animation.math.MathMethod;
import traben.entity_model_features.models.animation.math.MathValue;
import traben.entity_model_features.models.animation.math.MathVariable;
import traben.entity_model_features.utils.EMFUtils;

public class MathExpressionParser {
    public static final MathComponent NULL_EXPRESSION = () -> {
        EMFUtils.logError("ERROR: NULL_EXPRESSION was called, this should not happen.");
        return Float.NaN;
    };
    private static final List<MathAction> BOOLEAN_COMPARATOR_ACTIONS = List.of(MathAction.EQUALS, MathAction.SMALLER_THAN_OR_EQUALS, MathAction.SMALLER_THAN, MathAction.LARGER_THAN_OR_EQUALS, MathAction.LARGER_THAN, MathAction.NOT_EQUALS);
    private static final List<MathAction> BOOLEAN_LOGICAL_ACTIONS = List.of(MathAction.AND, MathAction.OR);
    private static final List<MathAction> MULTIPLICATION_ACTIONS = List.of(MathAction.MULTIPLY, MathAction.DIVIDE, MathAction.DIVISION_REMAINDER);
    private static final List<MathAction> ADDITION_ACTIONS = List.of(MathAction.ADD, MathAction.SUBTRACT);
    private final String originalExpression;
    private final boolean wasInvertedBooleanExpression;
    private final boolean isNegative;
    private final EMFAnimation calculationInstance;
    private MathComponent optimizedComponent = null;
    private CalculationList components;
    private boolean nextValueIsNegative = false;
    private String caughtExceptionString = null;

    private MathExpressionParser(String expressionString, boolean isNegative, EMFAnimation calculationInstance, boolean invertBoolean) {
        this.isNegative = isNegative;
        this.calculationInstance = calculationInstance;
        this.wasInvertedBooleanExpression = invertBoolean;
        expressionString = expressionString.trim();
        this.originalExpression = expressionString = expressionString.replaceAll("\\s*", "");
        this.components = new CalculationList();
        try {
            RollingReader rollingReader = new RollingReader();
            CharArrayList charList = new CharArrayList(expressionString.toCharArray());
            CharListIterator charIterator = charList.iterator();
            Character firstBooleanChar = null;
            while (charIterator.hasNext()) {
                char currentChar = charIterator.nextChar();
                MathAction asAction = MathAction.getAction(currentChar);
                if (firstBooleanChar != null) {
                    if (asAction == MathAction.BOOLEAN_CHAR) {
                        this.readDoubleBooleanAction(calculationInstance, firstBooleanChar, currentChar);
                        if (!charIterator.hasNext()) {
                            throw new EMFMathException("ERROR: boolean operator [" + firstBooleanChar + currentChar + "] at end of expression for [" + calculationInstance.animKey + "] in [" + calculationInstance.modelName + "].");
                        }
                        currentChar = charIterator.nextChar();
                        asAction = MathAction.getAction(currentChar);
                    } else {
                        this.readLastSingleBooleanAction(calculationInstance, firstBooleanChar, rollingReader);
                    }
                    firstBooleanChar = null;
                }
                if (asAction == MathAction.BOOLEAN_CHAR) {
                    firstBooleanChar = Character.valueOf(currentChar);
                }
                if (asAction == MathAction.SUBTRACT && (this.components.isEmpty() && rollingReader.isEmpty() || !this.components.isEmpty() && this.components.getLast() instanceof MathAction && rollingReader.isEmpty())) {
                    this.nextValueIsNegative = true;
                    continue;
                }
                if (asAction == MathAction.NONE) {
                    rollingReader.write(currentChar);
                    continue;
                }
                if (asAction == MathAction.OPEN_BRACKET) {
                    this.readMethodOrBrackets(rollingReader, charIterator);
                    continue;
                }
                this.readVariableOrConstant(rollingReader);
                if (!rollingReader.isEmpty() || asAction == MathAction.BOOLEAN_CHAR) continue;
                this.components.add(asAction);
            }
            this.readVariableOrConstant(rollingReader);
            if (this.components.isEmpty()) {
                throw new EMFMathException("ERROR: math components found to be empty for [" + calculationInstance.animKey + "] in [" + calculationInstance.modelName + "]");
            }
            CalculationList newComponents = new CalculationList();
            MathComponent lastComponent = null;
            ObjectListIterator objectListIterator = this.components.iterator();
            while (objectListIterator.hasNext()) {
                MathComponent component = (MathComponent)objectListIterator.next();
                if (lastComponent instanceof MathAction && component instanceof MathAction) {
                    MathAction action = (MathAction)component;
                    if (action != MathAction.ADD) {
                        newComponents.add(component);
                    }
                } else {
                    newComponents.add(component);
                }
                lastComponent = component;
            }
            if (newComponents.get(0) == MathAction.ADD) {
                newComponents.remove(0);
            }
            if (newComponents.size() != this.components.size()) {
                this.components = newComponents;
            }
            this.validateAndOptimize();
        }
        catch (EMFMathException e) {
            this.caughtExceptionString = e.toString();
        }
        catch (Exception e) {
            this.caughtExceptionString = "EMF animation ERROR: for [" + calculationInstance.animKey + "] in [" + calculationInstance.modelName + "] cause [" + e + "].";
            e.printStackTrace();
        }
    }

    public static MathComponent getOptimizedExpression(String expressionString, boolean isNegative, EMFAnimation calculationInstance) {
        return MathExpressionParser.getOptimizedExpression(expressionString, isNegative, calculationInstance, false);
    }

    private static MathComponent getOptimizedExpression(String expressionString, boolean isNegative, EMFAnimation calculationInstance, boolean invertBoolean) {
        try {
            MathExpressionParser expression = new MathExpressionParser(expressionString, isNegative, calculationInstance, invertBoolean);
            MathComponent optimized = expression.optimizedComponent;
            if (optimized == null) {
                return NULL_EXPRESSION;
            }
            if (expression.wasInvertedBooleanExpression) {
                return () -> optimized.getResult() == 1.0f ? 0.0f : 1.0f;
            }
            return optimized;
        }
        catch (Exception e) {
            EMFUtils.logError("EMF animation ERROR: for [" + calculationInstance.animKey + "] in [" + calculationInstance.modelName + "] cause [" + e + "].");
            return NULL_EXPRESSION;
        }
    }

    private static String readBracketContents(CharListIterator charIterator) {
        StringBuilder bracketContents = new StringBuilder();
        int nesting = 0;
        while (charIterator.hasNext()) {
            char ch2 = charIterator.nextChar();
            if (ch2 == '(') {
                bracketContents.append(ch2);
                ++nesting;
                continue;
            }
            if (ch2 == ')') {
                if (nesting == 0) break;
                bracketContents.append(ch2);
                --nesting;
                continue;
            }
            bracketContents.append(ch2);
        }
        return bracketContents.toString();
    }

    private void readLastSingleBooleanAction(EMFAnimation calculationInstance, Character firstBooleanChar, RollingReader rollingReader) throws EMFMathException {
        if (firstBooleanChar.charValue() == '!') {
            rollingReader.write('!');
        } else {
            this.components.add(switch (firstBooleanChar.charValue()) {
                case '=' -> MathAction.EQUALS;
                case '&' -> MathAction.AND;
                case '|' -> MathAction.OR;
                case '<' -> MathAction.SMALLER_THAN;
                case '>' -> MathAction.LARGER_THAN;
                default -> throw new EMFMathException("ERROR: with boolean processing for operator [" + firstBooleanChar + "] for [" + calculationInstance.animKey + "] in [" + calculationInstance.modelName + "].");
            });
        }
    }

    private void readDoubleBooleanAction(EMFAnimation calculationInstance, Character firstBooleanChar, char currentChar) throws EMFMathException {
        MathAction doubleAction = switch ("" + firstBooleanChar + currentChar) {
            case "==" -> MathAction.EQUALS;
            case "!=" -> MathAction.NOT_EQUALS;
            case "&&" -> MathAction.AND;
            case "||" -> MathAction.OR;
            case ">=" -> MathAction.LARGER_THAN_OR_EQUALS;
            case "<=" -> MathAction.SMALLER_THAN_OR_EQUALS;
            default -> throw new EMFMathException("ERROR: with boolean processing for operator [" + firstBooleanChar + currentChar + "] for [" + calculationInstance.animKey + "] in [" + calculationInstance.modelName + "].");
        };
        this.components.add(doubleAction);
    }

    private void readMethodOrBrackets(RollingReader rollingReader, CharListIterator charIterator) throws EMFMathException {
        String functionName = rollingReader.read();
        String bracketContents = MathExpressionParser.readBracketContents(charIterator);
        if (functionName.isEmpty() || "!".equals(functionName) || "-".equals(functionName)) {
            this.components.add(MathExpressionParser.getOptimizedExpression(bracketContents, this.getNegativeNext() || "-".equals(functionName), this.calculationInstance, "!".equals(functionName)));
        } else {
            this.components.add(MathMethod.getOptimizedExpression(functionName, bracketContents, this.getNegativeNext(), this.calculationInstance));
        }
    }

    private void readVariableOrConstant(RollingReader rollingReader) throws EMFMathException {
        if (!rollingReader.isEmpty()) {
            String read = rollingReader.read();
            try {
                float asNumber = Float.parseFloat(read);
                this.components.add(new MathConstant(asNumber, this.getNegativeNext()));
            }
            catch (NumberFormatException ignored) {
                this.components.add(MathVariable.getOptimizedVariable(read, this.getNegativeNext(), this.calculationInstance));
            }
        }
    }

    protected void validateAndOptimize() {
        if (this.caughtExceptionString != null) {
            EMFUtils.logWarn(this.caughtExceptionString);
            return;
        }
        if (Double.isNaN(this.validateCalculationAndOptimize())) {
            EMFUtils.logWarn("result was NaN, expression not valid: " + this.originalExpression);
        }
    }

    private boolean getNegativeNext() {
        boolean neg = this.nextValueIsNegative;
        this.nextValueIsNegative = false;
        return neg;
    }

    private float validateCalculationAndOptimize() {
        if (this.components.size() == 1) {
            MathComponent comp = this.components.getLast();
            if (comp instanceof MathConstant) {
                MathConstant constnt = (MathConstant)comp;
                if (this.isNegative) {
                    comp = new MathConstant(-constnt.getResult());
                }
            } else if (comp instanceof MathValue) {
                MathValue val = (MathValue)comp;
                val.isNegative = this.isNegative != val.isNegative;
            }
            this.optimizedComponent = comp;
            return comp.getResult();
        }
        try {
            CalculationList optimised = this.optimiseTheseActionsIntoBinaryComponents(BOOLEAN_LOGICAL_ACTIONS, this.optimiseTheseActionsIntoBinaryComponents(BOOLEAN_COMPARATOR_ACTIONS, this.optimiseTheseActionsIntoBinaryComponents(ADDITION_ACTIONS, this.optimiseTheseActionsIntoBinaryComponents(MULTIPLICATION_ACTIONS, new CalculationList(this.components)))));
            if (optimised.size() == 1) {
                float result = optimised.getLast().getResult();
                if (Float.isNaN(result)) {
                    EMFUtils.logError(" result was NaN in [" + this.calculationInstance.modelName + "] for expression: " + this.originalExpression + " as " + this.components);
                } else {
                    this.optimizedComponent = optimised.getLast();
                    MathComponent mathComponent = this.optimizedComponent;
                    if (mathComponent instanceof MathValue) {
                        MathValue value = (MathValue)mathComponent;
                        value.makeNegative(this.isNegative);
                    }
                }
                return result;
            }
            EMFUtils.logError("ERROR: calculation did not result in 1 component, found: " + optimised + " in [" + this.calculationInstance.animKey + "] in [" + this.calculationInstance.modelName + "].");
            EMFUtils.logError("\texpression was [" + this.originalExpression + "].");
        }
        catch (Exception e) {
            EMFUtils.logError("EMF animation ERROR: expression error in [" + this.calculationInstance.animKey + "] in [" + this.calculationInstance.modelName + "] caused by [" + e + "].");
        }
        return Float.NaN;
    }

    private CalculationList optimiseTheseActionsIntoBinaryComponents(List<MathAction> actionsForThisPass, CalculationList componentsOptimized) {
        ArrayList<MathAction> containedActions = new ArrayList<MathAction>();
        for (MathAction forThisPass : actionsForThisPass) {
            if (!componentsOptimized.contains(forThisPass)) continue;
            containedActions.add(forThisPass);
        }
        if (!containedActions.isEmpty()) {
            CalculationList newComponents = new CalculationList();
            ObjectListIterator compIterator = componentsOptimized.iterator();
            while (compIterator.hasNext()) {
                MathComponent component = (MathComponent)compIterator.next();
                if (component instanceof MathAction) {
                    MathAction action = (MathAction)component;
                    if (containedActions.contains(action)) {
                        MathComponent last = newComponents.getLast();
                        MathComponent next = (MathComponent)compIterator.next();
                        newComponents.removeLast();
                        newComponents.add(MathBinaryExpressionComponent.getOptimizedExpression(last, action, next));
                        continue;
                    }
                    newComponents.add(component);
                    continue;
                }
                newComponents.add(component);
            }
            return newComponents;
        }
        return componentsOptimized;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("{");
        ObjectListIterator objectListIterator = this.components.iterator();
        while (objectListIterator.hasNext()) {
            MathComponent comp = (MathComponent)objectListIterator.next();
            builder.append(comp.toString()).append(" ");
        }
        builder.append("}");
        return builder.toString();
    }

    private static class CalculationList
    extends ObjectArrayList<MathComponent> {
        public CalculationList(CalculationList components) {
            super((ObjectList)components);
        }

        public CalculationList() {
        }

        public MathComponent getLast() {
            return (MathComponent)super.get(this.size - 1);
        }

        public void removeLast() {
            super.remove(this.size - 1);
        }
    }

    private static class RollingReader {
        private StringBuilder builder = new StringBuilder();

        private RollingReader() {
        }

        void clear() {
            this.builder = new StringBuilder();
        }

        void write(char ch) {
            this.builder.append(ch);
        }

        String read() {
            String result = this.builder.toString();
            this.clear();
            return result;
        }

        public String toString() {
            return this.builder.toString();
        }

        boolean isEmpty() {
            return this.builder.isEmpty();
        }
    }
}

