/*
 * Decompiled with CFR 0.152.
 */
package traben.entity_model_features.models.animation.math.methods.optifine;

import java.util.List;
import java.util.Random;
import traben.entity_model_features.models.animation.EMFAnimation;
import traben.entity_model_features.models.animation.math.EMFMathException;
import traben.entity_model_features.models.animation.math.MathComponent;
import traben.entity_model_features.models.animation.math.MathMethod;

public class RandomMethod
extends MathMethod {
    private final boolean hasSeed;

    public RandomMethod(List<String> args, boolean isNegative, EMFAnimation calculationInstance) throws EMFMathException {
        super(isNegative, calculationInstance, args.size());
        boolean bl = this.hasSeed = args.size() == 1 && !args.get(0).isBlank();
        if (this.hasSeed) {
            MathComponent arg = RandomMethod.parseArg(args.get(0), calculationInstance);
            this.setSupplierAndOptimize(() -> new Random((long)arg.getResult()).nextFloat(1.0f), arg);
        } else {
            this.setSupplierAndOptimize(() -> (float)Math.random());
        }
    }

    @Override
    protected boolean canOptimizeForConstantArgs() {
        return this.hasSeed;
    }

    @Override
    protected boolean hasCorrectArgCount(int argCount) {
        return argCount == 1 || argCount == 0;
    }
}

