/*
 * Decompiled with CFR 0.152.
 */
package de.dafuqs.paginatedadvancements;

import de.dafuqs.paginatedadvancements.config.PaginatedAdvancementsConfig;
import de.dafuqs.paginatedadvancements.frames.AdvancementFrameDataLoader;
import de.dafuqs.paginatedadvancements.frames.AdvancementFrameTypeDataLoader;
import java.util.List;
import me.shedaniel.autoconfig.AutoConfig;
import me.shedaniel.autoconfig.ConfigHolder;
import me.shedaniel.autoconfig.ConfigManager;
import me.shedaniel.autoconfig.serializer.JanksonConfigSerializer;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.fabric.api.resource.IdentifiableResourceReloadListener;
import net.fabricmc.fabric.api.resource.ResourceManagerHelper;
import net.minecraft.class_2960;
import net.minecraft.class_3264;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PaginatedAdvancementsClient
implements ClientModInitializer {
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"PaginatedAdvancements");
    public static final String MOD_ID = "paginatedadvancements";
    public static ConfigManager<PaginatedAdvancementsConfig> CONFIG_MANAGER;
    public static PaginatedAdvancementsConfig CONFIG;

    @Contract(value="_ -> new", pure=true)
    @NotNull
    public static class_2960 locate(String name) {
        return new class_2960(MOD_ID, name);
    }

    public void onInitializeClient() {
        ConfigHolder configHolder = AutoConfig.register(PaginatedAdvancementsConfig.class, JanksonConfigSerializer::new);
        CONFIG_MANAGER = (ConfigManager)configHolder;
        CONFIG = (PaginatedAdvancementsConfig)AutoConfig.getConfigHolder(PaginatedAdvancementsConfig.class).getConfig();
        ResourceManagerHelper.get((class_3264)class_3264.field_14188).registerReloadListener((IdentifiableResourceReloadListener)AdvancementFrameTypeDataLoader.INSTANCE);
        ResourceManagerHelper.get((class_3264)class_3264.field_14188).registerReloadListener((IdentifiableResourceReloadListener)AdvancementFrameDataLoader.INSTANCE);
    }

    public static void saveSelectedTab(class_2960 tabIdentifier) {
        if (PaginatedAdvancementsClient.CONFIG.SaveLastSelectedTab) {
            PaginatedAdvancementsClient.CONFIG.LastSelectedTab = tabIdentifier.toString();
            CONFIG_MANAGER.save();
        }
    }

    public static void pinTab(class_2960 tabIdentifier) {
        String identifierString = tabIdentifier.toString();
        if (!PaginatedAdvancementsClient.CONFIG.PinnedTabs.contains(identifierString)) {
            PaginatedAdvancementsClient.CONFIG.PinnedTabs.add(identifierString);
            CONFIG_MANAGER.save();
        }
    }

    public static void unpinTab(class_2960 tabIdentifier) {
        String identifierString = tabIdentifier.toString();
        if (PaginatedAdvancementsClient.CONFIG.PinnedTabs.contains(identifierString)) {
            PaginatedAdvancementsClient.CONFIG.PinnedTabs.remove(identifierString);
            CONFIG_MANAGER.save();
        }
    }

    public static boolean isPinned(class_2960 tabIdentifier) {
        return PaginatedAdvancementsClient.CONFIG.PinningEnabled && PaginatedAdvancementsClient.CONFIG.PinnedTabs.contains(tabIdentifier.toString());
    }

    public static boolean hasPins() {
        return PaginatedAdvancementsClient.CONFIG.PinningEnabled && !PaginatedAdvancementsClient.CONFIG.PinnedTabs.isEmpty();
    }

    public static List<String> getPinnedTabs() {
        return PaginatedAdvancementsClient.CONFIG.PinnedTabs;
    }

    public static int getPinIndex(class_2960 tabIdentifier) {
        return PaginatedAdvancementsClient.CONFIG.PinnedTabs.indexOf(tabIdentifier.toString());
    }
}

