/*
 * Decompiled with CFR 0.152.
 */
package de.dafuqs.paginatedadvancements.frames;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import de.dafuqs.paginatedadvancements.PaginatedAdvancementsClient;
import de.dafuqs.paginatedadvancements.frames.FrameWrapper;
import java.util.HashMap;
import java.util.Map;
import net.fabricmc.fabric.api.resource.IdentifiableResourceReloadListener;
import net.minecraft.class_2960;
import net.minecraft.class_3300;
import net.minecraft.class_3695;
import net.minecraft.class_4309;
import org.jetbrains.annotations.Nullable;

public class AdvancementFrameDataLoader
extends class_4309
implements IdentifiableResourceReloadListener {
    public static final String ID = "advancement_frames";
    public static final AdvancementFrameDataLoader INSTANCE = new AdvancementFrameDataLoader();
    protected static final Map<class_2960, FrameWrapper> ADVANCEMENT_FRAMES = new HashMap<class_2960, FrameWrapper>();

    private AdvancementFrameDataLoader() {
        super(new Gson(), ID);
    }

    protected void apply(Map<class_2960, JsonElement> prepared, class_3300 manager, class_3695 profiler) {
        prepared.forEach((identifier, jsonElement) -> {
            for (JsonElement entry : jsonElement.getAsJsonArray()) {
                JsonObject jsonObject = entry.getAsJsonObject();
                class_2960 advancement = class_2960.method_12829((String)jsonObject.get("advancement").getAsString());
                class_2960 frame = class_2960.method_12829((String)jsonObject.get("frame").getAsString());
                @Nullable FrameWrapper frameWrapper = FrameWrapper.of(frame);
                if (frameWrapper == null) {
                    PaginatedAdvancementsClient.LOGGER.error("Advancement Frame '" + frame + "' for advancement  '" + advancement + "' is unknown");
                    continue;
                }
                ADVANCEMENT_FRAMES.put(advancement, frameWrapper);
            }
        });
    }

    public class_2960 getFabricId() {
        return PaginatedAdvancementsClient.locate(ID);
    }

    @Nullable
    public static FrameWrapper get(class_2960 id) {
        return ADVANCEMENT_FRAMES.getOrDefault(id, null);
    }
}

