/*
 * Decompiled with CFR 0.152.
 */
package de.dafuqs.paginatedadvancements.frames;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import de.dafuqs.paginatedadvancements.PaginatedAdvancementsClient;
import de.dafuqs.paginatedadvancements.client.PaginatedAdvancementFrame;
import java.util.HashMap;
import java.util.Map;
import net.fabricmc.fabric.api.resource.IdentifiableResourceReloadListener;
import net.minecraft.class_124;
import net.minecraft.class_2960;
import net.minecraft.class_3300;
import net.minecraft.class_3518;
import net.minecraft.class_3695;
import net.minecraft.class_4309;
import org.jetbrains.annotations.Nullable;

public class AdvancementFrameTypeDataLoader
extends class_4309
implements IdentifiableResourceReloadListener {
    public static final String ID = "advancement_frame_types";
    public static final AdvancementFrameTypeDataLoader INSTANCE = new AdvancementFrameTypeDataLoader();
    protected static final Map<class_2960, PaginatedAdvancementFrame> FRAMES = new HashMap<class_2960, PaginatedAdvancementFrame>();

    private AdvancementFrameTypeDataLoader() {
        super(new Gson(), ID);
    }

    protected void apply(Map<class_2960, JsonElement> prepared, class_3300 manager, class_3695 profiler) {
        prepared.forEach((identifier, jsonElement) -> {
            JsonObject object = jsonElement.getAsJsonObject();
            for (JsonElement frameEntry : object.get("frames").getAsJsonArray()) {
                JsonObject jsonObject = frameEntry.getAsJsonObject();
                String name = jsonObject.get("name").getAsString();
                class_2960 id = new class_2960(identifier.method_12836(), name);
                int itemOffsetX = class_3518.method_15282((JsonObject)jsonObject, (String)"item_offset_x", (int)0);
                int itemOffsetY = class_3518.method_15282((JsonObject)jsonObject, (String)"item_offset_y", (int)0);
                String formattingString = class_3518.method_15253((JsonObject)jsonObject, (String)"formatting", (String)"green");
                class_124 formatting = class_124.method_533((String)formattingString);
                if (formatting == null) {
                    PaginatedAdvancementsClient.LOGGER.error("Formatting for frame '" + id + "' is invalid: '" + formattingString + "'. Will use default 'green'");
                    formatting = class_124.field_1060;
                }
                class_2960 textureObtained = new class_2960(identifier.method_12836(), "advancements/" + name + "_obtained");
                class_2960 textureUnobtained = new class_2960(identifier.method_12836(), "advancements/" + name + "_unobtained");
                PaginatedAdvancementFrame frame = new PaginatedAdvancementFrame(id, textureObtained, textureUnobtained, itemOffsetX, itemOffsetY, formatting);
                FRAMES.put(id, frame);
            }
        });
    }

    public class_2960 getFabricId() {
        return PaginatedAdvancementsClient.locate(ID);
    }

    @Nullable
    public static PaginatedAdvancementFrame get(class_2960 id) {
        return FRAMES.getOrDefault(id, null);
    }
}

