/*
 * Decompiled with CFR 0.152.
 */
package dev.isxander.debugify;

import dev.isxander.debugify.config.DebugifyConfig;
import dev.isxander.debugify.fixes.BugFix;
import dev.isxander.debugify.fixes.BugFixData;
import dev.isxander.debugify.mixinplugin.DebugifyErrorHandler;
import java.util.List;
import java.util.Map;
import net.fabricmc.api.EnvType;
import net.fabricmc.loader.api.FabricLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.spongepowered.asm.mixin.Mixins;

public class Debugify {
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"Debugify");
    public static final DebugifyConfig CONFIG = new DebugifyConfig();
    public static boolean configWasDirty = false;

    public static void onPreInitialize() {
        CONFIG.preload();
        Mixins.registerErrorHandlerClass((String)DebugifyErrorHandler.class.getName());
    }

    public static void onInitialize() {
        boolean bl = configWasDirty = !CONFIG.doesJsonHaveIdenticalKeys();
        if (configWasDirty) {
            LOGGER.info("Saving config because the loaded bug fixes are different to stored json.");
            CONFIG.save();
        }
        List<String> enabledBugs = CONFIG.getBugFixes().entrySet().stream().filter(Map.Entry::getValue).map(entry -> ((BugFixData)entry.getKey()).bugId()).toList();
        LOGGER.info("Enabled {} bug fixes: {}", (Object)enabledBugs.size(), enabledBugs);
        LOGGER.info("Successfully Debugify'd your game!");
    }

    public static BugFix.Env getEnv() {
        return FabricLoader.getInstance().getEnvironmentType() == EnvType.CLIENT ? BugFix.Env.CLIENT : BugFix.Env.SERVER;
    }
}

