/*
 * Decompiled with CFR 0.152.
 */
package org.embeddedt.modernfix.platform.fabric;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import com.mojang.brigadier.CommandDispatcher;
import java.nio.file.Path;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import net.fabricmc.api.EnvType;
import net.fabricmc.fabric.api.command.v2.CommandRegistrationCallback;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.ModContainer;
import net.fabricmc.loader.api.metadata.CustomValue;
import net.fabricmc.loader.api.metadata.ModMetadata;
import net.minecraft.class_1124;
import net.minecraft.class_1799;
import net.minecraft.class_2168;
import net.minecraft.class_3222;
import net.minecraft.class_7706;
import net.minecraft.class_8710;
import net.minecraft.server.MinecraftServer;
import org.embeddedt.modernfix.ModernFixFabric;
import org.embeddedt.modernfix.core.ModernFixMixinPlugin;
import org.embeddedt.modernfix.platform.ModernFixPlatformHooks;
import org.embeddedt.modernfix.spark.SparkLaunchProfiler;
import org.embeddedt.modernfix.util.CommonModUtil;
import org.objectweb.asm.tree.ClassNode;

public class ModernFixPlatformHooksImpl
implements ModernFixPlatformHooks {
    private static final String verString = FabricLoader.getInstance().getModContainer("modernfix").map(mfModContainer -> mfModContainer.getMetadata().getVersion().getFriendlyString()).orElse("[unknown]");
    private static Multimap<String, String> modOptions;

    @Override
    public boolean isClient() {
        return FabricLoader.getInstance().getEnvironmentType() == EnvType.CLIENT;
    }

    @Override
    public boolean isDedicatedServer() {
        return FabricLoader.getInstance().getEnvironmentType() == EnvType.SERVER;
    }

    @Override
    public String getVersionString() {
        return verString;
    }

    @Override
    public boolean modPresent(String modId) {
        return FabricLoader.getInstance().getModContainer(modId).isPresent();
    }

    @Override
    public boolean isDevEnv() {
        return FabricLoader.getInstance().isDevelopmentEnvironment();
    }

    @Override
    public MinecraftServer getCurrentServer() {
        return (MinecraftServer)ModernFixFabric.theServer.get();
    }

    @Override
    public boolean isEarlyLoadingNormally() {
        return true;
    }

    @Override
    public boolean isLoadingNormally() {
        return true;
    }

    @Override
    public Path getGameDirectory() {
        return FabricLoader.getInstance().getGameDir();
    }

    @Override
    public void sendPacket(class_3222 player, class_8710 packet) {
    }

    @Override
    public void injectPlatformSpecificHacks() {
    }

    @Override
    public void applyASMTransformers(String mixinClassName, ClassNode targetClass) {
    }

    @Override
    public void onServerCommandRegister(Consumer<CommandDispatcher<class_2168>> handler) {
        if (FabricLoader.getInstance().isModLoaded("fabric-command-api-v2")) {
            CommandRegistrationCallback.EVENT.register((dispatcher, arg, env) -> handler.accept(dispatcher));
        }
    }

    @Override
    public Multimap<String, String> getCustomModOptions() {
        if (modOptions == null) {
            modOptions = ArrayListMultimap.create();
            for (ModContainer container : FabricLoader.getInstance().getAllMods()) {
                CustomValue integrations;
                ModMetadata meta = container.getMetadata();
                if (!meta.containsCustomValue("modernfix:integration") || (integrations = meta.getCustomValue("modernfix:integration")).getType() != CustomValue.CvType.OBJECT) continue;
                for (Map.Entry entry : integrations.getAsObject()) {
                    if (((CustomValue)entry.getValue()).getType() != CustomValue.CvType.STRING) continue;
                    modOptions.put((Object)((String)entry.getKey()), (Object)((CustomValue)entry.getValue()).getAsString());
                }
            }
        }
        return modOptions;
    }

    @Override
    public void registerCreativeSearchTrees(class_1124 registry, class_1124.class_7456<class_1799> nameSupplier, class_1124.class_7456<class_1799> tagSupplier, BiConsumer<class_1124.class_1125<class_1799>, List<class_1799>> populator) {
        class_7706.method_47344().method_47308(list -> {
            populator.accept((class_1124.class_1125<class_1799>)class_1124.field_5495, (List<class_1799>)list);
            populator.accept((class_1124.class_1125<class_1799>)class_1124.field_5494, (List<class_1799>)list);
        });
    }

    @Override
    public void onLaunchComplete() {
        if (ModernFixMixinPlugin.instance.isOptionEnabled("feature.spark_profile_launch.OnFabric")) {
            CommonModUtil.runWithoutCrash(() -> SparkLaunchProfiler.stop("launch"), "Failed to stop profiler");
        }
    }

    @Override
    public String getPlatformName() {
        return "Fabric";
    }
}

