/*
 * Decompiled with CFR 0.152.
 */
package me.wolfii.moddetectionpreventer.text;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.zip.GZIPInputStream;
import me.wolfii.moddetectionpreventer.client.ModDetectionPreventerClient;
import net.fabricmc.loader.api.FabricLoader;

public class TranslationFilter {
    private static final Map<String, Set<String>> vanillaTranslations = new HashMap<String, Set<String>>();
    private static final String fileLocation = "data" + File.separator + "vanillaTranslationKeys.gzip";

    public static void loadTranslations() {
        FabricLoader.getInstance().getModContainer("moddetectionpreventer").ifPresentOrElse(modContainer -> modContainer.findPath(fileLocation).ifPresentOrElse(TranslationFilter::readTranslationsFile, () -> ModDetectionPreventerClient.LOGGER.warn("Could not read translations file. Disabling all translations on signs.")), () -> ModDetectionPreventerClient.LOGGER.warn("Could not get modContainer. Disabling all translations on signs."));
    }

    private static void readTranslationsFile(Path translationsPath) {
        try {
            String line;
            InputStream inputStream = Files.newInputStream(translationsPath, new OpenOption[0]);
            GZIPInputStream gzipInputStream = new GZIPInputStream(new BufferedInputStream(inputStream));
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(gzipInputStream));
            while ((line = bufferedReader.readLine()) != null) {
                String[] parts = line.split("\\.", 2);
                Set category = vanillaTranslations.getOrDefault(parts[0], new HashSet());
                if (parts.length > 1) {
                    category.add(parts[1]);
                }
                vanillaTranslations.put(parts[0], category);
            }
        }
        catch (Exception e) {
            ModDetectionPreventerClient.LOGGER.warn("There has been an error loading the vanilla translations. Disabling all translations on signs.");
            ModDetectionPreventerClient.LOGGER.warn(e.getMessage(), (Throwable)e);
        }
    }

    public static boolean isVanillaTranslation(String translationKey) {
        String[] parts = translationKey.split("\\.", 2);
        if (parts.length == 1) {
            return vanillaTranslations.containsKey(parts[0]);
        }
        return vanillaTranslations.getOrDefault(parts[0], Set.of()).contains(parts[1]);
    }
}

