/*
 * Decompiled with CFR 0.152.
 */
package dev.isxander.controlify.bindings;

import com.google.common.collect.ImmutableSet;
import com.google.gson.JsonObject;
import dev.isxander.controlify.Controlify;
import dev.isxander.controlify.api.bind.BindRenderer;
import dev.isxander.controlify.api.bind.ControllerBinding;
import dev.isxander.controlify.api.bind.ControllerBindingBuilder;
import dev.isxander.controlify.bindings.BindContext;
import dev.isxander.controlify.bindings.EmptyBind;
import dev.isxander.controlify.bindings.GamepadBinds;
import dev.isxander.controlify.bindings.IBind;
import dev.isxander.controlify.controller.Controller;
import dev.isxander.controlify.controller.ControllerState;
import dev.isxander.controlify.controller.gamepad.GamepadLike;
import dev.isxander.controlify.controller.gamepad.GamepadState;
import dev.isxander.controlify.controller.joystick.JoystickController;
import dev.isxander.controlify.controller.joystick.JoystickState;
import dev.isxander.controlify.gui.DrawSize;
import dev.isxander.controlify.gui.controllers.GamepadBindController;
import dev.isxander.controlify.gui.controllers.JoystickBindController;
import dev.isxander.yacl3.api.Option;
import dev.isxander.yacl3.api.OptionDescription;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.BooleanSupplier;
import net.minecraft.class_2477;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_304;
import net.minecraft.class_332;
import org.apache.commons.lang3.Validate;
import org.jetbrains.annotations.ApiStatus;

public class ControllerBindingImpl<T extends ControllerState>
implements ControllerBinding {
    private final Controller<T, ?> controller;
    private IBind<T> bind;
    private final IBind<T> defaultBind;
    private BindRenderer renderer;
    private final class_2960 id;
    private final class_2561 name;
    private final class_2561 description;
    private final class_2561 category;
    private final Set<BindContext> contexts;
    private final class_2960 radialIcon;
    private final ControllerBinding.KeyMappingOverride override;
    private static final Map<Controller<?, ?>, Set<IBind<?>>> pressedBinds = new Object2ObjectOpenHashMap();
    private byte fakePressState = 0;

    private ControllerBindingImpl(Controller<T, ?> controller, IBind<T> defaultBind, class_2960 id, ControllerBinding.KeyMappingOverride vanillaOverride, class_2561 name, class_2561 description, class_2561 category, Set<BindContext> contexts, class_2960 icon) {
        this.controller = controller;
        this.defaultBind = defaultBind;
        this.bind = this.defaultBind;
        this.renderer = new BindRendererImpl(this.bind);
        this.id = id;
        this.override = vanillaOverride;
        this.name = name;
        this.description = description;
        this.category = category;
        this.contexts = ImmutableSet.copyOf(contexts);
        this.radialIcon = icon;
    }

    @Override
    public float state() {
        if (this.fakePressState == 1) {
            return 1.0f;
        }
        return this.bind.state(this.controller.state());
    }

    @Override
    public float prevState() {
        if (this.fakePressState == 2) {
            return 1.0f;
        }
        return this.bind.state(this.controller.prevState());
    }

    @Override
    public boolean held() {
        return this.fakePressState == 2 || this.bind.held(this.controller.state());
    }

    @Override
    public boolean prevHeld() {
        return this.fakePressState == 3 || this.bind.held(this.controller.prevState());
    }

    @Override
    public boolean justPressed() {
        if (ControllerBindingImpl.hasBindPressed(this)) {
            return false;
        }
        if (this.held() && !this.prevHeld() || this.fakePressState == 2) {
            ControllerBindingImpl.addPressedBind(this);
            return true;
        }
        return false;
    }

    @Override
    public boolean justReleased() {
        if (ControllerBindingImpl.hasBindPressed(this)) {
            return false;
        }
        if (!this.held() && this.prevHeld() || this.fakePressState == 3) {
            ControllerBindingImpl.addPressedBind(this);
            return true;
        }
        return false;
    }

    @Override
    public void fakePress() {
        this.fakePressState = 1;
    }

    @Override
    public void tick() {
        if (this.fakePressState > 0) {
            this.fakePressState = (byte)(this.fakePressState + 1);
        }
        if (this.fakePressState >= 4) {
            this.fakePressState = 0;
        }
    }

    @Override
    public Optional<class_2960> radialIcon() {
        return Optional.ofNullable(this.radialIcon);
    }

    public void setCurrentBind(IBind<T> bind) {
        this.bind = bind;
        this.renderer = new BindRendererImpl(bind);
        Controlify.instance().config().setDirty();
    }

    public IBind<T> defaultBind() {
        return this.defaultBind;
    }

    @Override
    public void resetBind() {
        this.setCurrentBind(this.defaultBind());
    }

    @Override
    public class_2960 id() {
        return this.id;
    }

    @Override
    public class_2561 name() {
        return this.name;
    }

    @Override
    public class_2561 description() {
        return this.description;
    }

    @Override
    public class_2561 category() {
        return this.category;
    }

    @Override
    public Set<BindContext> contexts() {
        return this.contexts;
    }

    public IBind<T> getBind() {
        return this.bind;
    }

    @Override
    public boolean isUnbound() {
        return this.bind instanceof EmptyBind;
    }

    @Override
    public ControllerBinding.KeyMappingOverride override() {
        return this.override;
    }

    @Override
    public JsonObject toJson() {
        return this.getBind().toJson();
    }

    @Override
    public BindRenderer renderer() {
        return this.renderer;
    }

    @Override
    public Option.Builder<?> startYACLOption() {
        Option.Builder option = Option.createBuilder().name(this.name()).binding(new EmptyBind(), this::getBind, this::setCurrentBind).description(OptionDescription.of((class_2561[])new class_2561[]{this.description()}));
        Controller<T, ?> controller = this.controller;
        if (controller instanceof GamepadLike) {
            GamepadLike gamepad = (GamepadLike)controller;
            option.customController(opt -> new GamepadBindController((Option<IBind<GamepadState>>)opt, gamepad));
        } else {
            controller = this.controller;
            if (controller instanceof JoystickController) {
                JoystickController joystick = (JoystickController)controller;
                option.customController(opt -> new JoystickBindController((Option<IBind<JoystickState>>)opt, joystick));
            } else {
                throw new IllegalStateException("Unknown controller type: " + this.controller.getClass().getName());
            }
        }
        return option;
    }

    public static void clearPressedBinds(Controller<?, ?> controller) {
        if (pressedBinds.containsKey(controller)) {
            pressedBinds.get(controller).clear();
        }
    }

    private static boolean hasBindPressed(ControllerBindingImpl<?> binding) {
        Set pressed = pressedBinds.getOrDefault(binding.controller, Set.of());
        return pressed.containsAll(ControllerBindingImpl.getBinds(binding.bind));
    }

    private static void addPressedBind(ControllerBindingImpl<?> binding) {
        pressedBinds.computeIfAbsent(binding.controller, c -> new ObjectOpenHashSet()).addAll(ControllerBindingImpl.getBinds(binding.bind));
    }

    private static Set<IBind<?>> getBinds(IBind<?> bind) {
        return Set.of(bind);
    }

    private record BindRendererImpl(IBind<?> bind) implements BindRenderer
    {
        @Override
        public void render(class_332 graphics, int x, int centerY) {
            this.bind.draw(graphics, x, centerY);
        }

        @Override
        public DrawSize size() {
            return this.bind.drawSize();
        }
    }

    @ApiStatus.Internal
    public static final class ControllerBindingBuilderImpl<T extends ControllerState>
    implements ControllerBindingBuilder<T> {
        private final Controller<T, ?> controller;
        private IBind<T> bind;
        private class_2960 id;
        private class_2561 name = null;
        private class_2561 description = null;
        private class_2561 category = null;
        private ControllerBinding.KeyMappingOverride override = null;
        private final Set<BindContext> contexts = new HashSet<BindContext>();
        private class_2960 radialIcon = null;

        public ControllerBindingBuilderImpl(Controller<T, ?> controller) {
            this.controller = controller;
        }

        @Override
        public ControllerBindingBuilder<T> identifier(class_2960 id) {
            this.id = id;
            return this;
        }

        @Override
        public ControllerBindingBuilder<T> identifier(String namespace, String path) {
            return this.identifier(new class_2960(namespace, path));
        }

        @Override
        public ControllerBindingBuilder<T> defaultBind(IBind<T> bind) {
            this.bind = bind;
            return this;
        }

        @Override
        public ControllerBindingBuilder<T> defaultBind(GamepadBinds gamepadBind) {
            Controller<T, ?> controller = this.controller;
            if (controller instanceof GamepadLike) {
                GamepadLike gamepad = (GamepadLike)controller;
                this.bind = gamepadBind.forGamepad(gamepad);
            } else {
                this.bind = new EmptyBind();
            }
            return this;
        }

        @Override
        public ControllerBindingBuilder<T> name(class_2561 name) {
            this.name = name;
            return this;
        }

        @Override
        public ControllerBindingBuilder<T> description(class_2561 description) {
            this.description = description;
            return this;
        }

        @Override
        public ControllerBindingBuilder<T> category(class_2561 category) {
            this.category = category;
            return this;
        }

        @Override
        public ControllerBindingBuilder<T> context(BindContext ... contexts) {
            this.contexts.addAll(Set.of(contexts));
            return this;
        }

        @Override
        public ControllerBindingBuilder<T> radialCandidate(class_2960 icon) {
            this.radialIcon = icon;
            return this;
        }

        @Override
        public ControllerBindingBuilder<T> vanillaOverride(class_304 keyMapping, BooleanSupplier toggleable) {
            this.override = new ControllerBinding.KeyMappingOverride(keyMapping, toggleable);
            return this;
        }

        @Override
        public ControllerBindingBuilder<T> vanillaOverride(class_304 keyMapping) {
            return this.vanillaOverride(keyMapping, () -> false);
        }

        @Override
        public ControllerBinding build() {
            Validate.notNull((Object)this.id, (String)"Identifier must be set", (Object[])new Object[0]);
            Validate.notNull(this.bind, (String)"Default bind must be set", (Object[])new Object[0]);
            Validate.notNull((Object)this.category, (String)"Category must be set", (Object[])new Object[0]);
            if (this.name == null) {
                this.name = class_2561.method_43471((String)("controlify.binding." + this.id.method_12836() + "." + this.id.method_12832()));
            }
            if (this.description == null) {
                String descKey = "controlify.binding." + this.id.method_12836() + "." + this.id.method_12832() + ".desc";
                this.description = class_2477.method_10517().method_4678(descKey) ? class_2561.method_43471((String)descKey) : class_2561.method_43473();
            }
            return new ControllerBindingImpl<T>(this.controller, this.bind, this.id, this.override, this.name, this.description, this.category, this.contexts, this.radialIcon);
        }
    }
}

