/*
 * Decompiled with CFR 0.152.
 */
package dev.isxander.controlify.bindings;

import com.google.gson.JsonObject;
import dev.isxander.controlify.bindings.GamepadBind;
import dev.isxander.controlify.controller.gamepad.GamepadLike;
import dev.isxander.controlify.controller.gamepad.GamepadState;
import java.util.Optional;
import java.util.function.Function;

public enum GamepadBinds {
    A_BUTTON(state -> state.gamepadButtons().a(), "a_button"),
    B_BUTTON(state -> state.gamepadButtons().b(), "b_button"),
    X_BUTTON(state -> state.gamepadButtons().x(), "x_button"),
    Y_BUTTON(state -> state.gamepadButtons().y(), "y_button"),
    LEFT_BUMPER(state -> state.gamepadButtons().leftBumper(), "left_bumper"),
    RIGHT_BUMPER(state -> state.gamepadButtons().rightBumper(), "right_bumper"),
    LEFT_STICK_PRESS(state -> state.gamepadButtons().leftStick(), "left_stick_press"),
    RIGHT_STICK_PRESS(state -> state.gamepadButtons().rightStick(), "right_stick_press"),
    START(state -> state.gamepadButtons().start(), "start"),
    BACK(state -> state.gamepadButtons().back(), "back"),
    GUIDE(state -> state.gamepadButtons().guide(), "guide"),
    DPAD_UP(state -> state.gamepadButtons().dpadUp(), "dpad_up"),
    DPAD_DOWN(state -> state.gamepadButtons().dpadDown(), "dpad_down"),
    DPAD_LEFT(state -> state.gamepadButtons().dpadLeft(), "dpad_left"),
    DPAD_RIGHT(state -> state.gamepadButtons().dpadRight(), "dpad_right"),
    LEFT_TRIGGER(state -> Float.valueOf(state.gamepadAxes().leftTrigger()), "left_trigger", true),
    RIGHT_TRIGGER(state -> Float.valueOf(state.gamepadAxes().rightTrigger()), "right_trigger", true),
    LEFT_STICK_FORWARD(state -> Float.valueOf(-Math.min(0.0f, state.gamepadAxes().leftStickY())), "left_stick_up", true),
    LEFT_STICK_BACKWARD(state -> Float.valueOf(Math.max(0.0f, state.gamepadAxes().leftStickY())), "left_stick_down", true),
    LEFT_STICK_LEFT(state -> Float.valueOf(-Math.min(0.0f, state.gamepadAxes().leftStickX())), "left_stick_left", true),
    LEFT_STICK_RIGHT(state -> Float.valueOf(Math.max(0.0f, state.gamepadAxes().leftStickX())), "left_stick_right", true),
    RIGHT_STICK_FORWARD(state -> Float.valueOf(-Math.min(0.0f, state.gamepadAxes().rightStickY())), "right_stick_up", true),
    RIGHT_STICK_BACKWARD(state -> Float.valueOf(Math.max(0.0f, state.gamepadAxes().rightStickY())), "right_stick_down", true),
    RIGHT_STICK_LEFT(state -> Float.valueOf(-Math.min(0.0f, state.gamepadAxes().rightStickX())), "right_stick_left", true),
    RIGHT_STICK_RIGHT(state -> Float.valueOf(Math.max(0.0f, state.gamepadAxes().rightStickX())), "right_stick_right", true);

    public static final String BIND_ID = "gamepad";
    private final Function<GamepadState, Float> state;
    private final String identifier;

    private GamepadBinds(Function<GamepadState, Float> state, String identifier, boolean jvmIsBad) {
        this.state = state;
        this.identifier = identifier;
    }

    private GamepadBinds(Function<GamepadState, Boolean> state, String identifier) {
        this(state1 -> Float.valueOf((Boolean)state.apply((GamepadState)state1) != false ? 1.0f : 0.0f), identifier, true);
    }

    public GamepadBind forGamepad(GamepadLike<?> gamepad) {
        return new GamepadBind(this.state, this.identifier, gamepad);
    }

    public static Optional<GamepadBinds> fromJson(JsonObject object) {
        String name = object.get("bind").getAsString();
        for (GamepadBinds bind : GamepadBinds.values()) {
            if (!bind.identifier.equals(name)) continue;
            return Optional.of(bind);
        }
        return Optional.empty();
    }
}

