/*
 * Decompiled with CFR 0.152.
 */
package dev.isxander.controlify.bindings;

import com.google.gson.JsonObject;
import dev.isxander.controlify.bindings.EmptyBind;
import dev.isxander.controlify.bindings.GamepadBinds;
import dev.isxander.controlify.bindings.JoystickAxisBind;
import dev.isxander.controlify.bindings.JoystickButtonBind;
import dev.isxander.controlify.bindings.JoystickHatBind;
import dev.isxander.controlify.controller.Controller;
import dev.isxander.controlify.controller.ControllerConfig;
import dev.isxander.controlify.controller.ControllerState;
import dev.isxander.controlify.controller.gamepad.GamepadLike;
import dev.isxander.controlify.controller.joystick.SingleJoystickController;
import dev.isxander.controlify.gui.DrawSize;
import net.minecraft.class_332;

public interface IBind<S extends ControllerState> {
    public float state(S var1);

    default public boolean held(S state) {
        return this.state(state) > ((ControllerConfig)this.controller().config()).buttonActivationThreshold;
    }

    public void draw(class_332 var1, int var2, int var3);

    public DrawSize drawSize();

    public JsonObject toJson();

    public Controller<S, ?> controller();

    public static <T extends ControllerState> IBind<T> fromJson(JsonObject json, Controller<T, ?> controller) {
        String type = json.get("type").getAsString();
        if (type.equals("empty")) {
            return new EmptyBind();
        }
        if (controller instanceof GamepadLike) {
            GamepadLike gamepad = (GamepadLike)controller;
            if (type.equals("gamepad")) {
                return GamepadBinds.fromJson(json).map(bind -> bind.forGamepad(gamepad)).orElse(new EmptyBind());
            }
        }
        if (controller instanceof SingleJoystickController) {
            SingleJoystickController joystick = (SingleJoystickController)controller;
            return switch (type) {
                case "joystick_button" -> JoystickButtonBind.fromJson(json, joystick);
                case "joystick_hat" -> JoystickHatBind.fromJson(json, joystick);
                case "joystick_axis" -> JoystickAxisBind.fromJson(json, joystick);
                default -> throw new IllegalStateException("Unknown bind type for joystick: " + type);
            };
        }
        throw new IllegalStateException("Unknown controller type: " + controller.getClass().getName());
    }
}

