/*
 * Decompiled with CFR 0.152.
 */
package dev.isxander.controlify.compatibility.yacl;

import dev.isxander.controlify.controller.Controller;
import dev.isxander.controlify.screenop.ComponentProcessor;
import dev.isxander.controlify.screenop.ScreenProcessor;
import dev.isxander.controlify.utils.HoldRepeatHelper;
import dev.isxander.yacl3.gui.controllers.slider.SliderControllerElement;

public class SliderControllerElementComponentProcessor
implements ComponentProcessor {
    private final SliderControllerElement slider;
    private final HoldRepeatHelper holdRepeatHelper = new HoldRepeatHelper(15, 3);

    public SliderControllerElementComponentProcessor(SliderControllerElement element) {
        this.slider = element;
    }

    @Override
    public boolean overrideControllerButtons(ScreenProcessor<?> screen, Controller<?, ?> controller) {
        boolean left = controller.bindings().CYCLE_OPT_BACKWARD.held();
        boolean leftPrev = controller.bindings().CYCLE_OPT_BACKWARD.prevHeld();
        boolean right = controller.bindings().CYCLE_OPT_FORWARD.held();
        boolean rightPrev = controller.bindings().CYCLE_OPT_FORWARD.prevHeld();
        boolean repeatEventAvailable = this.holdRepeatHelper.canNavigate();
        if (left && (repeatEventAvailable || !leftPrev)) {
            this.slider.incrementValue(-1.0);
            if (!leftPrev) {
                this.holdRepeatHelper.reset();
            }
        } else if (right && (repeatEventAvailable || !rightPrev)) {
            this.slider.incrementValue(1.0);
            if (!rightPrev) {
                this.holdRepeatHelper.reset();
            }
        } else {
            return false;
        }
        this.holdRepeatHelper.onNavigate();
        return true;
    }
}

