/*
 * Decompiled with CFR 0.152.
 */
package dev.isxander.controlify.controller;

import com.google.common.reflect.TypeToken;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import dev.isxander.controlify.Controlify;
import dev.isxander.controlify.bindings.ControllerBindings;
import dev.isxander.controlify.controller.Controller;
import dev.isxander.controlify.controller.ControllerConfig;
import dev.isxander.controlify.controller.ControllerState;
import dev.isxander.controlify.controller.ControllerType;
import dev.isxander.controlify.hid.ControllerHIDService;
import dev.isxander.controlify.rumble.RumbleCapable;
import dev.isxander.controlify.rumble.RumbleSource;
import dev.isxander.controlify.rumble.RumbleState;
import dev.isxander.controlify.utils.Log;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import org.apache.commons.lang3.SerializationUtils;
import org.lwjgl.glfw.GLFW;

public abstract class AbstractController<S extends ControllerState, C extends ControllerConfig>
implements Controller<S, C>,
RumbleCapable {
    protected final int joystickId;
    protected String name;
    private final String uid;
    private final String guid;
    private final ControllerType type;
    private final ControllerHIDService.ControllerHIDInfo hidInfo;
    protected ControllerBindings<S> bindings;
    protected C config;
    protected C defaultConfig;

    public AbstractController(int joystickId, ControllerHIDService.ControllerHIDInfo hidInfo) {
        this.hidInfo = hidInfo;
        this.joystickId = joystickId;
        this.guid = GLFW.glfwGetJoystickGUID((int)joystickId);
        if (hidInfo.hidDevice().isPresent()) {
            this.uid = hidInfo.createControllerUID().orElseThrow();
            this.type = hidInfo.type();
        } else {
            this.uid = "unidentified-guid-" + UUID.nameUUIDFromBytes(this.guid.getBytes());
            this.type = ControllerType.UNKNOWN;
        }
        String joystickName = GLFW.glfwGetJoystickName((int)joystickId);
        String name = this.type != ControllerType.UNKNOWN || joystickName == null ? this.type.friendlyName() : joystickName;
        this.setName(name);
    }

    @Override
    public String name() {
        if (((ControllerConfig)this.config()).customName != null) {
            return ((ControllerConfig)this.config()).customName;
        }
        return this.name;
    }

    protected void setName(String name) {
        Object uniqueName = name;
        int i = 1;
        while (Controlify.instance().getControllerManager().orElseThrow().getConnectedControllers().stream().map(Controller::name).anyMatch(((String)uniqueName)::equalsIgnoreCase)) {
            uniqueName = name + " (" + i++ + ")";
            if (i <= 1000) continue;
            throw new IllegalStateException("Could not find a unique name for controller " + name + " (" + this.uid() + ")! (tried " + i + " times)");
        }
        this.name = uniqueName;
    }

    @Override
    public String uid() {
        return this.uid;
    }

    @Override
    public int joystickId() {
        return this.joystickId;
    }

    @Override
    public ControllerType type() {
        return this.type;
    }

    @Override
    public ControllerBindings<S> bindings() {
        return this.bindings;
    }

    @Override
    public C config() {
        return this.config;
    }

    @Override
    public C defaultConfig() {
        return this.defaultConfig;
    }

    @Override
    public void resetConfig() {
        this.config = this.defaultConfig();
    }

    @Override
    public void setConfig(Gson gson, JsonElement json) {
        ControllerConfig newConfig;
        try {
            newConfig = (ControllerConfig)gson.fromJson(json, new TypeToken<C>(this.getClass()){}.getType());
        }
        catch (Throwable e) {
            Log.LOGGER.error("Could not set config for controller " + this.name() + " (" + this.uid() + ")! Using default config instead. Printing json: " + json.toString(), e);
            Controlify.instance().config().setDirty();
            return;
        }
        if (newConfig != null) {
            this.config = newConfig;
        } else {
            Log.LOGGER.error("Could not set config for controller " + this.name() + " (" + this.uid() + ")! Using default config instead.");
            this.config = (ControllerConfig)SerializationUtils.clone(this.defaultConfig());
            Controlify.instance().config().setDirty();
        }
        ((ControllerConfig)this.config).validateRadialActions(this.bindings);
    }

    @Override
    public Optional<ControllerHIDService.ControllerHIDInfo> hidInfo() {
        return Optional.of(this.hidInfo);
    }

    @Override
    public RumbleState applyRumbleSourceStrength(RumbleState state, RumbleSource source) {
        float strengthMod = ((ControllerConfig)this.config()).getRumbleStrength(source);
        if (source != RumbleSource.MASTER) {
            strengthMod *= ((ControllerConfig)this.config()).getRumbleStrength(RumbleSource.MASTER);
        }
        return state.mul(strengthMod);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AbstractController that = (AbstractController)o;
        return this.uid.equals(that.uid);
    }

    public int hashCode() {
        return Objects.hash(this.uid);
    }
}

