/*
 * Decompiled with CFR 0.152.
 */
package dev.isxander.controlify.controller;

import com.google.common.collect.ImmutableMap;
import dev.isxander.controlify.hid.HIDIdentifier;
import dev.isxander.controlify.utils.Log;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3298;
import org.quiltmc.json5.JsonReader;

public record ControllerType(String friendlyName, String mappingId, String themeId, boolean forceJoystick, boolean dontLoad) {
    public static final ControllerType UNKNOWN = new ControllerType("Unknown", "unknown", "unknown", false, false);
    private static Map<HIDIdentifier, ControllerType> typeMap = null;
    private static final class_2960 hidDbLocation = new class_2960("controlify", "controllers/controller_identification.json5");

    public static ControllerType getTypeForHID(HIDIdentifier hid) {
        if (ControllerType.getTypeMap().containsKey((Object)hid)) {
            return (ControllerType)ControllerType.getTypeMap().get((Object)hid);
        }
        Log.LOGGER.warn("Controller found via USB hardware scan, but it was not found in the controller identification database! (HID: {})", (Object)hid);
        return UNKNOWN;
    }

    public static void ensureTypeMapFilled() {
        if (typeMap != null) {
            return;
        }
        typeMap = new HashMap<HIDIdentifier, ControllerType>();
        try {
            List dbs = class_310.method_1551().method_1478().method_41265("controllers", s -> s.equals((Object)hidDbLocation)).values().stream().flatMap(Collection::stream).toList();
            for (class_3298 resource : dbs) {
                try {
                    BufferedReader resourceReader = resource.method_43039();
                    try {
                        JsonReader reader = JsonReader.json5((Reader)resourceReader);
                        ControllerType.readControllerIdFiles(reader);
                    }
                    finally {
                        if (resourceReader == null) continue;
                        resourceReader.close();
                    }
                }
                catch (Exception e) {
                    Log.LOGGER.error("Failed to load HID DB from source", (Throwable)e);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void readControllerIdFiles(JsonReader reader) throws IOException {
        reader.beginArray();
        while (reader.hasNext()) {
            String friendlyName = null;
            String legacyIdentifier = null;
            String themeId = null;
            String mappingId = "unmapped";
            boolean forceJoystick = false;
            boolean dontLoad = false;
            HashSet<HIDIdentifier> hids = new HashSet<HIDIdentifier>();
            reader.beginObject();
            block19: while (reader.hasNext()) {
                String name = reader.nextName();
                switch (name) {
                    case "name": {
                        friendlyName = reader.nextString();
                        continue block19;
                    }
                    case "identifier": {
                        legacyIdentifier = reader.nextString();
                        continue block19;
                    }
                    case "theme": {
                        themeId = reader.nextString();
                        continue block19;
                    }
                    case "mapping": {
                        mappingId = reader.nextString();
                        continue block19;
                    }
                    case "hids": {
                        reader.beginArray();
                        while (reader.hasNext()) {
                            int vendorId = -1;
                            int productId = -1;
                            reader.beginArray();
                            while (reader.hasNext()) {
                                if (vendorId == -1) {
                                    vendorId = reader.nextInt();
                                    continue;
                                }
                                if (productId == -1) {
                                    productId = reader.nextInt();
                                    continue;
                                }
                                Log.LOGGER.warn("Too many values in HID array. Skipping...");
                                reader.skipValue();
                            }
                            reader.endArray();
                            hids.add(new HIDIdentifier(vendorId, productId));
                        }
                        reader.endArray();
                        continue block19;
                    }
                    case "force_joystick": {
                        forceJoystick = reader.nextBoolean();
                        continue block19;
                    }
                    case "dont_load": {
                        dontLoad = reader.nextBoolean();
                        continue block19;
                    }
                }
                Log.LOGGER.warn("Unknown key in HID DB: " + name + ". Skipping...");
                reader.skipValue();
            }
            reader.endObject();
            if (legacyIdentifier != null) {
                Log.LOGGER.warn("Legacy identifier found in HID DB. Please replace with `theme` and `mapping` (if needed).");
                themeId = legacyIdentifier;
                mappingId = legacyIdentifier;
            }
            if (friendlyName == null || themeId == null || hids.isEmpty()) {
                Log.LOGGER.warn("Invalid entry in HID DB. Skipping...");
                continue;
            }
            ControllerType type = new ControllerType(friendlyName, mappingId, themeId, forceJoystick, dontLoad);
            for (HIDIdentifier hid : hids) {
                typeMap.put(hid, type);
            }
        }
        reader.endArray();
    }

    public static ImmutableMap<HIDIdentifier, ControllerType> getTypeMap() {
        ControllerType.ensureTypeMapFilled();
        return ImmutableMap.copyOf(typeMap);
    }
}

