/*
 * Decompiled with CFR 0.152.
 */
package dev.isxander.controlify.controller.gamepad;

import dev.isxander.controlify.controller.ControllerConfig;
import dev.isxander.controlify.controller.gamepad.BuiltinGamepadTheme;
import dev.isxander.controlify.controller.gamepad.GamepadState;

public class GamepadConfig
extends ControllerConfig {
    private float leftStickDeadzone = 0.15f;
    private float rightStickDeadzone = 0.15f;
    private transient float leftStickDeadzoneX = this.leftStickDeadzone;
    private transient float leftStickDeadzoneY = this.leftStickDeadzone;
    private transient float rightStickDeadzoneX = this.rightStickDeadzone;
    private transient float rightStickDeadzoneY = this.rightStickDeadzone;
    public float gyroLookSensitivity = 0.0f;
    public boolean relativeGyroMode = false;
    public boolean gyroRequiresButton = true;
    public boolean flickStick = false;
    public boolean invertGyroX = false;
    public boolean invertGyroY = false;
    public GamepadState.GyroState gyroCalibration = new GamepadState.GyroState();
    public BuiltinGamepadTheme theme = BuiltinGamepadTheme.DEFAULT;

    public float getLeftStickDeadzone() {
        return this.leftStickDeadzone;
    }

    public float getRightStickDeadzone() {
        return this.rightStickDeadzone;
    }

    public void setLeftStickDeadzone(float deadzone) {
        this.leftStickDeadzoneX = deadzone;
        this.leftStickDeadzoneY = deadzone;
        this.leftStickDeadzone = deadzone;
    }

    public void setRightStickDeadzone(float deadzone) {
        this.rightStickDeadzoneX = deadzone;
        this.rightStickDeadzoneY = deadzone;
        this.rightStickDeadzone = deadzone;
    }

    @Override
    public void setDeadzone(int axis, float deadzone) {
        switch (axis) {
            case 0: {
                this.leftStickDeadzoneX = deadzone;
                break;
            }
            case 1: {
                this.leftStickDeadzoneY = deadzone;
                break;
            }
            case 2: {
                this.rightStickDeadzoneX = deadzone;
                break;
            }
            case 3: {
                this.rightStickDeadzoneY = deadzone;
                break;
            }
            case 4: 
            case 5: {
                break;
            }
        }
        this.leftStickDeadzone = Math.max(this.leftStickDeadzoneX, this.leftStickDeadzoneY);
        this.rightStickDeadzone = Math.max(this.rightStickDeadzoneX, this.rightStickDeadzoneY);
    }

    @Override
    public float getDeadzone(int axis) {
        return switch (axis) {
            case 0, 1 -> this.leftStickDeadzone;
            case 2, 3 -> this.rightStickDeadzone;
            case 4, 5 -> 0.0f;
            default -> throw new IllegalArgumentException("Unknown axis: " + axis);
        };
    }
}

