/*
 * Decompiled with CFR 0.152.
 */
package dev.isxander.controlify.controller.gamepademulated;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import dev.isxander.controlify.Controlify;
import dev.isxander.controlify.bindings.ControllerBindings;
import dev.isxander.controlify.controller.AbstractController;
import dev.isxander.controlify.controller.BatteryLevel;
import dev.isxander.controlify.controller.gamepad.BuiltinGamepadTheme;
import dev.isxander.controlify.controller.gamepad.GamepadLike;
import dev.isxander.controlify.controller.gamepad.GamepadState;
import dev.isxander.controlify.controller.gamepademulated.EmulatedGamepadConfig;
import dev.isxander.controlify.controller.gamepademulated.mapping.AxisMapping;
import dev.isxander.controlify.controller.gamepademulated.mapping.ButtonMapping;
import dev.isxander.controlify.controller.gamepademulated.mapping.UserGamepadMapping;
import dev.isxander.controlify.debug.DebugProperties;
import dev.isxander.controlify.driver.Driver;
import dev.isxander.controlify.driver.gamepad.BasicGamepadState;
import dev.isxander.controlify.driver.joystick.BasicJoystickState;
import dev.isxander.controlify.driver.joystick.JoystickDrivers;
import dev.isxander.controlify.hid.ControllerHIDService;
import dev.isxander.controlify.rumble.RumbleManager;
import dev.isxander.controlify.utils.Log;
import java.util.Set;
import net.minecraft.class_2960;

public class EmulatedGamepadController
extends AbstractController<GamepadState, EmulatedGamepadConfig>
implements GamepadLike<EmulatedGamepadConfig> {
    private GamepadState state = GamepadState.EMPTY;
    private GamepadState prevState = GamepadState.EMPTY;
    private BasicJoystickState joyState;
    private BasicJoystickState prevJoyState;
    private final RumbleManager rumbleManager;
    public final JoystickDrivers drivers;
    private final Set<Driver> uniqueDrivers;

    public EmulatedGamepadController(int joystickId, ControllerHIDService.ControllerHIDInfo hidInfo) {
        super(joystickId, hidInfo);
        this.drivers = JoystickDrivers.forController(joystickId, hidInfo.hidDevice());
        this.uniqueDrivers = this.drivers.getUniqueDrivers();
        this.drivers.printDrivers();
        this.joyState = this.prevJoyState = BasicJoystickState.empty(this.drivers.basicJoystickInputDriver().getNumButtons(), this.drivers.basicJoystickInputDriver().getNumAxes(), this.drivers.basicJoystickInputDriver().getNumHats());
        if (!this.name.startsWith(this.type().friendlyName())) {
            this.setName(this.drivers.nameProviderDriver().getName());
        }
        this.rumbleManager = new RumbleManager(this);
        this.defaultConfig = new EmulatedGamepadConfig();
        this.config = new EmulatedGamepadConfig();
        this.bindings = new ControllerBindings<GamepadState>(this);
        ((EmulatedGamepadConfig)this.config).validateRadialActions(this.bindings);
        ((EmulatedGamepadConfig)this.defaultConfig).validateRadialActions(this.bindings);
    }

    @Override
    public GamepadState state() {
        return this.state;
    }

    @Override
    public GamepadState prevState() {
        return this.prevState;
    }

    public BasicJoystickState joyState() {
        return this.joyState;
    }

    public BasicJoystickState prevJoyState() {
        return this.prevJoyState;
    }

    @Override
    public void updateState() {
        this.prevState = this.state;
        this.prevJoyState = this.joyState;
        this.uniqueDrivers.forEach(Driver::update);
        this.joyState = this.drivers.basicJoystickInputDriver().getBasicJoystickState();
        UserGamepadMapping mapping = ((EmulatedGamepadConfig)this.config).mapping;
        BasicGamepadState basicGamepadState = mapping.mapJoystick(this.joyState);
        GamepadState.AxesState deadzoneAxesState = basicGamepadState.axes().leftJoystickDeadZone(((EmulatedGamepadConfig)this.config).getLeftStickDeadzone()).rightJoystickDeadZone(((EmulatedGamepadConfig)this.config).getRightStickDeadzone());
        this.state = new GamepadState(deadzoneAxesState, basicGamepadState.axes(), basicGamepadState.buttons(), new GamepadState.GyroState(), new GamepadState.GyroState());
        if (DebugProperties.PRINT_GAMEPAD_STATE) {
            Log.LOGGER.info(this.state.toString());
        }
    }

    @Override
    public void clearState() {
        this.state = GamepadState.EMPTY;
        this.joyState = BasicJoystickState.EMPTY;
    }

    @Override
    public RumbleManager rumbleManager() {
        return this.rumbleManager;
    }

    @Override
    public boolean setRumble(float strongMagnitude, float weakMagnitude) {
        if (!this.supportsRumble() || !((EmulatedGamepadConfig)this.config).allowVibrations) {
            return false;
        }
        return this.drivers.rumbleDriver().rumble(Math.min(strongMagnitude, 1.0f), Math.min(weakMagnitude, 1.0f));
    }

    @Override
    public boolean supportsRumble() {
        return this.drivers.rumbleDriver().isRumbleSupported();
    }

    @Override
    public class_2960 icon() {
        String theme = ((EmulatedGamepadConfig)this.config()).theme == BuiltinGamepadTheme.DEFAULT ? this.type().themeId() : ((EmulatedGamepadConfig)this.config()).theme.id();
        return Controlify.id("textures/gui/gamepad/" + theme + "/icon.png");
    }

    @Override
    public BatteryLevel batteryLevel() {
        return this.drivers.batteryDriver().getBatteryLevel();
    }

    @Override
    public boolean supportsGyro() {
        return false;
    }

    @Override
    public GamepadState.GyroStateC gyroState() {
        return GamepadState.GyroStateC.ZERO;
    }

    @Override
    public void close() {
        this.uniqueDrivers.forEach(Driver::close);
    }

    @Override
    public void setConfig(Gson gson, JsonElement json) {
        gson = gson.newBuilder().registerTypeAdapter(ButtonMapping.class, (Object)new ButtonMapping.ButtonMappingSerializer()).registerTypeAdapter(AxisMapping.class, (Object)new AxisMapping.AxisMappingSerializer()).create();
        super.setConfig(gson, json);
        String mappingInputDriverName = ((EmulatedGamepadConfig)this.config).mapping.inputDriverName();
        String currentInputDriverName = this.drivers.basicJoystickInputDriver().getBasicJoystickDetails();
        if (!((EmulatedGamepadConfig)this.config).mapping.inputDriverName().equals(UserGamepadMapping.NO_MAPPING.inputDriverName()) && !mappingInputDriverName.equals(currentInputDriverName)) {
            ((EmulatedGamepadConfig)this.config).mapping = UserGamepadMapping.NO_MAPPING;
            Log.LOGGER.warn("Mapping input driver name does not match current name. This makes the mapping incompatible. Resetting.");
        }
        Log.LOGGER.info("Loaded mapping: " + ((EmulatedGamepadConfig)this.config).mapping);
    }

    @Override
    public int axisCount() {
        return 6;
    }

    @Override
    public int buttonCount() {
        return 15;
    }

    @Override
    public int hatCount() {
        return 0;
    }

    @Override
    public String kind() {
        return "emulated_gamepad";
    }
}

