/*
 * Decompiled with CFR 0.152.
 */
package dev.isxander.controlify.controller.gamepademulated.mapping;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import dev.isxander.controlify.controller.gamepademulated.mapping.MapOrigin;
import dev.isxander.controlify.controller.joystick.JoystickState;
import dev.isxander.controlify.driver.joystick.BasicJoystickState;
import java.lang.reflect.Type;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public interface AxisMapping {
    public float mapAxis(BasicJoystickState var1);

    public MapOrigin origin();

    public static class AxisMappingSerializer
    implements JsonDeserializer<AxisMapping> {
        public AxisMapping deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            MapOrigin origin = (MapOrigin)((Object)context.deserialize(json.getAsJsonObject().get("origin"), MapOrigin.class));
            return switch (origin) {
                default -> throw new IncompatibleClassChangeError();
                case MapOrigin.BUTTON -> (AxisMapping)context.deserialize(json, FromButton.class);
                case MapOrigin.AXIS -> (AxisMapping)context.deserialize(json, FromAxis.class);
                case MapOrigin.HAT -> (AxisMapping)context.deserialize(json, FromHat.class);
                case MapOrigin.NOTHING -> (AxisMapping)context.deserialize(json, FromNothing.class);
            };
        }
    }

    public record FromNothing(float resting, MapOrigin origin) implements AxisMapping
    {
        public FromNothing(float resting) {
            this(resting, MapOrigin.NOTHING);
        }

        @Override
        public float mapAxis(BasicJoystickState state) {
            return this.resting;
        }
    }

    public record FromHat(int hat, JoystickState.HatState hatState, float off, float on, MapOrigin origin) implements AxisMapping
    {
        public FromHat(int hat, JoystickState.HatState hatState, float off, float on) {
            this(hat, hatState, off, on, MapOrigin.HAT);
        }

        @Override
        public float mapAxis(BasicJoystickState state) {
            boolean digitalState = state.hats()[this.hat] == this.hatState;
            return digitalState ? this.on : this.off;
        }
    }

    public record FromAxis(int axis, float inMin, float inMax, float outMin, float outMax, MapOrigin origin) implements AxisMapping
    {
        public FromAxis(int axis, float inMin, float inMax, float outMin, float outMax) {
            this(axis, inMin, inMax, outMin, outMax, MapOrigin.AXIS);
        }

        @Override
        public float mapAxis(BasicJoystickState state) {
            float input = state.axes()[this.axis];
            return (input + (this.outMin - this.inMin)) / (this.inMax - this.inMin) * (this.outMax - this.outMin);
        }
    }

    public record FromButton(int button, float off, float on, MapOrigin origin) implements AxisMapping
    {
        public FromButton(int button, float off, float on) {
            this(button, off, on, MapOrigin.BUTTON);
        }

        @Override
        public float mapAxis(BasicJoystickState state) {
            boolean buttonState = state.buttons()[this.button];
            return buttonState ? this.on : this.off;
        }
    }
}

