/*
 * Decompiled with CFR 0.152.
 */
package dev.isxander.controlify.controller.gamepademulated.mapping;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import dev.isxander.controlify.controller.gamepademulated.mapping.MapOrigin;
import dev.isxander.controlify.controller.joystick.JoystickState;
import dev.isxander.controlify.driver.joystick.BasicJoystickState;
import java.lang.reflect.Type;
import java.util.function.Function;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public interface ButtonMapping {
    public boolean mapButton(BasicJoystickState var1);

    public MapOrigin origin();

    public static class ButtonMappingSerializer
    implements JsonDeserializer<ButtonMapping> {
        public ButtonMapping deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            MapOrigin origin = (MapOrigin)((Object)context.deserialize(json.getAsJsonObject().get("origin"), MapOrigin.class));
            return switch (origin) {
                default -> throw new IncompatibleClassChangeError();
                case MapOrigin.BUTTON -> (ButtonMapping)context.deserialize(json, FromButton.class);
                case MapOrigin.AXIS -> (ButtonMapping)context.deserialize(json, FromAxis.class);
                case MapOrigin.HAT -> (ButtonMapping)context.deserialize(json, FromHat.class);
                case MapOrigin.NOTHING -> (ButtonMapping)context.deserialize(json, FromNothing.class);
            };
        }
    }

    public record FromNothing(boolean def, MapOrigin origin) implements ButtonMapping
    {
        public FromNothing(boolean def) {
            this(def, MapOrigin.NOTHING);
        }

        @Override
        public boolean mapButton(BasicJoystickState state) {
            return this.def;
        }
    }

    public record FromHat(int hat, JoystickState.HatState targetState, boolean invert, MapOrigin origin) implements ButtonMapping
    {
        public FromHat(int hat, JoystickState.HatState targetState, boolean invert) {
            this(hat, targetState, invert, MapOrigin.HAT);
        }

        @Override
        public boolean mapButton(BasicJoystickState state) {
            boolean input;
            boolean bl = input = state.hats()[this.hat] == this.targetState;
            if (this.invert) {
                input = !input;
            }
            return input;
        }
    }

    public record FromAxis(int axis, Function<Float, Boolean> valueMap, MapOrigin origin) implements ButtonMapping
    {
        public static final Function<Float, Boolean> NORMAL = f -> f.floatValue() >= 0.5f;
        public static final Function<Float, Boolean> INVERTED = f -> f.floatValue() <= 0.5f;

        public FromAxis(int axis, Function<Float, Boolean> valueMap) {
            this(axis, valueMap, MapOrigin.AXIS);
        }

        @Override
        public boolean mapButton(BasicJoystickState state) {
            float input = state.axes()[this.axis];
            return this.valueMap.apply(Float.valueOf(input));
        }
    }

    public record FromButton(int button, boolean invert, MapOrigin origin) implements ButtonMapping
    {
        public FromButton(int button, boolean invert) {
            this(button, invert, MapOrigin.BUTTON);
        }

        @Override
        public boolean mapButton(BasicJoystickState state) {
            boolean input = state.buttons()[this.button];
            if (this.invert) {
                input = !input;
            }
            return input;
        }
    }
}

