/*
 * Decompiled with CFR 0.152.
 */
package dev.isxander.controlify.controller.gamepademulated.mapping;

import dev.isxander.controlify.controller.gamepad.GamepadState;
import dev.isxander.controlify.controller.gamepademulated.mapping.AxisMapping;
import dev.isxander.controlify.controller.gamepademulated.mapping.ButtonMapping;
import dev.isxander.controlify.controller.gamepademulated.mapping.GamepadMapping;
import dev.isxander.controlify.driver.gamepad.BasicGamepadState;
import dev.isxander.controlify.driver.joystick.BasicJoystickState;

public record UserGamepadMapping(String inputDriverName, ButtonMapping faceDownButton, ButtonMapping faceLeftButton, ButtonMapping faceRightButton, ButtonMapping faceUpButton, ButtonMapping leftBumper, ButtonMapping rightBumper, ButtonMapping leftSpecial, ButtonMapping rightSpecial, ButtonMapping leftStickDown, ButtonMapping rightStickDown, ButtonMapping dpadUp, ButtonMapping dpadLeft, ButtonMapping dpadDown, ButtonMapping dpadRight, AxisMapping leftStickX, AxisMapping leftStickY, AxisMapping rightStickX, AxisMapping rightStickY, AxisMapping triggerLeft, AxisMapping triggerRight) implements GamepadMapping
{
    public static final UserGamepadMapping NO_MAPPING = new Builder().build();

    @Override
    public BasicGamepadState mapJoystick(BasicJoystickState state) {
        return new BasicGamepadState(new GamepadState.AxesState(this.leftStickX.mapAxis(state), this.leftStickY.mapAxis(state), this.rightStickX.mapAxis(state), this.rightStickY.mapAxis(state), this.triggerLeft.mapAxis(state), this.triggerRight.mapAxis(state)), new GamepadState.ButtonState(this.faceDownButton.mapButton(state), this.faceRightButton.mapButton(state), this.faceLeftButton.mapButton(state), this.faceUpButton.mapButton(state), this.leftBumper.mapButton(state), this.rightBumper.mapButton(state), this.leftSpecial.mapButton(state), this.rightSpecial.mapButton(state), false, this.dpadUp.mapButton(state), this.dpadDown.mapButton(state), this.dpadLeft.mapButton(state), this.dpadRight.mapButton(state), this.leftStickDown.mapButton(state), this.rightStickDown.mapButton(state)));
    }

    public boolean isNoMapping() {
        return this.inputDriverName().equals(NO_MAPPING.inputDriverName());
    }

    public static class Builder {
        private String inputDriverName = "None";
        private ButtonMapping faceDownButton = new ButtonMapping.FromNothing(false);
        private ButtonMapping faceLeftButton = new ButtonMapping.FromNothing(false);
        private ButtonMapping faceRightButton = new ButtonMapping.FromNothing(false);
        private ButtonMapping faceUpButton = new ButtonMapping.FromNothing(false);
        private ButtonMapping leftBumper = new ButtonMapping.FromNothing(false);
        private ButtonMapping rightBumper = new ButtonMapping.FromNothing(false);
        private ButtonMapping leftSpecial = new ButtonMapping.FromNothing(false);
        private ButtonMapping rightSpecial = new ButtonMapping.FromNothing(false);
        private ButtonMapping leftStickDown = new ButtonMapping.FromNothing(false);
        private ButtonMapping rightStickDown = new ButtonMapping.FromNothing(false);
        private ButtonMapping dpadUp = new ButtonMapping.FromNothing(false);
        private ButtonMapping dpadLeft = new ButtonMapping.FromNothing(false);
        private ButtonMapping dpadDown = new ButtonMapping.FromNothing(false);
        private ButtonMapping dpadRight = new ButtonMapping.FromNothing(false);
        private AxisMapping leftStickX = new AxisMapping.FromNothing(0.0f);
        private AxisMapping leftStickY = new AxisMapping.FromNothing(0.0f);
        private AxisMapping rightStickX = new AxisMapping.FromNothing(0.0f);
        private AxisMapping rightStickY = new AxisMapping.FromNothing(0.0f);
        private AxisMapping triggerLeft = new AxisMapping.FromNothing(0.0f);
        private AxisMapping triggerRight = new AxisMapping.FromNothing(0.0f);

        public Builder faceDownButton(ButtonMapping faceDownButton) {
            this.faceDownButton = faceDownButton;
            return this;
        }

        public Builder faceLeftButton(ButtonMapping faceLeftButton) {
            this.faceLeftButton = faceLeftButton;
            return this;
        }

        public Builder faceRightButton(ButtonMapping faceRightButton) {
            this.faceRightButton = faceRightButton;
            return this;
        }

        public Builder faceUpButton(ButtonMapping faceUpButton) {
            this.faceUpButton = faceUpButton;
            return this;
        }

        public Builder leftBumper(ButtonMapping leftBumper) {
            this.leftBumper = leftBumper;
            return this;
        }

        public Builder rightBumper(ButtonMapping rightBumper) {
            this.rightBumper = rightBumper;
            return this;
        }

        public Builder leftSpecial(ButtonMapping leftSpecial) {
            this.leftSpecial = leftSpecial;
            return this;
        }

        public Builder rightSpecial(ButtonMapping rightSpecial) {
            this.rightSpecial = rightSpecial;
            return this;
        }

        public Builder leftStickDown(ButtonMapping leftStickDown) {
            this.leftStickDown = leftStickDown;
            return this;
        }

        public Builder rightStickDown(ButtonMapping rightStickDown) {
            this.rightStickDown = rightStickDown;
            return this;
        }

        public Builder dpadUp(ButtonMapping dpadUp) {
            this.dpadUp = dpadUp;
            return this;
        }

        public Builder dpadLeft(ButtonMapping dpadLeft) {
            this.dpadLeft = dpadLeft;
            return this;
        }

        public Builder dpadDown(ButtonMapping dpadDown) {
            this.dpadDown = dpadDown;
            return this;
        }

        public Builder dpadRight(ButtonMapping dpadRight) {
            this.dpadRight = dpadRight;
            return this;
        }

        public Builder leftStickX(AxisMapping leftStickX) {
            this.leftStickX = leftStickX;
            return this;
        }

        public Builder leftStickY(AxisMapping leftStickY) {
            this.leftStickY = leftStickY;
            return this;
        }

        public Builder rightStickX(AxisMapping rightStickX) {
            this.rightStickX = rightStickX;
            return this;
        }

        public Builder rightStickY(AxisMapping rightStickY) {
            this.rightStickY = rightStickY;
            return this;
        }

        public Builder triggerLeft(AxisMapping triggerLeft) {
            this.triggerLeft = triggerLeft;
            return this;
        }

        public Builder triggerRight(AxisMapping triggerRight) {
            this.triggerRight = triggerRight;
            return this;
        }

        public Builder inputDriverName(String inputDriverName) {
            this.inputDriverName = inputDriverName;
            return this;
        }

        public UserGamepadMapping build() {
            return new UserGamepadMapping(this.inputDriverName, this.faceDownButton, this.faceLeftButton, this.faceRightButton, this.faceUpButton, this.leftBumper, this.rightBumper, this.leftSpecial, this.rightSpecial, this.leftStickDown, this.rightStickDown, this.dpadUp, this.dpadLeft, this.dpadDown, this.dpadRight, this.leftStickX, this.leftStickY, this.rightStickX, this.rightStickY, this.triggerLeft, this.triggerRight);
        }
    }
}

