/*
 * Decompiled with CFR 0.152.
 */
package dev.isxander.controlify.controller.joystick.mapping;

import dev.isxander.controlify.bindings.JoystickAxisBind;
import dev.isxander.controlify.controller.joystick.JoystickState;
import dev.isxander.controlify.controller.joystick.mapping.JoystickMapping;
import dev.isxander.controlify.controller.joystick.render.GenericRenderer;
import dev.isxander.controlify.controller.joystick.render.JoystickRenderer;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.nio.Buffer;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.class_2561;
import org.lwjgl.glfw.GLFW;

public class UnmappedJoystickMapping
implements JoystickMapping {
    public static final UnmappedJoystickMapping EMPTY = new UnmappedJoystickMapping(0, 0, 0);
    private final UnmappedAxis[] axes;
    private final UnmappedButton[] buttons;
    private final UnmappedHat[] hats;

    private UnmappedJoystickMapping(int axisCount, int buttonCount, int hatCount) {
        int i;
        this.axes = new UnmappedAxis[axisCount];
        for (i = 0; i < axisCount; ++i) {
            this.axes[i] = new UnmappedAxis(i, new GenericRenderer.Axis(Integer.toString(i + 1)), false);
        }
        this.buttons = new UnmappedButton[buttonCount];
        for (i = 0; i < buttonCount; ++i) {
            this.buttons[i] = new UnmappedButton(i, new GenericRenderer.Button(Integer.toString(i + 1)));
        }
        this.hats = new UnmappedHat[hatCount];
        for (i = 0; i < hatCount; ++i) {
            this.hats[i] = new UnmappedHat(i);
        }
    }

    public UnmappedJoystickMapping(int joystickId) {
        this(Optional.ofNullable(GLFW.glfwGetJoystickAxes((int)joystickId)).map(Buffer::limit).orElse(0), Optional.ofNullable(GLFW.glfwGetJoystickButtons((int)joystickId)).map(Buffer::limit).orElse(0), Optional.ofNullable(GLFW.glfwGetJoystickHats((int)joystickId)).map(Buffer::limit).orElse(0));
    }

    public UnmappedAxis[] axes() {
        return this.axes;
    }

    @Override
    public JoystickMapping.Button[] buttons() {
        return this.buttons;
    }

    @Override
    public JoystickMapping.Hat[] hats() {
        return this.hats;
    }

    public void setTriggerAxes(int axis, boolean triggerAxis) {
        this.axes[axis].setTriggerAxis(triggerAxis);
    }

    public static final class UnmappedAxis
    implements JoystickMapping.Axis {
        private final int axis;
        private final GenericRenderer.Axis renderer;
        private boolean triggerAxis;

        private UnmappedAxis(int axis, GenericRenderer.Axis renderer, boolean triggerAxis) {
            this.axis = axis;
            this.renderer = renderer;
            this.triggerAxis = triggerAxis;
        }

        @Override
        public float getAxis(JoystickMapping.JoystickData data) {
            float value = data.axes()[this.axis];
            if (this.triggerAxis) {
                value = (value + 1.0f) / 2.0f;
            }
            return value;
        }

        @Override
        public String identifier() {
            return "axis-" + this.axis;
        }

        @Override
        public class_2561 name() {
            return class_2561.method_43469((String)"controlify.joystick_mapping.unmapped.axis", (Object[])new Object[]{this.axis + 1});
        }

        @Override
        public boolean requiresDeadzone() {
            return !this.triggerAxis;
        }

        @Override
        public boolean isAxisResting(float value) {
            return value == this.restingValue();
        }

        @Override
        public float restingValue() {
            return 0.0f;
        }

        @Override
        public String getDirectionIdentifier(int axis, JoystickAxisBind.AxisDirection direction) {
            return direction.name().toLowerCase();
        }

        public int index() {
            return this.axis;
        }

        @Override
        public GenericRenderer.Axis renderer() {
            return this.renderer;
        }

        public boolean isTriggerAxis() {
            return this.triggerAxis;
        }

        public void setTriggerAxis(boolean triggerAxis) {
            this.triggerAxis = triggerAxis;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj == null || obj.getClass() != this.getClass()) {
                return false;
            }
            UnmappedAxis that = (UnmappedAxis)obj;
            return this.axis == that.axis && Objects.equals(this.renderer, that.renderer);
        }

        public int hashCode() {
            return Objects.hash(this.axis, this.renderer);
        }

        public String toString() {
            return "UnmappedAxis[axis=" + this.axis + ", renderer=" + this.renderer + "]";
        }
    }

    private static final class UnmappedButton
    extends Record
    implements JoystickMapping.Button {
        private final int button;
        private final GenericRenderer.Button renderer;

        private UnmappedButton(int button, GenericRenderer.Button renderer) {
            this.button = button;
            this.renderer = renderer;
        }

        @Override
        public boolean isPressed(JoystickMapping.JoystickData data) {
            return data.buttons()[this.button];
        }

        @Override
        public String identifier() {
            return "button-" + this.button;
        }

        @Override
        public class_2561 name() {
            return class_2561.method_43469((String)"controlify.joystick_mapping.unmapped.button", (Object[])new Object[]{this.button + 1});
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{UnmappedButton.class, "button;renderer", "button", "renderer"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{UnmappedButton.class, "button;renderer", "button", "renderer"}, this);
        }

        @Override
        public final boolean equals(Object o) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{UnmappedButton.class, "button;renderer", "button", "renderer"}, this, o);
        }

        public int button() {
            return this.button;
        }

        @Override
        public GenericRenderer.Button renderer() {
            return this.renderer;
        }
    }

    private record UnmappedHat(int hat) implements JoystickMapping.Hat
    {
        @Override
        public JoystickState.HatState getHatState(JoystickMapping.JoystickData data) {
            return data.hats()[this.hat];
        }

        @Override
        public String identifier() {
            return "hat-" + this.hat;
        }

        @Override
        public class_2561 name() {
            return class_2561.method_43469((String)"controlify.joystick_mapping.unmapped.hat", (Object[])new Object[]{this.hat + 1});
        }

        @Override
        public JoystickRenderer renderer(JoystickState.HatState state) {
            return new GenericRenderer.Hat(Integer.toString(this.hat + 1));
        }
    }
}

