/*
 * Decompiled with CFR 0.152.
 */
package dev.isxander.controlify.controller.joystick.render;

import dev.isxander.controlify.bindings.JoystickAxisBind;
import dev.isxander.controlify.controller.joystick.JoystickState;
import dev.isxander.controlify.controller.joystick.render.JoystickRenderer;
import dev.isxander.controlify.gui.DrawSize;
import java.util.Objects;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import org.jetbrains.annotations.Nullable;

public abstract class GenericRenderer
implements JoystickRenderer {
    @Nullable
    protected final String annotation;
    protected final class_310 minecraft = class_310.method_1551();

    public GenericRenderer(@Nullable String annotation) {
        this.annotation = annotation;
    }

    @Override
    public DrawSize render(class_332 graphics, int x, int centerY, int size) {
        if (this.annotation != null) {
            class_327 class_3272 = this.minecraft.field_1772;
            int n = x + size + 2 - this.minecraft.field_1772.method_1727(this.annotation);
            float f = (float)centerY + (float)size / 2.0f;
            Objects.requireNonNull(this.minecraft.field_1772);
            graphics.method_51433(class_3272, this.annotation, n, (int)(f - 9.0f * 0.75f), -1, false);
        }
        return null;
    }

    public static class Hat
    extends GenericRenderer
    implements JoystickRenderer.Hat {
        private static final class_2960 HAT_TEXTURE = new class_2960("controlify", "textures/gui/joystick/generic/hat.png");

        public Hat(@Nullable String annotation) {
            super(annotation);
        }

        @Override
        public DrawSize render(class_332 graphics, int x, int centerY, int size, JoystickState.HatState hatState) {
            graphics.method_51448().method_22903();
            graphics.method_51448().method_46416((float)x, (float)centerY, 0.0f);
            float scale = (float)size / 22.0f;
            graphics.method_51448().method_22905(scale, scale, 1.0f);
            graphics.method_51448().method_46416(0.0f, -22.0f / scale / 2.0f, 0.0f);
            graphics.method_25290(HAT_TEXTURE, 0, 0, (float)(hatState.ordinal() * 22), 0.0f, 22, 22, 22 * JoystickState.HatState.values().length, 22);
            graphics.method_51448().method_22909();
            super.render(graphics, x, centerY, size);
            return new DrawSize(size, size);
        }
    }

    public static class Axis
    extends GenericRenderer
    implements JoystickRenderer.Axis {
        private static final class_2960 AXIS_TEXTURE = new class_2960("controlify", "textures/gui/joystick/generic/axis.png");

        public Axis(@Nullable String annotation) {
            super(annotation);
        }

        @Override
        public DrawSize render(class_332 graphics, int x, int centerY, int size, JoystickAxisBind.AxisDirection direction) {
            graphics.method_51448().method_22903();
            graphics.method_51448().method_46416((float)x, (float)centerY, 0.0f);
            float scale = (float)size / 22.0f;
            graphics.method_51448().method_22905(scale, scale, 1.0f);
            graphics.method_51448().method_46416(0.0f, -22.0f / scale / 2.0f, 0.0f);
            graphics.method_25290(AXIS_TEXTURE, 0, 0, (float)(direction.ordinal() * 22), 0.0f, 22, 22, 22 * JoystickAxisBind.AxisDirection.values().length, 22);
            graphics.method_51448().method_22909();
            super.render(graphics, x, centerY, size);
            return new DrawSize(size, size);
        }
    }

    public static class Button
    extends GenericRenderer
    implements JoystickRenderer.Button {
        private static final class_2960 BUTTON_TEXTURE = new class_2960("controlify", "textures/gui/joystick/generic/button.png");

        public Button(@Nullable String annotation) {
            super(annotation);
        }

        @Override
        public DrawSize render(class_332 graphics, int x, int centerY, int size) {
            graphics.method_51448().method_22903();
            graphics.method_51448().method_46416((float)x, (float)centerY, 0.0f);
            float scale = (float)size / 22.0f;
            graphics.method_51448().method_22905(scale, scale, 1.0f);
            graphics.method_51448().method_46416(0.0f, -22.0f / scale / 2.0f, 0.0f);
            graphics.method_25290(BUTTON_TEXTURE, 0, 0, 0.0f, 0.0f, 22, 22, 22, 22);
            graphics.method_51448().method_22909();
            super.render(graphics, x, centerY, size);
            return new DrawSize(size, size);
        }

        @Override
        public DrawSize render(class_332 graphics, int x, int centerY, int size, boolean down) {
            return this.render(graphics, x, centerY, size);
        }

        @Override
        public DrawSize render(class_332 graphics, int x, int centerY, boolean down) {
            return this.render(graphics, x, centerY, 22);
        }
    }
}

